package com.elitesland.inv.dto.odo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty ;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 11日 13:36
 * @version: 1.0
 */
@Data
@ApiModel(value = "invOdoWmsCallBackParam", description = "出库单wms 回调传参")
public class InvOdoWmsCallBackParam implements Serializable {

    private static final long serialVersionUID = -1271220193903195400L;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "出库单ID（唯一业务key） 不为空")
    private Long id;

    @ApiModelProperty("出库单单号")
    @NotBlank(message = "出库单单号不能为空")
    private String docNo;

    @ApiModelProperty("wms 单号")
    private String wmsNo;

    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;

    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("支持入库单多次收货(多次收货后确认时:" +
            "0:表示入库单最终状态确认;" +
            "1:表示入库单中间状态确认; " +
            "其他情况，则默认0:入库单最终状态" +
            "每次入库传入的数量为增量;")
    private Integer confirmType;

    @ApiModelProperty("外部业务编码(消息ID;用于去重;" +
            "对于同一请求;分配一个唯一性的编码。用来保证因为网络等原因导致重复传输;" +
            "请求 不会被重复处理)")
    @NotBlank(message = "外部业务编码不能为空")
    private String outBizCode;

    @ApiModelProperty("明细信息")
    @NotEmpty(message = "明细信息不能为空")
    private List<OdoWmsCallbackLine> details;

    @Data
    public static class OdoWmsCallbackLine implements Serializable {

        private static final long serialVersionUID = -6478652009258394284L;

        @ApiModelProperty("中台行明细ID（唯一key）")
        @NotNull(message = "中台行明细ID 不为空")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long lineId;

        @ApiModelProperty("商品库存状态")
        private String limit1;

        @ApiModelProperty("商品编码")
        @NotBlank(message = "商品编码不能为空")
        private String itemCode;

        @ApiModelProperty("实际批次")
        private String acLotNo;

        @ApiModelProperty("实际出库数量(基本单位)")
        @NotNull(message = "实际入库数量不能为空（基本单位）")
        private BigDecimal acQty;

        @ApiModelProperty("生产日期")
        private LocalDateTime manuDate;

        @ApiModelProperty("失效日期")
        private LocalDateTime expireDate;

        @ApiModelProperty("入库日期")
        private LocalDateTime stkInDate;

        @ApiModelProperty("生产厂家")
        private String manuFactory;

        private String stkKey;

        public String getLimit1() {
            return StringUtils.isEmpty(this.limit1) ? "OK" : this.limit1;
        }
    }
}
