package com.elitesland.inv.dto.odo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 09月 02日 12:12
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvOdoConfirmParamRpcDTO", description = "库存出库单确认参数")
public class InvOdoConfirmParamRpcDTO implements Serializable {

    private static final long serialVersionUID = -6224855054218706791L;

    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long logisCarrierId;
    /**
     * 物流公司编号
     */
    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;
    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;
    /**
     * 物流费用
     */
    @ApiModelProperty("物流费用")
    private BigDecimal logisFee;
    /**
     * 物流配送人
     */
    @ApiModelProperty("物流配送人")
    private String logisContactName;
    /**
     * 配送人联系方式
     */
    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("出库单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "出库单ID 不能为空")
    private Long id;

}
