package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invTro.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + InvTroProvider.PATH)
public interface InvTroProvider {

    String PATH = "/invTro";

    /**
     * 查询调拨订单支付信息
     *
     * @param troId
     * @return
     */
    @GetMapping("/findPayInfoById")
    ApiResult<List<InvTroPayRpcDTO>> findPayInfoByTroId(@RequestParam("troId") Long troId);

    /**
     * 查询调拨订单明细
     *
     * @param masId
     * @return
     */
    @GetMapping("/findTroDByMasId")
    ApiResult<List<InvTroDRpcDTO>> findTroDByMasId(@RequestParam("masId") Long masId);


    @GetMapping("/findById")
    ApiResult<InvTroRpcDTO> findById(@RequestParam("id") Long id);


    @GetMapping("/findByDocNo")
    ApiResult<InvTroRpcDTO> findByDocNo(@RequestParam("docNO") String docNo);

    /**
     * 更新在线支付信息
     *
     * @param payParamDTO
     */
    @PostMapping("/updateOnlinePay")
    void updateOnlinePay(@RequestBody InvTroOnlinePayParamDTO payParamDTO);

    /**
     * 查询订单在线支付信息
     *
     * @param troId
     * @return
     */
    @GetMapping("/findOnlinePayInfo")
    InvTroOnlinePayRpcDTO findOnlinePayInfo(@RequestParam("troId") Long troId);

    /**
     * 调拨订单关闭
     *
     * @param ids
     */
    @PostMapping("/close")
    void closeTro(@RequestBody List<Long> ids);
}
