package com.elitesland.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.sc.InvScRpcDTO;
import com.elitesland.inv.dto.sc.InvScSaveRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvScProvider.PATH)
public interface InvScProvider {

    String PATH = "/invScProvider";

    /**
     * 新增库存变更单
     * @param invScSaveRpcDTO
     * @return 返回单据唯一标识key
     */
    @PostMapping("/saveInvSc")
    Long saveAndConfirmInvSc(@RequestBody InvScSaveRpcDTO invScSaveRpcDTO);

    @PostMapping("/findByDocNo")
    ApiResult<InvScRpcDTO> findByDocNo(@RequestParam("docNo") String docNo);





}
