package com.elitesland.inv.vo;

/**
 * INV_AJ
 * InvAjDO
 * 库存调整
 *
 * @author lich.chen
 * @date 2020/07/29 13:41:44
 */


import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 库存调整
 */

@Data
@ApiModel(value = "invAjVo", description = "库存调整对象")
public class InvAjVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = 8230656183776345012L;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("调整单状态 [UDC]INV:AJ_STATUS")
    private String docStatus;
    @ApiModelProperty("调整单状态名称")
    private String docStatusName;

    @ApiModelProperty("关联单据号 外部单据号")
    private String relateNo;

    @ApiModelProperty("RMA")
    private String relateDocNo;

    @ApiModelProperty("部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("部门名")
    private String buName;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名")
    private String ouName;

    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty("调整类型 [UDC]INV:AJ_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    private String apprStatus;
    private String apprStatusName;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @SysCode(sys = "yst-supp", mod = "REASON_CODE")
    private String reasonCode;
    private String reasonCodeName;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    private String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    @ApiModelProperty("仓库code")
    private String whCode;
    @ApiModelProperty("仓库名称")
    private String whName;
    private String whType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("交易日期 实际出入库日期")
    private LocalDateTime ioDate;

    @ApiModelProperty("申请人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;
    private String applyEmpName;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    private String procInstStatusName;

    @ApiModelProperty("关联2编号")
    private String relate2No;


    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("是否走接口")
    private Integer intfFlag;

    /**
     */
    @ApiModelProperty("单据来源标示：1为外部过来单据")
    private Integer sourceFlag;

    /**
     * 文件服务器编码
     */
    @ApiModelProperty("文件服务器编码")
    private String fileCode;


    @ApiModelProperty("流程实例ID")
    private String apprProcInstId;

    @ApiModelProperty("提审人ID")
    private Long apprCreateUserId;

    @ApiModelProperty("审批时间")
    @Column()
    @Comment("审批时间")
    private LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    private Long apprUserId;

    @ApiModelProperty("审批人名称")
    private String apprUserName;

    @ApiModelProperty("审批意见")
    private String apprComment;


    @ApiModelProperty("申请描述")
    private String applyDesc;

    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("限定5")
    private String deter5;

    @ApiModelProperty("限定6")
    private String deter6;

    @ApiModelProperty("限定7")
    private String deter7;

    @ApiModelProperty("限定8")
    private String deter8;

    @ApiModelProperty("总数量")
    private BigDecimal qty;

    @ApiModelProperty("数量单位")
    private String qtyUom;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    private String homeCurr;

    @ApiModelProperty("交易币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private Double currRate;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 [UDC]如RMA单，盘点单。COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("关联单据类型")
    private String relateDocType;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联ID")
    private Long relateId;

    @ApiModelProperty("关联2ID")
    private Long relate2Id;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("ES4")
    private String es4;

    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("领域编码")
    private String region;
    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("客户编码")
    private String limit1;

    @ApiModelProperty("库存类型")
    private String limit2;

}


