package com.elitesland.yst.oldcityfood.constant;

import lombok.Getter;

import java.util.Arrays;

/**
 * @Author: Unicorn
 * @Description: 撤销接口枚举
 * @Date: 2023/9/14 16:19
 * @Version: 1.0
 */
@Getter
public enum CancelTransferEnum {

    /**
     * 撤销采购入库
     */
    PUR_CANCLE_PURCHASE_IN("PUR","purchase_in","撤销采购入库","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncPurService","purAsnCancel","com.elitesland.pur.application.service.PurSs2Service","cancelSubmitedPurSs"),

    /**
     * 撤销采购退货出库
     */
    PUR_CANCLE_PURCHASE_OUT("PUR","purchase_out","撤销采购退货出库","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncPurService","purCancel","com.elitesland.pur.application.service.PurRnsRecvService","cancelSubmit"),

    /**
     * 撤销销售出库
     */
    ORDER_CANCLE_ORDER_IN("ORDER","order_in","撤销销售出库","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncSaleService","cancelSaleOrderOut","com.elitesland.oms.application.service.send.SalDoService","cancelShip"),

    /**
     * 撤销销售退货入库
     */
    ORDER_CANCLE_ORDER_OUT("ORDER","order_out","撤销销售退货入库","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncSaleService","cancelSaleReturnOrder","com.elitesland.oms.application.service.doreturn.SalDoReturnService","cancelConfirm"),

    /**
     * 撤销调拨出库通知
     */
    INV_CANCLE_invtrnd("INV","invtrnd","撤销调拨出库通知","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncInvService","invTrnStockOutCancel","com.elitesland.inv.application.service.InvTrnService","withdrawInvTrn"),

    /**
     * 撤销组装入库通知
     */
    INV_CANCLE_assemble_in("INV","assemble_in","撤销组装入库通知","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncInvService","asmCreateOrderCancelCommon","com.elitesland.inv.application.service.InvAsmService","withdrawAsm"),

    /**
     * 撤销组装出库通知
     */
    INV_CANCLE_assemble_out("INV","assemble_out","撤销组装出库通知","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncInvService","asmStockOutCancelCommon","com.elitesland.inv.application.service.InvAsmService","withdrawAsm"),

    /**
     * 撤销拆卸入库通知
     */
    INV_CANCLE_disassembly_in("INV","disassembly_in","撤销拆卸入库通知","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncInvService","dismantleCreateCancelCommon","com.elitesland.inv.application.service.InvAsmService","withdrawAsm"),

    /**
     * 撤销拆卸出库通知
     */
    INV_CANCLE_disassembly_out("INV","disassembly_out","撤销拆卸出库通知","com.elitesland.yst.oldcityfood.modules.oldcityfoodsync.service.","SyncInvService","dismantleOutCancelCommon","com.elitesland.inv.application.service.InvAsmService","withdrawAsm"),

    ;

    /**
     * 业务域code
     */
    private String domain;

    /**
     * 业务单据类型
     */
    private String business;

    /**
     * 描述
     */
    private String desc;

    /**
     * 三方-调用service包名
     */
    private String servicePackage;

    /**
     * 三方-service类名
     */
    private String serviceName;

    /**
     * 三方-调用方法
     */
    private String method;

    /**
     * 中台-调用service包名
     */
    private String ystServicePackage;

    /**
     * 中台-调用方法
     */
    private String ystMethod;

    CancelTransferEnum(String domain, String business, String desc, String servicePackage, String serviceName, String method, String ystServicePackage, String ystMethod) {
        this.domain = domain;
        this.business = business;
        this.desc = desc;
        this.servicePackage = servicePackage;
        this.serviceName = serviceName;
        this.method = method;
        this.ystServicePackage = ystServicePackage;
        this.ystMethod = ystMethod;
    }

    /**
     * 根据业务编码查询对应的单据枚举
     * @param business
     * @return
     */
    public static CancelTransferEnum getByBusiness(String business){
        return Arrays.stream(CancelTransferEnum.values()).filter(e->e.getBusiness().equals(business)).findFirst().orElseThrow();
    }
}
