package com.elitesland.yst.oldcityfood.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.oldcityfood.Application;
import com.elitesland.yst.oldcityfood.constant.CancelTransferEnum;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: Unicorn
 * @Description: 撤销中转接口，调用wms，或者奇门接口
 * @Date: 2023/9/14 16:06
 * @Version: 1.0
 */
@Validated
@FeignClient(name = Application.NAME, path = CancelTransferRpcService.URI, primary = false)
public interface CancelTransferRpcService {

    String URI = Application.URI_PREFIX + "/cancelTransfer";

    /**
     * 撤销通用接口
     * @param id 业务单据id
     * @param cancelTransferEnum 撤销场景枚举
     * @param type 调用类型： SL_WMS, QM_WMS, YST
     * @return
     */
    @GetMapping("/cancel")
    ApiResult cancelTransfer(@RequestParam Long id, @RequestParam CancelTransferEnum cancelTransferEnum,@RequestParam String type);

}
