package com.elitesland.yst.oldcityfood.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.oldcityfood.Application;
import com.elitesland.yst.oldcityfood.rpc.param.query.AccountDayConfigVo;
import com.elitesland.yst.oldcityfood.rpc.param.save.AccountDayConfigParam;
import com.elitesland.yst.oldcityfood.rpc.param.save.AccountDayConfigSearchParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * @Author: Unicorn
 * @Description: 公司结账日配置rpc接口
 * @Date: 2023/10/30 18:08
 * @Version: 1.0
 */
@Validated
@FeignClient(name = Application.NAME, path = CompanyAccountDayRpcService.URI, primary = false)
public interface CompanyAccountDayRpcService {

    String URI = Application.URI_PREFIX + "/companyAccountDay";

    /**
     * 分页获取公司结账日配置信息
     * @param param
     * @return
     */
    @PostMapping("/page")
    ApiResult<PagingVO<AccountDayConfigVo>> pageSearch(@RequestBody AccountDayConfigSearchParam param);

    /**
     * 新增/编辑公司结账日配置信息
     * @param param
     * @return
     */
    @PostMapping("/saveOrUpdate")
    ApiResult<Long> saveOrEdit(@RequestBody AccountDayConfigParam param);

    /**
     * 删除公司结账日配置信息
     * @return
     */
    @DeleteMapping("/delt/{ids}")
    ApiResult delt(@PathVariable List<Long> ids);


    /**
     * 通过公司编码获取结账日
     * @param ouCode
     * @param date
     * @return
     */
    @PostMapping("/getAccountDay")
    String getAccountDay(String ouCode,String date);

}
