package com.elitesland.yst.oldcityfood.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.oldcityfood.Application;
import com.elitesland.yst.oldcityfood.rpc.param.FinArRecVerificationDTO;
import feign.Request;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * 应收收款核销RPC接口.
 *
 * @author shihao.ma
 * @date 2022/9/13
 */
@Validated
@FeignClient(name = Application.NAME, path = FinArRecVerRpcService.URI, primary = false)
public interface FinArRecVerRpcService {

    String URI = Application.URI_PREFIX + "/rpc/ver/apply";

    /**
     * 核销通过
     *
     * @param dto 操作数据
     * @return 数据ID
     */
    @PostMapping(value = "/approve")
    ApiResult<String> approve(@RequestParam(required = false) String bizKey, @RequestBody @Valid List<FinArRecVerificationDTO> dto,Request.Options options);

    /**
     * 取消核销
     *
     * @param dto 操作数据
     * @return 数据ID
     */
    @PostMapping(value = "/cancel")
    ApiResult<String> cancel(@RequestParam(required = false) String bizKey, @RequestBody @Valid List<FinArRecVerificationDTO> dto, Request.Options options);

}
