package com.elitesland.yst.oldcityfood.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.oldcityfood.Application;
import com.elitesland.yst.oldcityfood.rpc.param.ItemSyncRespVO;
import com.elitesland.yst.oldcityfood.rpc.param.query.ItemSyncPageParam;
import io.lettuce.core.dynamic.annotation.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = Application.NAME, path = ItemSyncWmsRpcService.URI, primary = false)
public interface ItemSyncWmsRpcService {

    String URI = Application.URI_PREFIX + "/rpc/sync/item";

    @PostMapping(value = "/page")
    public PagingVO<ItemSyncRespVO> page(@RequestBody ItemSyncPageParam itemSyncPageParam);

    /**
     * 重新推送商品
     * @param id
     * @return
     */
    @PostMapping(value = "/repushProduct")
    ApiResult<Object> repushProduct(@Param("id") String id);

}
