package com.elitesland.yst.production.aftersale.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleSaveVO
 * @Date2023/2/8 14:36
 */
@Data
@ApiModel(description = "车辆激活信息入参")
public class AfterSaleVehicleDTO implements Serializable {

    @ApiModelProperty("唯一标识集合")
    private List<Long> idList;

    @ApiModelProperty(value = "车主ID")
    private Long carOwnerId;

    @ApiModelProperty(value = "车主姓名")
    private String userName;

    @ApiModelProperty(value = "性别")
    private Integer sex;

    @ApiModelProperty(value = "车主手机号")
    private String userPhone;

    @ApiModelProperty(value = "开始日期")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "结束日期")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "激活标识，0：未激活，1：已激活")
    private Integer activatFlat;
}
