package com.elitesland.yst.production.aftersale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.Application;
import com.elitesland.yst.production.aftersale.dto.AfterSaleVehicleDTO;
import com.elitesland.yst.production.aftersale.dto.AfterSaleVehicleRespDTO;
import com.elitesland.yst.production.aftersale.dto.LmSaleLinkDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * ClassName: AfterSaleRpcService
 * Description:
 *
 * @author wz
 * @date 2023/5/19 13:18
 */
@FeignClient(name = Application.NAME, path = Application.PATH + AfterSaleRpcService.URI)
public interface AfterSaleRpcService {
    String URI = "/ownerInfo";

    @PostMapping("/bindVehicleSync")
    ApiResult<List<AfterSaleVehicleRespDTO>> queryVehicle(@RequestBody AfterSaleVehicleDTO afterSaleVehicleDTO);

    @PostMapping("/queryVehicleTypeByItemType5")
    ApiResult<List<LmSaleLinkDTO>> queryVehicleTypeByItemType5(@RequestBody String itemType5);
}
