package com.elitesland.yst.production.aftersale.config.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.AbstractUserDetailManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.model.bo.CarOwnerBasicBO;
import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.function.Supplier;

/**
 * 车主用户来源.
 *
 * @author Kaiser（wang shao） @date 2/15/2023
 */
@Component
@Log4j2
public class UserDetailManagerCarOwner extends AbstractUserDetailManager {

    private final CarOwnerInfoService carOwnerInfoService;

    public UserDetailManagerCarOwner(AuthorizationProperties authorizationProperties,
                                     CarOwnerInfoService carOwnerInfoService) {
        super(authorizationProperties);
        this.carOwnerInfoService = carOwnerInfoService;
    }

    @Override
    public GeneralUserDetails loadUserByUsername(@NotBlank String username) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserByMobile(@NotBlank String mobile) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserByEmail(@NotBlank String email) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserById(@NotBlank String userId) {
        return this.loadUser(() -> carOwnerInfoService.getCarOwnerByCarOwnerId(Long.valueOf(userId)).getData());
    }

    @Override
    public GeneralUserDetails loadUserByAccount(@NotBlank String account) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserByWechatOpenid(@NotBlank String wechatOpenid) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    private GeneralUserDetails loadUser(Supplier<CarOwnerBasicBO> userDTOSupplier) {
        // 查询用户信息
        CarOwnerBasicBO owner = userDTOSupplier.get();
        if (owner == null) {
            return null;
        }

        SysUserDTO userDTO = new SysUserDTO();
        userDTO.setId(owner.getCarOwnerId());
        userDTO.setUsername(CharSequenceUtil.blankToDefault(owner.getUserName(), ""));
        userDTO.setMobile(owner.getUserPhone());
        userDTO.setLastName(userDTO.getUsername());
        userDTO.setEnabled(true);

        userDTO.setSysTenantVO(owner.getTenantDTO());
        var tenantList = new ArrayList<SysTenantDTO>(4);
        if (owner.getTenantDTO() != null) {
            tenantList.add(owner.getTenantDTO());
        }
        userDTO.setSysTenantDTOList(tenantList);

        return super.wrapUserDetails(userDTO);
    }
}
