package com.elitesland.yst.production.aftersale.controller.front;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceExlParam;
import com.elitesland.yst.production.aftersale.model.vo.RepairPartsServiceVO;
import com.elitesland.yst.production.aftersale.service.RepairPartsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/pc/repairParts", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "中台配件列表", tags = {"中台配件列表"})
@RequiredArgsConstructor
@Log4j2
public class FrontRepairPartsController {

    private final RepairPartsService repairPartsService;

    @PostMapping("/repairOrderQuery")
    @ApiOperation("pc端配件列表")
    public ApiResult<PagingVO<RepairPartsServiceVO>> repairOrderQuery(@RequestBody RepairPartsServiceExlParam param) {
        PagingVO<RepairPartsServiceVO> respVOPagingVO = repairPartsService.pageQuery(param);
        return ApiResult.ok(respVOPagingVO);
    }


}
