package com.elitesland.yst.production.aftersale.controller.miniapp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.StoreParam;
import com.elitesland.yst.production.aftersale.model.vo.StoreVO;
import com.elitesland.yst.production.aftersale.service.StoreService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping(value = "/miniApp/store", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "门店", tags = {"门店"})
public class StoreController {
    @Autowired
    private StoreService storeService;


    @PostMapping("/storeQuery")
    @ApiOperation("门店选择查询")
    public ApiResult<PagingVO<StoreVO>> storeQuery(@RequestBody StoreParam param) {
        PagingVO<StoreVO> query = storeService.query(param);
        return ApiResult.ok(query);
    }



}
