package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author RYH
 * @date 2023/2/14
 */
@EqualsAndHashCode(callSuper = true)
@Entity
@Table(name = "complaint_order",indexes = {@Index(name = "idx_order_no",columnList = "order_no,tenantId",unique = true)})
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "complaint_order", comment = "客诉工单")
@Data
@Accessors(chain = true)
@ApiModel(value = "客诉工单", description = "客诉工单")
@Where(clause = "delete_flag = 0")
public class ComplaintOrderDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("工单单号")
    @Column(name = "order_no", columnDefinition = "varchar(255)  comment '工单单号'")
    private String orderNo;

    @ApiModelProperty("问题类型")
    @Column(name = "issue_type", columnDefinition = "varchar(20)  comment '问题类型id'")
    private String issueType;

    @ApiModelProperty("问题描述")
    @Column(name = "issue_description", columnDefinition = "varchar(255)  comment '问题描述'")
    private String issueDescription;

    @ApiModelProperty("客诉类型")
    @Column(name = "order_type", columnDefinition = "int  comment '客诉类型(1:C端投诉, 2.:B端投诉)'")
    private String orderType;

    @ApiModelProperty("车主id")
    @Column(name = "car_owner_id", columnDefinition = "bigint  comment '车主id'")
    private Long carOwnerId;

    @ApiModelProperty("联系人")
    @Column(name = "order_person", columnDefinition = "varchar(255)  comment '联系人'")
    private String orderPerson;

    @ApiModelProperty("联系电话")
    @Column(name = "order_tel", columnDefinition = "varchar(15)  comment '联系电话'")
    private String orderTel;

    @ApiModelProperty("车架号")
    @Column(name = "vehicle_no", columnDefinition = "varchar(50) comment '车架号'")
    private String vehicleNo;

    @ApiModelProperty("车型")
    @Column(name = "vehicle_type", columnDefinition = "varchar(100) comment '车型'")
    private String vehicleType;

    @ApiModelProperty("处理状态")
    @Column(name = "order_status", columnDefinition = "varchar(8) comment '处理状态'")
    private String orderStatus;

    @ApiModelProperty("处理人id")
    @Column(name = "handle_person_id", columnDefinition = "bigint comment '处理人id'")
    private Long handlePersonId;

    @ApiModelProperty("处理人姓名")
    @Column(name = "handle_person_name", columnDefinition = "varchar(30) comment '处理人姓名'")
    private String handlePersonName;

    @ApiModelProperty("处理人电话")
    @Column(name = "handle_person_tel", columnDefinition = "varchar(15) comment '处理人电话'")
    private String handlePersonTel;

    @ApiModelProperty("处理回复")
    @Column(name = "handle_reply", columnDefinition = "varchar(255) comment '处理回复'")
    private String handleReply;

    @ApiModelProperty("C端取消原因udc")
    @Column(name = "cancel_reason_c", columnDefinition = "varchar(40) comment 'C端取消原因udc'")
    private String cancelReasonC;

    @ApiModelProperty("B端取消原因udc")
    @Column(name = "cancel_reason_b", columnDefinition = "varchar(40) comment 'B端取消原因udc'")
    private String cancelReasonB;

    @ApiModelProperty("取消原因明细")
    @Column(name = "cancel_detail", columnDefinition = "varchar(255) comment '详细取消原因'")
    private String cancelDetail;

    @ApiModelProperty("基地")
    @Column(name = "base_no", columnDefinition = "varchar(50) comment '基地'")
    private String baseNo;

    @ApiModelProperty("确认分类")
    @Column(name = "confirm_type", columnDefinition = "varchar(20) comment '确认分类'")
    private String confirmType;

    @ApiModelProperty("问题补充")
    @Column(name = "issue_supplement", columnDefinition = "varchar(255) comment '问题补充'")
    private String issueSupplement;

    @ApiModelProperty("细分分类")
    @Column(name = "subdivision_type", columnDefinition = "varchar(50) comment '细分分类'")
    private String subdivisionType;

    @ApiModelProperty("时效状态")
    @Column(name = "timeout_status", columnDefinition = "varchar(50) comment '时效状态'")
    private String timeoutStatus;

    @ApiModelProperty("派单人id")
    @Column(name = "dispatch_person_id", columnDefinition = "bigint comment '派单人id'")
    private Long dispatchPersonId;

    @ApiModelProperty("派单时间")
    @Column(name = "dispatch_time", columnDefinition = "datetime comment '派单时间'")
    private LocalDateTime dispatchTime;

    @ApiModelProperty("完成时间")
    @Column(name = "complete_time", columnDefinition = "datetime comment '完成时间'")
    private LocalDateTime completeTime;

    @ApiModelProperty("所属经销商名称")
    @Column(name = "cust_name", columnDefinition = "varchar(255) comment '客户名称'")
    private String custName;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof ComplaintOrderDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
