package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @Context:
 * @title: maintain_card_info
 * @Author： 郑杰
 * @Date: 2023/2/14 9:57
 */
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "maintain_card_info")
@Data
@ApiModel(value = "车辆配件三包信息",description = "车辆配件三包信息")
@Where(clause = "delete_flag = 0")
public class MaintainCardInfoDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;
    
    @Column(name = "mountings_name")
    private String mountingsName;
    
    @Column(name = "maintain_time")
    private double maintainTime;
    
    @Column(name = "repair_start_time")
    private LocalDate repairStartTime;
    
    @Column(name = "repair_end_time")
    private LocalDate repairEndTime;
    
    @Column(name = "vehicle_three_pack_no")
    private Long vehicleThreePackNo;

    @ApiModelProperty("三包内容")
    @Column(name = "contain_three_pack", columnDefinition = "varchar(255) comment '三包内容'")
    private String containThreePack;

    @ApiModelProperty("非三包内容")
    @Column(name = "not_contain_three_pack", columnDefinition = "varchar(255) comment '非三包内容'")
    private String notContainThreePack;
    
    @Column(name = "consumer_warranty_time_uom")
    private String consumerWarrantyTimeUom;
    
    @Column(name = "config_id")
    private Long configId;
    
}
