package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
public class RepairPartsServiceExlParam extends AbstractExportQueryParam implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("唯一主键")
    Long id;
    @ApiModelProperty("配件id")
    Long partsId;

    @ApiModelProperty("所属维修工单id")
    Long repairId;

    @ApiModelProperty("所属维修工单id")
    List<Long> repairIdList;

    @ApiModelProperty("配件名称")
    String partsName;

    @ApiModelProperty("配件售价")
    BigDecimal partsPrice;

    @ApiModelProperty("服务价格")
    BigDecimal servicePrice;

    @ApiModelProperty("服务类型")
    String serviceType;







    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof RepairPartsServiceExlParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
