package com.elitesland.yst.production.aftersale.model.vo;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 支持树形结构的数据需要的字段
 * @author Chris
 * @date 2021-03-14
 */
@Data
@MappedSuperclass
public class TreeModel extends BaseModel {

    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级ID")
    @Comment("上级ID")
    @Column(length = 20, nullable = false)
    private Long pid = 0L;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    @Comment("排序号")
    @Column(columnDefinition = "int(11) default 0 comment '排序号'")
    private Integer sortNo;
}
