package com.elitesland.yst.production.aftersale.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderExlParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.service.ComplaintOrderService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author RYH
 * @date 2023/8/19
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ComplaintOrderExportServiceImpl implements DataExport<ComplaintOrderVO, ComplaintOrderExlParam> {
    private final ComplaintOrderService complaintOrderService;

    @Override
    public String getTmplCode() {
        return "complaint_order_export";
    }

    @Override
    public PagingVO<ComplaintOrderVO> execute(ComplaintOrderExlParam param, int page, int pageSize) {
        param.setSize(800);
        return complaintOrderService.export(param);
    }

    @Override
    public String exportFileName() {
        return "客诉工单导出";
    }
}
