/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.yst.production.aftersale.config.AuthorizationServiceConfiguration;
import com.elitesland.yst.production.aftersale.constant.Constant;
import com.elitesland.yst.production.aftersale.convert.CarOwnerInfoConvert;
import com.elitesland.yst.production.aftersale.model.bo.CarOwnerBasicBO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoMngParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoParam;
import com.elitesland.yst.production.aftersale.model.param.RegisterMemberParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerPageInfoVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.provider.system.SystemRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerInfoRepoProc;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CarOwnerInfoServiceImpl
extends BaseServiceImpl
implements CarOwnerInfoService {
    private static final Logger log = LogManager.getLogger(CarOwnerInfoServiceImpl.class);
    @Autowired
    private Constant constant;
    @Autowired
    private VerifyCodeManager verifyCodeManager;
    @Autowired
    private CarOwnerInfoRepo carOwnerInfoRepo;
    @Autowired
    private CarOwnerInfoRepoProc carOwnerInfoRepoProc;
    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;
    @Autowired
    private UserService userService;
    @Autowired
    private MaintainCardService maintainCardService;
    @Autowired
    private SystemRpcProvider systemRpcProvider;
    @Autowired
    private AuthorizationServiceConfiguration authorizationServiceConfiguration;
    @Autowired
    private RedissonClient redissonClient;
    @Value(value="${file.upload.url}")
    private String pictureURL;
    private final String AFTER_KAPCHA = "AFTER_KAPCHA";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> save(CarOwnerInfoParam carOwnerInfoParam) {
        Long userId = this.userService.getUserId();
        carOwnerInfoParam.setCarOwnerId(userId);
        CarOwnerInfoDO ownerInfoDO = this.carOwnerInfoRepo.findByCarOwnerId(carOwnerInfoParam.getCarOwnerId());
        if (Optional.ofNullable(ownerInfoDO).isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        CarOwnerInfoDO carOwnerInfoDO = CarOwnerInfoConvert.INSTANCE.carOwnerInfoVOTODO(carOwnerInfoParam);
        carOwnerInfoDO.setId(ownerInfoDO.getId());
        carOwnerInfoDO.setCasUserId(ownerInfoDO.getCasUserId());
        if (StringUtils.isNotBlank((CharSequence)carOwnerInfoParam.getBirthdayTime())) {
            carOwnerInfoDO.setBirthdayTime(this.constant.swapTimeMin(carOwnerInfoParam.getBirthdayTime()));
        }
        if (StringUtils.isBlank((CharSequence)carOwnerInfoDO.getUserName())) {
            // empty if block
        }
        if (StringUtils.isBlank((CharSequence)carOwnerInfoDO.getUserName())) {
            carOwnerInfoDO.setUserName("\u7acb\u9a6c\u8f66\u4e3b" + this.constant.getRandomNum(8));
        }
        this.carOwnerInfoRepo.save((Object)carOwnerInfoDO);
        this.carOwnerVehicleService.updateCarowner(carOwnerInfoDO);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> query() {
        Long userId = this.userService.getUserId();
        CarOwnerInfoDO carOwnerInfoDO = this.carOwnerInfoRepo.findByCarOwnerId(userId);
        if (!StringUtils.isEmpty((CharSequence)carOwnerInfoDO.getUrl()) && !carOwnerInfoDO.getUrl().startsWith("http")) {
            carOwnerInfoDO.setUrl(this.pictureURL + carOwnerInfoDO.getUrl());
        }
        return ApiResult.ok((Object)((Object)carOwnerInfoDO));
    }

    @Override
    public ApiResult<Object> pageInfoQuery() {
        ApiResult<Object> bindVehicleQuery;
        List bindVehicleQueryData;
        Long userId = this.userService.getUserId();
        CarOwnerPageInfoVO pageInfo = this.carOwnerInfoRepoProc.findPageInfo(userId);
        if (Optional.ofNullable(pageInfo).isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (!StringUtils.isEmpty((CharSequence)pageInfo.getUrl()) && !pageInfo.getUrl().startsWith("http")) {
            pageInfo.setUrl(this.pictureURL + pageInfo.getUrl());
        }
        if (CollUtil.isEmpty((Collection)(bindVehicleQueryData = (List)(bindVehicleQuery = this.carOwnerVehicleService.bindVehicleQuery()).getData()))) {
            ApiResult.ok((Object)pageInfo);
        }
        pageInfo.setCarOwnerVehicleInfoVOs(bindVehicleQueryData);
        return ApiResult.ok((Object)pageInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> registerCarOwnerOnNotExists(String phone, Long casUserId, String userName) {
        block11: {
            String lockKey = "11" + phone + "-" + casUserId;
            RLock rLock = this.redissonClient.getLock("CarOwner:" + lockKey);
            try {
                if (!rLock.tryLock(5L, 300L, TimeUnit.SECONDS)) {
                    throw new BusinessException("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                if (this.redissonClient.getBucket(lockKey).get() == null) {
                    this.redissonClient.getBucket(lockKey).set((Object)"k", 3L, TimeUnit.SECONDS);
                    break block11;
                }
                throw new BusinessException("\u76f8\u540c\u65f6\u95f4\u5185\u5b58\u5728\u7591\u4f3c\u91cd\u590d\u63d0\u4ea4");
            }
            catch (BusinessException | InterruptedException e) {
                throw new BusinessException("\u6ce8\u518c\u5b58\u5728\u5f02\u5e38");
            }
            finally {
                if (rLock.isHeldByCurrentThread()) {
                    rLock.unlock();
                }
            }
        }
        Long tenantId = this.obtainTenantIdFromWechat();
        Assert.notNull((Object)tenantId, (String)"\u672a\u77e5\u5c0f\u7a0b\u5e8f\u6240\u5c5e\u79df\u6237");
        if (StringUtils.isBlank((CharSequence)userName)) {
            // empty if block
        }
        if (StringUtils.isBlank((CharSequence)userName)) {
            userName = "\u7acb\u9a6c\u8f66\u4e3b" + this.constant.getRandomNum(8);
        }
        if (((String)userName).contains("auto")) {
            userName = "\u7acb\u9a6c\u8f66\u4e3b" + this.constant.getRandomNum(8);
        }
        String finalUserName = userName;
        Supplier<Long> supplierCarOwnerQuery = () -> {
            Long carOwnerId = this.carOwnerInfoRepoProc.findByCasUserIdAndUserPhone(phone, casUserId);
            if (carOwnerId != null) {
                return carOwnerId;
            }
            Long aLong = this.carOwnerInfoRepoProc.findByUserPhone(phone);
            if (aLong == null) {
                CarOwnerInfoDO carOwnerInfoDO = new CarOwnerInfoDO();
                carOwnerInfoDO.setCarOwnerId(IdUtil.getSnowflakeNextId());
                log.info("\u6ce8\u518c\u8f66\u4e3b{}, {}", (Object)tenantId, (Object)carOwnerInfoDO.getCarOwnerId());
                carOwnerInfoDO.setUserPhone(phone);
                carOwnerInfoDO.setCasUserId(casUserId);
                carOwnerInfoDO.setUserName(finalUserName);
                carOwnerInfoDO.setTenantId(tenantId);
                return ((CarOwnerInfoDO)((Object)((Object)this.carOwnerInfoRepo.save((Object)carOwnerInfoDO)))).getCarOwnerId();
            }
            throw new BusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a,\u8bf7\u68c0\u67e5!");
        };
        SysTenantDTO tenant = this.tenantClientProvider.getTenant(tenantId);
        Long curOwnerId = tenant == null ? supplierCarOwnerQuery.get() : (Long)this.tenantDataIsolateProvider.byTenantDirectly(supplierCarOwnerQuery::get, tenant);
        return ApiResult.ok((Object)curOwnerId);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> registerMemberPc(String phone, String userName, Long casUserId) {
        CarOwnerInfoDO carOwnerInfoDO = new CarOwnerInfoDO();
        carOwnerInfoDO.setCarOwnerId(IdUtil.getSnowflakeNextId());
        log.info("\u751f\u6210\u7684\u8f66\u4e3bid {}", (Object)carOwnerInfoDO.getCarOwnerId());
        carOwnerInfoDO.setUserPhone(phone);
        carOwnerInfoDO.setCasUserId(casUserId);
        if (StringUtils.isBlank((CharSequence)userName)) {
            // empty if block
        }
        carOwnerInfoDO.setUserName((String)(StringUtils.isNotEmpty((CharSequence)userName) ? userName : "\u7acb\u9a6c\u8f66\u4e3b" + this.constant.getRandomNum(8)));
        CarOwnerInfoDO save = (CarOwnerInfoDO)((Object)this.carOwnerInfoRepo.save((Object)carOwnerInfoDO));
        return ApiResult.ok((Object)save.getCarOwnerId());
    }

    @Override
    public ApiResult<CarOwnerBasicBO> getCarOwnerByCarOwnerId(Long carOwnerId) {
        Long tenantId = this.obtainTenantIdFromWechat();
        log.error("\u8f66\u4e3b\u8ba4\u8bc1\uff1a{}, {}", (Object)tenantId, (Object)carOwnerId);
        SysTenantDTO tenant = this.tenantClientProvider.getTenant(tenantId);
        return (ApiResult)this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            CarOwnerInfoDO carOwnerInfoDO = this.carOwnerInfoRepo.findByCarOwnerId(carOwnerId);
            if (Optional.ofNullable(carOwnerInfoDO).isPresent()) {
                Result userByMobile = UserTransferHelper.getInstance((String)this.authorizationServiceConfiguration.getAuthServer()).getUserByMobile(carOwnerInfoDO.getUserPhone());
                if (userByMobile.getSuccess().equals(false)) {
                    throw new BusinessException("getCarOwnerByCarOwnerId\u8c03\u7528\u8ba4\u8bc1\u57df\u5f02\u5e38\uff0c" + userByMobile.getMsg());
                }
                if (Objects.isNull(userByMobile.getData())) {
                    throw new BusinessException("\u8ba4\u8bc1\u57df-\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u8d26\u53f7\u4fe1\u606f\u4e3a\u7a7a\uff0c" + userByMobile.getMsg());
                }
                CarOwnerBasicBO carOwnerBasicBO = new CarOwnerBasicBO();
                carOwnerBasicBO.setCarOwnerId(carOwnerInfoDO.getCarOwnerId());
                carOwnerBasicBO.setUserName(((AuthUserDTO)userByMobile.getData()).getUsername());
                carOwnerBasicBO.setUserPhone(carOwnerInfoDO.getUserPhone());
                carOwnerBasicBO.setTenantDTO(tenant);
                return ApiResult.ok((Object)carOwnerBasicBO);
            }
            return ApiResult.ok();
        }, tenant);
    }

    @Override
    @SysCodeProc
    public PagingVO<CarOwnerInfoMngRespVO> ownerInfoMngQuery(CarOwnerInfoMngParam param) {
        PagingVO<CarOwnerInfoMngRespVO> ownerInfoMngQuery = this.carOwnerInfoRepoProc.ownerInfoMngQuery(param);
        ownerInfoMngQuery.getRecords().forEach(vo -> {
            if (!StringUtils.isEmpty((CharSequence)vo.getUrl()) && !vo.getUrl().startsWith("http")) {
                vo.setUrl(this.pictureURL + vo.getUrl());
            }
        });
        return ownerInfoMngQuery;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void ownerInfoMngUpdateStatus(List<Long> casUserIds, boolean enabled, int enabledFlag) {
        if (!CollUtil.isEmpty(casUserIds)) {
            casUserIds.stream().forEach(casUserId -> {
                log.info("\u542f\u7528/\u7981\u7528\u4f1a\u5458\u3010{}, {}, {}\u3011", casUserId, (Object)enabled, (Object)enabledFlag);
                Result userData = UserTransferHelper.getInstance((String)this.authorizationServiceConfiguration.getAuthServer()).updateEnabled(casUserId.longValue(), enabled);
                if (userData.getSuccess().equals(false)) {
                    throw new BusinessException("\u542f\u7528/\u7981\u7528\u4f1a\u5458\u5931\u8d25\uff0c" + userData.getMsg());
                }
                this.carOwnerInfoRepoProc.updateEnabledFlag((Long)casUserId, enabledFlag);
            });
        }
    }

    @Override
    @SysCodeProc
    public CarOwnerInfoMngRespVO ownerInfoMngDetail(Long carOwnerId) {
        List<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVOS;
        CarOwnerInfoDO ownerInfoDO = this.carOwnerInfoRepo.findByCarOwnerId(carOwnerId);
        if (Optional.ofNullable(ownerInfoDO).isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        CarOwnerInfoMngRespVO carOwnerInfoMngRespVO = CarOwnerInfoConvert.INSTANCE.carOwnerInfoDOTOVO(ownerInfoDO);
        if (!StringUtils.isEmpty((CharSequence)carOwnerInfoMngRespVO.getUrl()) && !carOwnerInfoMngRespVO.getUrl().startsWith("http")) {
            carOwnerInfoMngRespVO.setUrl(this.pictureURL + carOwnerInfoMngRespVO.getUrl());
        }
        if (!CollUtil.isEmpty(carOwnerVehicleInfoVOS = this.carOwnerVehicleService.bindVehicleMngQuery(carOwnerId))) {
            carOwnerVehicleInfoVOS.stream().forEach(s -> {
                ApiResult<CarMaintainCardVO> maintainCard = this.maintainCardService.queryById(s.getVehicleNo());
                if (maintainCard.getData() != null) {
                    CarMaintainCardVO carMaintainCardVO = (CarMaintainCardVO)maintainCard.getData();
                    s.setCarMaintainCardVO(carMaintainCardVO);
                } else {
                    s.setCarMaintainCardVO(null);
                }
            });
        }
        carOwnerInfoMngRespVO.setCarOwnerVehicleInfoVOS(carOwnerVehicleInfoVOS);
        return carOwnerInfoMngRespVO;
    }

    @Override
    @SysCodeProc
    public CarOwnerInfoMngRespVO ownerInfoByUserPhone(String userPhone) {
        if (StringUtils.isBlank((CharSequence)userPhone)) {
            throw new BusinessException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<CarOwnerInfoDO> carOwnerInfoDOS = this.carOwnerInfoRepoProc.queryByUserPhone(userPhone);
        if (CollectionUtils.isEmpty(carOwnerInfoDOS)) {
            throw new BusinessException(ApiCode.FAIL, "\u6839\u636e\u624b\u673a\u53f7\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5ba2\u6237\u4fe1\u606f");
        }
        if (!CollectionUtils.isEmpty(carOwnerInfoDOS) && carOwnerInfoDOS.size() > 1) {
            throw new BusinessException("\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u5230\u591a\u4e2a\u8f66\u4e3b\u4fe1\u606f");
        }
        CarOwnerInfoMngRespVO carOwnerInfoMngRespVO = CarOwnerInfoConvert.INSTANCE.carOwnerInfoDOTOVO(carOwnerInfoDOS.get(0));
        List<CarOwnerVehicleInfoVO> res = this.carOwnerVehicleService.findCarByUserPhone(userPhone);
        carOwnerInfoMngRespVO.setCarOwnerVehicleInfoVOS(res);
        return carOwnerInfoMngRespVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long registerMember(RegisterMemberParam registerMemberParam) {
        log.info("\u6ce8\u518c\u4f1a\u5458\u3010{}, {}, {}\u3011", (Object)registerMemberParam.getMobile(), (Object)registerMemberParam.getUserName(), (Object)registerMemberParam.getId());
        Long casUserId = null;
        CarOwnerInfoDO carOwnerInfoDO = this.carOwnerInfoRepo.findByUserPhone(registerMemberParam.getMobile());
        if (Optional.ofNullable(carOwnerInfoDO).isPresent()) {
            throw new BusinessException("\u5f53\u524d\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
        }
        String verify = this.verifyCodeManager.verify("AFTER_KAPCHA", registerMemberParam.getMobile(), registerMemberParam.getKaptcha());
        if (!ObjectUtils.isEmpty((Object)verify)) {
            throw new BusinessException(verify);
        }
        Result userByMobile = UserTransferHelper.getInstance((String)this.authorizationServiceConfiguration.getAuthServer()).getUserByMobile(registerMemberParam.getMobile());
        if (userByMobile.getSuccess().equals(false)) {
            throw new BusinessException("\u67e5\u8be2\u7edf\u4e00\u8ba4\u8bc1\u670d\u52a1\u624b\u673a\u53f7\u5931\u8d25\uff0c" + userByMobile.getMsg());
        }
        if (Objects.isNull(userByMobile.getData())) {
            com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO userInfoDTO = new com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO();
            userInfoDTO.setMobile(registerMemberParam.getMobile());
            userInfoDTO.setUsername((String)(StringUtils.isNotEmpty((CharSequence)registerMemberParam.getUserName()) ? registerMemberParam.getUserName() : "\u7acb\u9a6c\u8f66\u4e3b" + this.constant.getRandomNum(8)));
            Result userData = UserTransferHelper.getInstance((String)this.authorizationServiceConfiguration.getAuthServer()).upsertUser((AuthUserDTO)userInfoDTO);
            if (userData.getSuccess().equals(false)) {
                throw new BusinessException("\u6ce8\u518c\u5931\u8d25\uff0c" + userData.getMsg());
            }
            casUserId = (Long)userData.getData();
        } else {
            casUserId = ((AuthUserDTO)userByMobile.getData()).getId();
        }
        ApiResult<Long> result = null;
        try {
            result = this.registerMemberPc(registerMemberParam.getMobile(), registerMemberParam.getUserName(), casUserId);
        }
        catch (Exception e) {
            log.error("\u6ce8\u518c\u4f1a\u5458\u5f02\u5e38\uff1a{}", (Throwable)e);
            throw new BusinessException("\u6ce8\u518c\u5931\u8d25\uff0c" + e.getMessage());
        }
        if (result != null && result.getData() != null) {
            return (Long)result.getData();
        }
        throw new BusinessException("\u6ce8\u518c\u4f1a\u5458\u5931\u8d25\uff0c" + (result == null ? "\u7cfb\u7edf\u5f02\u5e38" : result.getMsg()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long cancelMember(RegisterMemberParam registerMemberParam) {
        log.info("\u6ce8\u9500\u4f1a\u5458\u3010{}, {}, {}\u3011", (Object)registerMemberParam.getUserName(), (Object)registerMemberParam.getCasUserId(), (Object)registerMemberParam.getCarOwnerId());
        Result userData = UserTransferHelper.getInstance((String)this.authorizationServiceConfiguration.getAuthServer()).updateEnabled(registerMemberParam.getCasUserId().longValue(), registerMemberParam.getEnabled().booleanValue());
        if (userData.getSuccess().equals(false)) {
            throw new BusinessException("\u6ce8\u9500\u5931\u8d25\uff0c" + userData.getMsg());
        }
        this.carOwnerInfoRepoProc.updateEnabledFlag(registerMemberParam.getCasUserId(), 0);
        return null;
    }

    @Override
    public void getKaptcha(String phone) {
        SysSendVerifyCodeVO sysSendVerifyCodeVO = new SysSendVerifyCodeVO();
        sysSendVerifyCodeVO.setAccount(phone);
        sysSendVerifyCodeVO.setAccountType("mobile");
        sysSendVerifyCodeVO.setPeriod(Long.valueOf(600L));
        this.verifyCodeManager.send("AFTER_KAPCHA", sysSendVerifyCodeVO);
    }

    private Long obtainTenantIdFromWechat() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        Assert.notNull((Object)request, (String)"\u672a\u83b7\u53d6\u5230\u6709\u6548HttpServletRequest");
        String wechatAppId = request.getParameter("wx_appid");
        Assert.hasText((String)wechatAppId, (String)"wx_appid\u4e3a\u7a7a");
        Long tenantIdByAccount = this.systemRpcProvider.getTenantIdByAccount(wechatAppId);
        return tenantIdByAccount;
    }
}

