/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.aliyun.ocr_api20210707.Client;
import com.aliyun.ocr_api20210707.models.RecognizeIdcardRequest;
import com.aliyun.ocr_api20210707.models.RecognizeIdcardResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.aftersale.constant.Constant;
import com.elitesland.yst.production.aftersale.convert.CarOwnerVehicleInfoConvert;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleRelateDO;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehiclePhonePageParam;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.vo.AddressInfoVo;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.model.vo.CarVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.out.support.OrgStoreService;
import com.elitesland.yst.production.aftersale.provider.sale.SalesmanRpcProvider;
import com.elitesland.yst.production.aftersale.provider.sale.VinOrderRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysAreaRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.CarService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRelateRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRelateRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.sale.dto.CrmCustRespDTO;
import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.yst.production.sale.rpc.param.VinOrderRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.store.dto.OrgStoreRpcDTO;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CarOwnerVehicleServiceImpl
implements CarOwnerVehicleService {
    private static final Logger log = LogManager.getLogger(CarOwnerVehicleServiceImpl.class);
    @Autowired
    private Constant constant;
    @Autowired
    private CarService carService;
    @Autowired
    private MaintainCardService maintainCardService;
    @Autowired
    @Lazy
    private RepairOrderService repairOrderService;
    @Autowired
    private CarOwnerVehicleRelateRepo carOwnerVehicleRelateRepo;
    @Autowired
    private CarOwnerVehicleRepo carOwnerVehicleRepo;
    @Autowired
    private CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;
    @Autowired
    private CarOwnerVehicleRelateRepoProc carOwnerVehicleRelateRepoProc;
    @Autowired
    private CarOwnerInfoRepo carOwnerInfoRepo;
    @Autowired
    private UserService userService;
    @Autowired
    private PictureOrderRepo pictureOrderRepo;
    @Autowired
    private SalesmanRpcProvider salesmanRpcProvider;
    @Autowired
    private VinOrderRpcProvider vinOrderRpcProvider;
    @Autowired
    private SysAreaRpcProvider sysAreaRpcProvider;
    @Autowired
    private Client ocrClient;
    @Autowired
    private OrgStoreService orgStoreService;
    @Autowired
    private CrmSaleService crmSaleService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private CarMaintainCardRepoProc carMaintainCardRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> bindVehicleSave(CarOwnerVehicleParam carOwnerVehicleParam) {
        Long userId = this.userService.getUserId();
        carOwnerVehicleParam.setCarOwnerId(userId);
        CarOwnerVehicleInfoDO carOwnerVehicleSaveDO = CarOwnerVehicleInfoConvert.INSTANCE.carOwnerVehicleVOToDO(carOwnerVehicleParam);
        if (carOwnerVehicleParam.getVehicleSource().equals(1)) {
            int countByUserIdCard;
            int countByUserPhone;
            Assert.notBlank((CharSequence)carOwnerVehicleParam.getVehicleNo(), (String)"\u8f66\u67b6\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Boolean isExist = this.existBy(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo());
            if (isExist.booleanValue()) {
                throw new BusinessException("\u8be5\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u6b64\u8f66,\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a");
            }
            if (carOwnerVehicleParam.getUserPhone() != null && (countByUserPhone = this.carOwnerVehicleRepo.findCountByUserPhone(carOwnerVehicleParam.getUserPhone())) == 1) {
                throw new BusinessException("\u6b64\u7528\u6237\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u4e00\u8f86\u8f66\uff0c\u8bf7\u5148\u89e3\u7ed1\u518d\u7ed1\u5b9a");
            }
            if (carOwnerVehicleParam.getUserIdCard() != null && (countByUserIdCard = this.carOwnerVehicleRepo.findCountByUserIdCard(carOwnerVehicleParam.getUserIdCard())) == 1) {
                throw new BusinessException("\u6b64\u7528\u6237\u8eab\u4efd\u8bc1\u53f7\u5df2\u7ed1\u5b9a\u4e00\u8f86\u8f66\uff0c\u8bf7\u5148\u89e3\u7ed1\u518d\u7ed1\u5b9a");
            }
            Assert.notNull((Object)carOwnerVehicleParam.getSalesOutletsId(), (String)"\u8d2d\u4e70\u95e8\u5e97id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)carOwnerVehicleParam.getSalesOutletsName(), (String)"\u8d2d\u4e70\u95e8\u5e97name\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)carOwnerVehicleParam.getSalesOutletsCode(), (String)"\u8d2d\u4e70\u95e8\u5e97code\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            carOwnerVehicleSaveDO.setBindingTime(LocalDateTime.now());
            carOwnerVehicleSaveDO.setPurchaseTime(LocalDateTime.of(carOwnerVehicleParam.getPurchaseTime(), LocalTime.MIN));
            carOwnerVehicleSaveDO.setUserBirthday(carOwnerVehicleParam.getUserBirthday());
            VinOrderRpcDTO vinOrderRpcDTO = this.vinOrderRpcProvider.getByVinNo(carOwnerVehicleParam.getVehicleNo());
            carOwnerVehicleSaveDO.setItemId(vinOrderRpcDTO.getId());
            carOwnerVehicleSaveDO.setItemCode(vinOrderRpcDTO.getMtnrv());
            log.info("\u9500\u552e\u95e8\u5e97ID{}", (Object)carOwnerVehicleParam.getSalesOutletsId());
            ApiResult<SalemanCustDTO> salemanCust = this.salesmanRpcProvider.getSalemanCust(carOwnerVehicleParam.getSalesOutletsId());
            if (salemanCust.isSuccess() && !Optional.ofNullable((SalemanCustDTO)salemanCust.getData()).isEmpty()) {
                SalemanCustDTO salemanCustDTO = (SalemanCustDTO)salemanCust.getData();
                BeanUtils.copyProperties((Object)salemanCustDTO, (Object)((Object)carOwnerVehicleSaveDO));
                carOwnerVehicleSaveDO.setSalesOutletsRegion(salemanCustDTO.getRegion());
                carOwnerVehicleSaveDO.setRegionalManager(salemanCustDTO.getRemanagerName());
                carOwnerVehicleSaveDO.setProvincialManager(salemanCustDTO.getPrmanagerName());
                carOwnerVehicleSaveDO.setSalesDirector(salemanCustDTO.getChiefName());
                Map<String, String> custRegionUdc = this.userService.sysUdcGetCodeMap("yst-supp", "REGION");
                carOwnerVehicleSaveDO.setSalesOutletsRegionName(custRegionUdc.get(salemanCustDTO.getRegion()));
                carOwnerVehicleSaveDO.setSalesmanName(salemanCustDTO.getPath() == null ? null : JSON.toJSONString((Object)salemanCustDTO.getPath()));
            }
        }
        if (carOwnerVehicleParam.getVehicleSource().equals(0)) {
            Assert.notBlank((CharSequence)carOwnerVehicleParam.getBrandName(), (String)"\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            carOwnerVehicleSaveDO.setBindingTime(LocalDateTime.now());
            carOwnerVehicleSaveDO.setPurchaseTime(LocalDateTime.of(carOwnerVehicleParam.getPurchaseTime(), LocalTime.MIN));
            carOwnerVehicleSaveDO.setUserBirthday(carOwnerVehicleParam.getUserBirthday());
        }
        CarOwnerVehicleInfoDO save = (CarOwnerVehicleInfoDO)((Object)this.carOwnerVehicleRepo.save((Object)carOwnerVehicleSaveDO));
        log.info("\u7ed1\u5b9a\u8f66\u8f86\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = new CarOwnerVehicleRelateDO();
        carOwnerVehicleRelateDO.setCarOwnerId(carOwnerVehicleParam.getCarOwnerId());
        carOwnerVehicleRelateDO.setVehicleType(carOwnerVehicleRelateDO.getVehicleType());
        carOwnerVehicleRelateDO.setVehicleInfoId(save.getId());
        this.carOwnerVehicleRelateRepo.save((Object)carOwnerVehicleRelateDO);
        log.info("\u8f66\u4e3b\u7ed1\u5b9a\u8f66\u8f86\u5173\u7cfb\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> deleteBindVehicle(Long id) {
        log.info("\u8f66\u8f86\u89e3\u9664\u7ed1\u5b9a\u5165\u53c2 {}", (Object)id);
        Long userId = this.userService.getUserId();
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = this.carOwnerVehicleRelateRepo.findByCarOwnerIdAndVehicleInfoId(userId, id);
        if (Optional.ofNullable(carOwnerVehicleRelateDO).isEmpty()) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u4e0b\uff0c\u672a\u67e5\u8be2\u5230\u8981\u89e3\u7ed1\u7684\u8f66\u8f86\uff0c\u524d\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        Optional optional = this.carOwnerVehicleRepo.findById(id);
        this.carOwnerVehicleRepoProc.deletearOwnerVehicleInfoDO(id);
        log.info("\u8f66\u8f86\u89e3\u9664\u7ed1\u5b9a\u6210\u529f {}", (Object)id);
        this.carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateDO(id);
        log.info("\u8f66\u4e3b\u4e0e\u8f66\u8f86\u5173\u7cfb\u8868\u5220\u9664\u6210\u529f {}", (Object)id);
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> deleteBindVehicleAndThreePack(Long id) {
        log.info("\u8f66\u8f86\u89e3\u9664\u7ed1\u5b9a\u5165\u53c2 {}", (Object)id);
        Long userId = this.userService.getUserId();
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = this.carOwnerVehicleRelateRepo.findByCarOwnerIdAndVehicleInfoId(userId, id);
        if (Optional.ofNullable(carOwnerVehicleRelateDO).isEmpty()) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u4e0b\uff0c\u672a\u67e5\u8be2\u5230\u8981\u89e3\u7ed1\u7684\u8f66\u8f86\uff0c\u524d\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        Optional optional = this.carOwnerVehicleRepo.findById(id);
        this.carOwnerVehicleRepoProc.deletearOwnerVehicleInfoDO(id);
        log.info("\u8f66\u8f86\u89e3\u9664\u7ed1\u5b9a\u6210\u529f {}", (Object)id);
        this.carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateDO(id);
        log.info("\u8f66\u4e3b\u4e0e\u8f66\u8f86\u5173\u7cfb\u8868\u5220\u9664\u6210\u529f {}", (Object)id);
        if (!optional.isEmpty() && ((CarOwnerVehicleInfoDO)((Object)optional.get())).getVehicleSource().equals(1)) {
            String vehicleNo = ((CarOwnerVehicleInfoDO)((Object)optional.get())).getVehicleNo();
            CarMaintainCardDO cardDO = new CarMaintainCardDO();
            cardDO.setVehicleNo(vehicleNo);
            this.maintainCardService.delMaintainCard(vehicleNo);
            log.info("\u8f66\u8f86\u4e09\u5305\u6fc0\u6d3b\u4fe1\u606f\u5220\u9664\u6210\u529f ,\u8f66\u67b6\u53f7\u4e3a\uff1a{}", (Object)vehicleNo);
        }
        return ApiResult.ok();
    }

    @Override
    @SysCodeProc
    public ApiResult<Object> bindVehicleQuery() {
        Long userId = this.userService.getUserId();
        List<CarOwnerVehicleRelateDO> carOwnerVehicleRelateDOList = this.carOwnerVehicleRelateRepo.findByCarOwnerId(userId);
        if (CollUtil.isEmpty(carOwnerVehicleRelateDOList)) {
            return ApiResult.ok();
        }
        List vehicleInfoIds = carOwnerVehicleRelateDOList.stream().map(CarOwnerVehicleRelateDO::getVehicleInfoId).collect(Collectors.toList());
        log.info("\u8f66\u4e3b\u7ed1\u5b9a\u7684\u8f66\u8f86 {}", (Object)vehicleInfoIds.toString());
        List ownerVehicleInfoDOS = this.carOwnerVehicleRepo.findAllById(vehicleInfoIds);
        List<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVOS = CarOwnerVehicleInfoConvert.INSTANCE.CarOwnerVehicleInfoDOToVO(ownerVehicleInfoDOS);
        int current = 1;
        for (CarOwnerVehicleInfoVO carOwnerVehicleInfoVO : carOwnerVehicleInfoVOS) {
            carOwnerVehicleInfoVO.setVehicleName("\u6211\u7684\u7535\u52a8\u8f66" + current);
            ++current;
        }
        log.info("\u8f66\u8f86\u4fe1\u606f {}", (Object)JSON.toJSONString(carOwnerVehicleInfoVOS));
        return ApiResult.ok(carOwnerVehicleInfoVOS);
    }

    @Override
    @SysCodeProc
    public List<CarOwnerVehicleInfoVO> bindVehicleMngQuery(Long carOwnerId) {
        List<CarOwnerVehicleRelateDO> carOwnerVehicleRelateDOList = this.carOwnerVehicleRelateRepo.findByCarOwnerId(carOwnerId);
        if (CollUtil.isEmpty(carOwnerVehicleRelateDOList)) {
            return null;
        }
        List vehicleInfoIds = carOwnerVehicleRelateDOList.stream().map(CarOwnerVehicleRelateDO::getVehicleInfoId).collect(Collectors.toList());
        log.info("\u8f66\u4e3b\u7ed1\u5b9a\u7684\u8f66\u8f86 {}", (Object)vehicleInfoIds.toString());
        List ownerVehicleInfoDOS = this.carOwnerVehicleRepo.findAllById(vehicleInfoIds);
        List<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVOS = CarOwnerVehicleInfoConvert.INSTANCE.CarOwnerVehicleInfoDOToVO(ownerVehicleInfoDOS);
        int current = 1;
        for (CarOwnerVehicleInfoVO carOwnerVehicleInfoVO : carOwnerVehicleInfoVOS) {
            carOwnerVehicleInfoVO.setVehicleName("\u6211\u7684\u7535\u52a8\u8f66" + current);
            ++current;
        }
        log.info("\u8f66\u8f86\u4fe1\u606f {}", (Object)JSON.toJSONString(carOwnerVehicleInfoVOS));
        return carOwnerVehicleInfoVOS;
    }

    @Override
    @SysCodeProc
    public PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery(BindSoldVehicleParam param) {
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.repairOrderService.repairStoreQuery();
        ArrayList<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<Long>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        param.setSalesOutletsIdS(collect);
        if (CollectionUtils.isEmpty(param.getSalesOutletsIdS())) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery = this.carOwnerVehicleRepoProc.bindSoldVehicleQuery(param);
        return bindSoldVehicleQuery;
    }

    @Override
    @SysCodeProc
    public PagingVO<BindSoldVehicleVO> bcBindSoldVehicleQuery(BindSoldVehicleParam param) {
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.repairOrderService.bcRepairStoreQuery();
        ArrayList<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<Long>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        param.setSalesOutletsIdS(collect);
        if (CollectionUtils.isEmpty(param.getSalesOutletsIdS())) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery = this.carOwnerVehicleRepoProc.bindSoldVehicleQuery(param);
        return bindSoldVehicleQuery;
    }

    @Override
    @SysCodeProc
    public CarOwnerVehicleInfoVO bindSoldVehicleDetail(Long id) {
        Optional optional = this.carOwnerVehicleRepo.findById(id);
        CarOwnerVehicleInfoVO carOwnerVehicleInfoVO = new CarOwnerVehicleInfoVO();
        ArrayList<CarOwnerVehicleInfoVO> carOwnerVehicleList = new ArrayList<CarOwnerVehicleInfoVO>();
        if (!optional.isEmpty()) {
            carOwnerVehicleInfoVO = CarOwnerVehicleInfoConvert.INSTANCE.carOwnerVehicleDOToVO((CarOwnerVehicleInfoDO)((Object)optional.get()));
            ApiResult<CarMaintainCardVO> maintainCard = this.maintainCardService.queryById(carOwnerVehicleInfoVO.getVehicleNo());
            if (maintainCard.getData() != null) {
                CarMaintainCardVO carMaintainCardVO = (CarMaintainCardVO)maintainCard.getData();
                carOwnerVehicleInfoVO.setCarMaintainCardVO(carMaintainCardVO);
            } else {
                carOwnerVehicleInfoVO.setCarMaintainCardVO(null);
            }
        }
        carOwnerVehicleList.add(carOwnerVehicleInfoVO);
        return (CarOwnerVehicleInfoVO)carOwnerVehicleList.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> bindSoldVehicleSave(CarOwnerVehicleParam carOwnerVehicleParam, String sourcePlatform) {
        carOwnerVehicleParam.setSourcePlatform(sourcePlatform);
        CarOwnerInfoDO carOwnerInfoDO = this.carOwnerInfoRepo.findByUserPhone(carOwnerVehicleParam.getUserPhone());
        if (Optional.ofNullable(carOwnerInfoDO).isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5ba2\u6237\u4fe1\u606f");
        }
        if (carOwnerInfoDO.getEnabledFlag().equals(0)) {
            throw new BusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u7981\u7528");
        }
        if (null == carOwnerVehicleParam.getVehicleSource()) {
            throw new BusinessException("\u8f66\u8f86\u6765\u6e90 vehicleSource \u4e0d\u80fd\u4e3a\u7a7a");
        }
        carOwnerVehicleParam.setCarOwnerId(carOwnerInfoDO.getCarOwnerId());
        CarOwnerVehicleInfoDO carOwnerVehicleSaveDO = CarOwnerVehicleInfoConvert.INSTANCE.carOwnerVehicleVOToDO(carOwnerVehicleParam);
        if (carOwnerVehicleParam.getVehicleSource().equals(1)) {
            int countByUserIdCard;
            int countByUserPhone;
            Assert.notBlank((CharSequence)carOwnerVehicleParam.getVehicleNo(), (String)"\u8f66\u67b6\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Assert.notNull((Object)carOwnerVehicleParam.getSalesOutletsId(), (String)"\u8d2d\u4e70\u95e8\u5e97id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)carOwnerVehicleParam.getSalesOutletsName(), (String)"\u8d2d\u4e70\u95e8\u5e97name\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)carOwnerVehicleParam.getSalesOutletsCode(), (String)"\u8d2d\u4e70\u95e8\u5e97code\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Boolean isExist = this.existBy(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo());
            if (isExist.booleanValue()) {
                throw new BusinessException("\u8be5\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u6b64\u8f66,\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a");
            }
            if (carOwnerVehicleParam.getUserPhone() != null && (countByUserPhone = this.carOwnerVehicleRepo.findCountByUserPhone(carOwnerVehicleParam.getUserPhone())) == 3) {
                throw new BusinessException("\u6b64\u7528\u6237\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u4e09\u8f86\u8f66\uff0c\u8bf7\u5148\u89e3\u7ed1\u518d\u7ed1\u5b9a");
            }
            if (carOwnerVehicleParam.getUserIdCard() != null && (countByUserIdCard = this.carOwnerVehicleRepo.findCountByUserIdCard(carOwnerVehicleParam.getUserIdCard())) == 3) {
                throw new BusinessException("\u6b64\u7528\u6237\u8eab\u4efd\u8bc1\u53f7\u5df2\u7ed1\u5b9a\u4e09\u8f86\u8f66\uff0c\u8bf7\u5148\u89e3\u7ed1\u518d\u7ed1\u5b9a");
            }
            carOwnerVehicleSaveDO.setBindingTime(LocalDateTime.now());
            carOwnerVehicleSaveDO.setPurchaseTime(LocalDateTime.of(carOwnerVehicleParam.getPurchaseTime(), LocalTime.MIN));
            VinOrderRpcDTO vinOrderRpcDTO = this.vinOrderRpcProvider.getByVinNo(carOwnerVehicleParam.getVehicleNo());
            carOwnerVehicleSaveDO.setItemId(vinOrderRpcDTO.getId());
            carOwnerVehicleSaveDO.setItemCode(vinOrderRpcDTO.getMtnrv());
            log.info("\u9500\u552e\u95e8\u5e97ID{}", (Object)carOwnerVehicleParam.getSalesOutletsId());
            ApiResult<SalemanCustDTO> salemanCust = this.salesmanRpcProvider.getSalemanCust(carOwnerVehicleParam.getSalesOutletsId());
            if (salemanCust.isSuccess() && !Optional.ofNullable((SalemanCustDTO)salemanCust.getData()).isEmpty()) {
                SalemanCustDTO salemanCustDTO = (SalemanCustDTO)salemanCust.getData();
                BeanUtils.copyProperties((Object)salemanCustDTO, (Object)((Object)carOwnerVehicleSaveDO));
                carOwnerVehicleSaveDO.setSalesOutletsRegion(salemanCustDTO.getRegion());
                carOwnerVehicleSaveDO.setRegionalManager(salemanCustDTO.getRemanagerName());
                carOwnerVehicleSaveDO.setProvincialManager(salemanCustDTO.getPrmanagerName());
                carOwnerVehicleSaveDO.setSalesDirector(salemanCustDTO.getChiefName());
                Map<String, String> custRegionUdc = this.userService.sysUdcGetCodeMap("yst-supp", "REGION");
                carOwnerVehicleSaveDO.setSalesOutletsRegionName(custRegionUdc.get(salemanCustDTO.getRegion()));
                carOwnerVehicleSaveDO.setSalesmanName(salemanCustDTO.getPath() == null ? null : JSON.toJSONString((Object)salemanCustDTO.getPath()));
            }
        }
        if (carOwnerVehicleParam.getVehicleSource().equals(0)) {
            List vehicleInfoIds;
            List ownerVehicleInfoDOS;
            Optional<CarOwnerVehicleInfoDO> op;
            Long userId = this.userService.getUserId();
            List<CarOwnerVehicleRelateDO> carOwnerVehicleRelateDOList = this.carOwnerVehicleRelateRepo.findByCarOwnerId(userId);
            if (!CollectionUtils.isEmpty(carOwnerVehicleRelateDOList) && (op = (ownerVehicleInfoDOS = this.carOwnerVehicleRepo.findAllById(vehicleInfoIds = carOwnerVehicleRelateDOList.stream().map(CarOwnerVehicleRelateDO::getVehicleInfoId).collect(Collectors.toList()))).stream().filter(x -> 0 == x.getVehicleSource()).findFirst()).isPresent()) {
                throw new BusinessException("\u975e\u7acb\u9a6c\u8f66\u8f86\u53ea\u5141\u8bb8\u7ed1\u5b9a\u4e00\u8f86");
            }
            carOwnerVehicleSaveDO.setBindingTime(LocalDateTime.now());
            carOwnerVehicleSaveDO.setPurchaseTime(LocalDateTime.of(carOwnerVehicleParam.getPurchaseTime(), LocalTime.MIN));
        }
        CarOwnerVehicleInfoDO save = (CarOwnerVehicleInfoDO)((Object)this.carOwnerVehicleRepo.save((Object)carOwnerVehicleSaveDO));
        log.info("\u7ed1\u5b9a\u8f66\u8f86\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = new CarOwnerVehicleRelateDO();
        carOwnerVehicleRelateDO.setCarOwnerId(carOwnerVehicleParam.getCarOwnerId());
        carOwnerVehicleRelateDO.setVehicleType(carOwnerVehicleRelateDO.getVehicleType());
        carOwnerVehicleRelateDO.setVehicleInfoId(save.getId());
        this.carOwnerVehicleRelateRepo.save((Object)carOwnerVehicleRelateDO);
        log.info("\u8f66\u4e3b\u7ed1\u5b9a\u8f66\u8f86\u5173\u7cfb\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        return ApiResult.ok((Object)save.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> deleteBindVehicleToFront(String userPhone, String userName, Long vehicleInfoId) {
        log.info("\u8f66\u8f86\u89e3\u9664\u7ed1\u5b9a\u5165\u53c2\u3010{}, {}, {}\u3011", (Object)userPhone, (Object)userName, (Object)vehicleInfoId);
        CarOwnerInfoDO carOwnerInfoDO = this.carOwnerInfoRepo.findByUserPhone(userPhone);
        if (Optional.ofNullable(carOwnerInfoDO).isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5ba2\u6237\u4fe1\u606f");
        }
        Long carOwnerId = carOwnerInfoDO.getCarOwnerId();
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = this.carOwnerVehicleRelateRepo.findByCarOwnerIdAndVehicleInfoId(carOwnerId, vehicleInfoId);
        if (Optional.ofNullable(carOwnerVehicleRelateDO).isEmpty()) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u4e0b\uff0c\u672a\u67e5\u8be2\u5230\u8981\u89e3\u7ed1\u7684\u8f66\u8f86\uff0c\u524d\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        Optional optional = this.carOwnerVehicleRepo.findById(vehicleInfoId);
        this.carOwnerVehicleRepoProc.deletearOwnerVehicleInfoDO(vehicleInfoId);
        log.info("\u8f66\u8f86\u89e3\u9664\u7ed1\u5b9a\u6210\u529f {}", (Object)vehicleInfoId);
        this.carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateDO(vehicleInfoId);
        log.info("\u8f66\u4e3b\u4e0e\u8f66\u8f86\u5173\u7cfb\u8868\u5220\u9664\u6210\u529f {}", (Object)vehicleInfoId);
        if (!optional.isEmpty() && ((CarOwnerVehicleInfoDO)((Object)optional.get())).getVehicleSource().equals(1)) {
            CarMaintainCardDO cardDO = new CarMaintainCardDO();
            cardDO.setVehicleNo(((CarOwnerVehicleInfoDO)((Object)optional.get())).getVehicleNo());
            this.maintainCardService.delByVehicleNo(cardDO);
            log.info("\u8f66\u8f86\u4e09\u5305\u4fe1\u606f\u5220\u9664\u6210\u529f {}", (Object)((CarOwnerVehicleInfoDO)((Object)optional.get())).getVehicleNo());
        }
        return ApiResult.ok();
    }

    @Override
    @SysCodeProc
    public PagingVO<BindSoldVehicleVO> vehicleBindInfoQuery(BindSoldVehicleParam param) {
        PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery = this.carOwnerVehicleRepoProc.bindSoldVehicleQuery(param);
        return bindSoldVehicleQuery;
    }

    @Override
    public AddressInfoVo queryByUserCardId(String userCardId) {
        Object address = userCardId.substring(0, 2);
        address = (String)address + "0000";
        HashSet<String> set = new HashSet<String>();
        set.add((String)address);
        AddressInfoVo addressInfoVo = new AddressInfoVo();
        addressInfoVo.setProvinceCode((String)address);
        List<SysAreaRespDTO> data = this.sysAreaRpcProvider.listByAreaCodes(set);
        if (data != null && data.size() != 0) {
            addressInfoVo.setProvince(data.get(0).getAreaName());
        }
        address = userCardId.substring(0, 4);
        address = (String)address + "00";
        set.clear();
        set.add((String)address);
        addressInfoVo.setCityCode((String)address);
        List<SysAreaRespDTO> data1 = this.sysAreaRpcProvider.listByAreaCodes(set);
        if (data1 != null && data1.size() != 0) {
            addressInfoVo.setCity(data1.get(0).getAreaName());
        }
        address = userCardId.substring(6, 14);
        addressInfoVo.setUserBirthday(LocalDate.of(Integer.parseInt(((String)address).substring(0, 4)), Integer.parseInt(((String)address).substring(4, 6)), Integer.parseInt(((String)address).substring(6, 8))));
        address = userCardId.substring(16, 17);
        if (Integer.parseInt((String)address) % 2 > 0) {
            addressInfoVo.setUserSex("1");
        } else {
            addressInfoVo.setUserSex("0");
        }
        return addressInfoVo;
    }

    @Override
    public RecognizeIdcardResponse ocrScan(MultipartFile file) {
        try {
            InputStream bodyStream = file.getInputStream();
            RecognizeIdcardRequest recognizeIdcardRequest = new RecognizeIdcardRequest().setBody(bodyStream);
            RuntimeOptions runtime = new RuntimeOptions();
            return this.ocrClient.recognizeIdcardWithOptions(recognizeIdcardRequest, runtime);
        }
        catch (TeaException error) {
            throw new BusinessException(Common.assertAsString((Object)error.message));
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            throw new BusinessException(Common.assertAsString((Object)error.message));
        }
    }

    @Override
    public ApiResult<Object> custDateRepair(BindSoldVehicleParam param) {
        HashMap storeIdAndCustCodeMap = new HashMap();
        List listApiResult = new ArrayList();
        if (param.getStartTime() == null || param.getEndTime() == null) {
            throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<CarOwnerVehicleInfoDO> bindSoldVehicleVOS = this.carOwnerVehicleRepo.findByBindingTimeOrVehicleNo(param.getStartTime(), param.getEndTime(), 1, param.getActivatFlag(), param.getVehicleNo());
        log.info("\u8f66\u4e3b\u4fe1\u606f\u8868\u8fd4\u56de\u4fe1\u606f:\u3010" + bindSoldVehicleVOS + "\u3011");
        if (CollectionUtils.isEmpty(bindSoldVehicleVOS)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f");
        }
        List<Long> collect = bindSoldVehicleVOS.stream().map(CarOwnerVehicleInfoDO::getSalesOutletsId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw new BusinessException("\u8f66\u4e3b\u4fe1\u606f\u8868\u4e2d\u95e8\u5e97id\u4e3a\u7a7a");
        }
        log.info("\u95e8\u5e97\u5165\u53c2\u4fe1\u606f:\u3010" + collect + "\u3011");
        List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS = this.orgStoreService.queryByIds(collect);
        if (CollectionUtils.isEmpty(orgStoreDetailRpcDTOS)) {
            throw new BusinessException("\u95e8\u5e97\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        log.info("\u95e8\u5e97\u51fa\u53c2\u4fe1\u606f:\u3010" + orgStoreDetailRpcDTOS + "\u3011");
        List codeList = orgStoreDetailRpcDTOS.stream().filter(t -> t.getPcode() != null).map(OrgStoreDetailRpcDTO::getPcode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(codeList)) {
            throw new BusinessException("\u95e8\u5e97pcode\u4e3a\u7a7a");
        }
        orgStoreDetailRpcDTOS.stream().forEach(t -> storeIdAndCustCodeMap.put(t.getId(), t.getPcode()));
        CrmCustRpcDtoParam crmCustRpcDtoParam = new CrmCustRpcDtoParam();
        crmCustRpcDtoParam.setCustCodes(codeList);
        List<CrmCustRespDTO> custByParam = this.crmSaleService.getCustByParam(crmCustRpcDtoParam);
        if (CollectionUtils.isEmpty(custByParam)) {
            throw new BusinessException("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        log.info("\u5ba2\u6237\u51fa\u53c2\u4fe1\u606f:\u3010" + custByParam + "\u3011");
        List<Long> empIds = bindSoldVehicleVOS.stream().filter(t -> t.getRemark() != null && t.getRemark() != "").map(BaseModel::getRemark).mapToLong(t -> Long.parseLong(t.trim())).boxed().distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(empIds)) {
            listApiResult = (List)this.crmSaleService.queryLevelInfos(empIds).getData();
        }
        ArrayList finalListApiResult = listApiResult;
        bindSoldVehicleVOS.stream().forEach(t -> {
            List collect1;
            String custCode = (String)storeIdAndCustCodeMap.get(t.getSalesOutletsId());
            Optional<CrmCustRespDTO> first = custByParam.stream().filter(cust -> custCode.equals(cust.getCustCode())).findFirst();
            if (first.isPresent() && Objects.nonNull(first.get())) {
                t.setCustCode(first.get().getCustCode());
                t.setCustName(first.get().getCustName());
                t.setCustAbbr(first.get().getCustAbbr());
                t.setCustCode2(first.get().getCustCode2());
            }
            if (t.getRemark() != null && t.getRemark() != "" && !CollectionUtils.isEmpty((Collection)finalListApiResult) && CollectionUtils.isNotEmpty(collect1 = finalListApiResult.stream().filter(sale -> sale.getId().toString().equals(t.getRemark())).collect(Collectors.toList())) && !Optional.ofNullable((SalesmanLevelInfoDTO)collect1.stream().findFirst().get()).isEmpty()) {
                SalesmanLevelInfoDTO salesmanLevelInfoDTO = (SalesmanLevelInfoDTO)collect1.stream().findFirst().get();
                t.setSalesmanName(salesmanLevelInfoDTO.getSalesman_path() == null ? null : JSON.toJSONString((Object)salesmanLevelInfoDTO.getSalesman_path()));
            }
        });
        log.info("\u8f66\u4e3b\u4fe1\u606f\u4fdd\u5b58\u4fe1\u606f:\u3010" + bindSoldVehicleVOS + "\u3011");
        bindSoldVehicleVOS.stream().forEach(t -> this.carOwnerVehicleRepo.updateCustAndSalesManName(t.getCustCode(), t.getCustName(), t.getCustAbbr(), t.getCustCode2(), t.getSalesmanName(), t.getId()));
        return ApiResult.ok();
    }

    public void vehicleQuery(List<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVO) {
        List<String> collect = carOwnerVehicleInfoVO.stream().filter(t -> t.getVehicleNo() != null).map(CarOwnerVehicleInfoVO::getVehicleNo).collect(Collectors.toList());
        CarParam carParam = new CarParam();
        carParam.setVehicleNoList(collect);
        List data = (List)this.carService.queryList(carParam).getData();
        carOwnerVehicleInfoVO.stream().forEach(t -> {
            Optional<CarVO> first = data.stream().filter(car -> car.getVehicleNo().equals(t.getVehicleNo())).findFirst();
            if (first.isPresent()) {
                t.setVehicleName(first.get().getVehicleName());
                t.setVehicleNo(first.get().getVehicleNo());
                t.setVehicleSource(Integer.valueOf(first.get().getVehicleSource()));
                t.setVehicleSpecs(first.get().getVehicleSpecs());
                t.setBindingTime(first.get().getBindingTime());
                t.setPurchaseTime(first.get().getPurchaseTime());
                t.setMaintainCardNo(first.get().getMaintainCardNo());
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCarowner(CarOwnerInfoDO carOwnerInfoDO) {
        if (StringUtils.isBlank((CharSequence)carOwnerInfoDO.getUserPhone())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)carOwnerInfoDO.getUserName())) {
            return;
        }
        this.carOwnerVehicleRepoProc.updateCarowner(carOwnerInfoDO);
    }

    @Override
    public List<CarOwnerVehicleInfoVO> findCarByUserPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return new ArrayList<CarOwnerVehicleInfoVO>();
        }
        List<CarOwnerVehicleInfoVO> res = this.carOwnerVehicleRepoProc.findCarByUserPhone(phone);
        return res;
    }

    @Override
    public List<BindSoldVehicleVO> findCustByVehicleNo(List<String> vehicleNoList) {
        if (org.springframework.util.CollectionUtils.isEmpty(vehicleNoList)) {
            return new ArrayList<BindSoldVehicleVO>();
        }
        List<BindSoldVehicleVO> res = this.carOwnerVehicleRepoProc.findCustByVehicleNo(vehicleNoList);
        return res;
    }

    @Override
    public Boolean existBy(String userPhone, String vehicleNo) {
        if (StringUtils.isBlank((CharSequence)userPhone)) {
            throw new BusinessException("userPhone \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)vehicleNo)) {
            throw new BusinessException("vehicleNo \u4e0d\u80fd\u4e3a\u7a7a");
        }
        int a = this.carOwnerVehicleRepoProc.existBy(userPhone, vehicleNo);
        return a > 0;
    }

    @Override
    public Boolean existByPhoneAId(String userPhone, String userIdcard) {
        if (StringUtils.isBlank((CharSequence)userPhone) && StringUtils.isBlank((CharSequence)userIdcard)) {
            throw new BusinessException("userPhone\u6216userIdcard \u4e0d\u80fd\u4e3a\u7a7a");
        }
        int a = this.carMaintainCardRepoProc.existByPhoneAId(userPhone, userIdcard);
        return a > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateActivatFlag(String userPhone, String vehicleNo, boolean b) {
        this.carOwnerVehicleRepoProc.updateActivatFlag(userPhone, vehicleNo, b);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CarOwnerVehicleInfoVO getByVerNo(String vehicleNo) {
        CarOwnerVehicleInfoVO res = this.carOwnerVehicleRepoProc.getByVerNo(vehicleNo);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<BindSoldVehicleVO> vehicleBindInfoQuerySaleMan(BindSoldVehicleParam param) {
        ApiResult result = this.employeeRpcService.getByUserId(this.userService.getUserId());
        if (result.getData() == null || StringUtils.isEmpty((CharSequence)((SysEmployeeBasicDTO)result.getData()).getCode())) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u83b7\u53d6\u5458\u5de5code\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        if (!"SALESMAN".equals(((SysEmployeeBasicDTO)result.getData()).getType())) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u975e\u4e1a\u52a1\u5458\u65e0\u6cd5\u4f7f\u7528\u6b64\u9875\u9762");
        }
        String empCode = ((SysEmployeeBasicDTO)result.getData()).getCode();
        List<Long> storeIdList = this.crmSaleService.querySaleManStoreIds(empCode);
        if (org.springframework.util.CollectionUtils.isEmpty(storeIdList)) {
            return PagingVO.builder().total(0L).build();
        }
        param.setSalesOutletsIds2(storeIdList);
        PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery = this.carOwnerVehicleRepoProc.bindSoldVehicleQuery(param);
        return bindSoldVehicleQuery;
    }

    @Override
    @SysCodeProc
    public PagingVO<CarOwnerVehicleInfoVO> queryPageByPhone(CarOwnerVehiclePhonePageParam bindSoldVehicleParam) {
        if (StringUtils.isEmpty((CharSequence)bindSoldVehicleParam.getUserPhone())) {
            throw new BusinessException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.carOwnerVehicleRepoProc.findCarByUserPhonePage(bindSoldVehicleParam);
    }

    @Override
    public Integer getUserFlmVehicleBindQty() {
        Long userId = this.userService.getUserId();
        List<CarOwnerVehicleRelateDO> carOwnerVehicleRelateDOList = this.carOwnerVehicleRelateRepo.findByCarOwnerId(userId);
        if (!CollectionUtils.isEmpty(carOwnerVehicleRelateDOList)) {
            List vehicleInfoIds = carOwnerVehicleRelateDOList.stream().map(CarOwnerVehicleRelateDO::getVehicleInfoId).collect(Collectors.toList());
            List ownerVehicleInfoDOS = this.carOwnerVehicleRepo.findAllById(vehicleInfoIds);
            List ownerVehicleInfoDOS2 = ownerVehicleInfoDOS.stream().filter(x -> 0 == x.getVehicleSource()).collect(Collectors.toList());
            return ownerVehicleInfoDOS2.size();
        }
        return 0;
    }
}

