/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.util;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.util.ConstantsAfterSale;
import com.elitesland.yst.production.aftersale.util.excel.CommonCellStyleStrategy;
import com.elitesland.yst.production.aftersale.util.excel.CustomCellWriteHandler;
import com.elitesland.yst.production.aftersale.util.excel.ExcelExportUtil;
import com.elitesland.yst.production.aftersale.util.excel.support.ExportColumnParam;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

@Validated
public class AsyncExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(AsyncExcelUtils.class);

    public static List<ExportColumnParam> buildExportColumn(Class<?> clazz) {
        ArrayList<ExportColumnParam> exportColumn = new ArrayList<ExportColumnParam>();
        Field[] fields = ReflectUtil.getFields(clazz);
        Arrays.stream(fields).filter(f -> f.isAnnotationPresent(ExcelProperty.class)).forEach(f -> {
            ExportColumnParam exportColumnParam = new ExportColumnParam();
            exportColumnParam.setField(f.getName());
            exportColumnParam.setTitle(f.getAnnotation(ExcelProperty.class).value()[0]);
            exportColumn.add(exportColumnParam);
        });
        return exportColumn;
    }

    public static <T extends AbstractOrderQueryParam> void export(HttpServletResponse response, String fileName, List<ExportColumnParam> columnParamList, Function<T, PagingVO<?>> dataProducer, T queryParam) throws Exception {
        AsyncExcelUtils.getExportUtilInstance(response, fileName, columnParamList).write("\u5bfc\u51fa\u6570\u636e", (page, pageSize) -> {
            queryParam.setCurrent(page);
            queryParam.setSize(pageSize);
            return ((PagingVO)dataProducer.apply(queryParam)).getRecords();
        });
    }

    protected <T extends AbstractOrderQueryParam> void export(HttpServletResponse response, String fileName, List<ExportColumnParam> columnParamList, BiFunction<T, Object[], PagingVO<?>> dataProducer, T queryParam, Object[] otherParam) throws Exception {
        AsyncExcelUtils.getExportUtilInstance(response, fileName, columnParamList).write("\u5bfc\u51fa\u6570\u636e", (page, pageSize) -> {
            queryParam.setCurrent(page);
            queryParam.setSize(pageSize);
            return ((PagingVO)dataProducer.apply(queryParam, otherParam)).getRecords();
        });
    }

    private static ExcelExportUtil getExportUtilInstance(HttpServletResponse response, String fileName, List<ExportColumnParam> columnParamList) throws Exception {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8).replace(" ", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        return ExcelExportUtil.instance((OutputStream)response.getOutputStream()).batchSize(100).fields(columnParamList);
    }

    public static <T extends AbstractOrderQueryParam> void exportSheetPage(HttpServletResponse response, String fileName, List<String> sheetNameList, List<Class<?>> clazzs, List<T> queryParams, List<Function<T, PagingVO<?>>> dataProducers) {
        if (sheetNameList.size() != clazzs.size() || queryParams.size() != clazzs.size() || queryParams.size() != dataProducers.size()) {
            throw new IllegalArgumentException("size\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        long startTime = System.currentTimeMillis();
        ServletOutputStream outputStream = null;
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8).replace("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            outputStream = response.getOutputStream();
            ExcelWriter writer = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)CommonCellStyleStrategy.getHorizontalCellStyleStrategy())).registerWriteHandler((WriteHandler)new CustomCellWriteHandler())).build();
            AtomicInteger sheetCount = new AtomicInteger(-1);
            Integer sheetDataRows = ConstantsAfterSale.PER_SHEET_ROW_COUNT;
            Integer writeDataRows = ConstantsAfterSale.PER_WRITE_ROW_COUNT;
            int i = 0;
            for (String sheetName : sheetNameList) {
                AbstractOrderQueryParam queryParam = (AbstractOrderQueryParam)queryParams.get(i);
                Function<AbstractOrderQueryParam, PagingVO<?>> dataProducer = dataProducers.get(i);
                Integer totalCount = Long.valueOf(dataProducer.apply(queryParam).getTotal()).intValue();
                if (totalCount != 0) {
                    AsyncExcelUtils.writeSheetPage(sheetCount, totalCount, sheetDataRows, writeDataRows, sheetName, clazzs.get(i), writer, (page, pageSize) -> {
                        queryParam.setCurrent(page);
                        queryParam.setSize(pageSize);
                        return ((PagingVO)dataProducer.apply(queryParam)).getRecords();
                    });
                } else {
                    sheetCount.addAndGet(1);
                    WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)sheetCount.intValue(), (String)sheetName).head(clazzs.get(i))).build();
                    writer.write(Collections.emptyList(), sheet);
                }
                ++i;
            }
            writer.finish();
            long endTime = System.currentTimeMillis();
            log.info("\u5bfc\u51fa\u6240\u7528\u65f6\u95f4:" + (endTime - startTime) / 1000L + "\u79d2");
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public static void writeSheetPage(AtomicInteger sheetCount, Integer totalCount, Integer sheetDataRows, Integer writeDataRows, String sheetName, Class<?> cls, ExcelWriter writer, BiFunction<Integer, Integer, List<?>> dataProducer) {
        Integer sheetNum = totalCount % sheetDataRows == 0 ? totalCount / sheetDataRows : totalCount / sheetDataRows + 1;
        Integer oneSheetWriteCount = sheetDataRows / writeDataRows;
        Integer beforeSheetNum = sheetNum - 1;
        Integer beforeTotalCount = beforeSheetNum * sheetDataRows;
        Integer surplusTotalCount = totalCount - beforeTotalCount;
        Integer surplusSheetWriteCount = surplusTotalCount % writeDataRows == 0 ? surplusTotalCount / writeDataRows : surplusTotalCount / writeDataRows + 1;
        Integer lastSheetWriteCount = totalCount % sheetDataRows == 0 ? oneSheetWriteCount : surplusSheetWriteCount;
        List<Object> dataList = new ArrayList();
        List transitionList = new ArrayList();
        for (int i = 0; i < sheetNum; ++i) {
            sheetCount.addAndGet(1);
            WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)sheetCount.intValue(), (String)(sheetName + (i + 1))).head(cls)).build();
            for (int j = 0; j < (i != sheetNum - 1 ? oneSheetWriteCount : lastSheetWriteCount); ++j) {
                dataList.clear();
                transitionList.clear();
                dataList = dataProducer.apply(j + 1 + oneSheetWriteCount * i, writeDataRows);
                transitionList = JSON.parseArray((String)JSON.toJSONString(dataList), cls);
                writer.write(transitionList, sheet);
            }
        }
    }
}

