/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.convert.OrderEvaluationConvert;
import com.elitesland.yst.production.aftersale.convert.PictureOrderConvert;
import com.elitesland.yst.production.aftersale.model.entity.OrderEvaluationDO;
import com.elitesland.yst.production.aftersale.model.entity.picture.PictureOrderDO;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogSaveParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import com.elitesland.yst.production.aftersale.service.OrderLogService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.OrderEvaluationRepo;
import com.elitesland.yst.production.aftersale.service.repo.OrderEvaluationRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderEvaluationServiceImpl
implements OrderEvaluationService {
    private static final Logger log = LogManager.getLogger(OrderEvaluationServiceImpl.class);
    @Autowired
    private OrderEvaluationRepo orderEvaluationRepo;
    @Autowired
    private PictureOrderRepo pictureOrderRepo;
    @Autowired
    private OrderEvaluationRepoProc orderEvaluationRepoProc;
    @Autowired
    private SystemService systemService;
    @Autowired
    private PictureOrderService pictureOrderService;
    @Autowired
    private OrderLogService orderLogService;
    @Autowired
    private UserService userService;
    @Value(value="${file.upload.url}")
    private String pictureURL;
    private static final String EVALUATION = "\u5de5\u5355\u8bc4\u8bba";
    private static final String RETURN_APPLY = "\u5de5\u5355\u56de\u8bbf";

    @Override
    @Transactional
    public Long save(OrderEvaluationParam saveVO) {
        Map<String, String> ajStatusMap;
        log.info("\u5de5\u5355\u8bc4\u4ef7\u4fdd\u5b58\u5165\u53c2", (Object)JSON.toJSONString((Object)saveVO));
        this.check(saveVO);
        OrderEvaluationVO oldEvaluation = this.orderEvaluationRepoProc.query(saveVO);
        if (null != oldEvaluation) {
            throw new BusinessException(ApiCode.FAIL, "\u8be5\u5de5\u5355\u5df2\u8bc4\u8bba\uff0c\u8bf7\u52ff\u91cd\u590d\u8bc4\u8bba\uff01");
        }
        OrderEvaluationDO orderEvaluationDO = OrderEvaluationConvert.INSTANCE.saveVoTODO(saveVO);
        Long id = ((OrderEvaluationDO)this.orderEvaluationRepo.save(orderEvaluationDO)).getId();
        List<PictureOrderParam> pictureOrderParamList = saveVO.getPictureOrderParamList();
        if (null != pictureOrderParamList) {
            List collect = pictureOrderParamList.stream().map(t -> {
                PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO((PictureOrderParam)t);
                pictureOrderDO.setOrderId(orderEvaluationDO.getOrderId());
                pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_3.getValueCode());
                return pictureOrderDO;
            }).collect(Collectors.toList());
            this.pictureOrderRepo.saveAll(collect);
        }
        SysUserDTO user = this.userService.getUserDetail();
        Object remark = "";
        if (!StringUtils.isBlank((CharSequence)saveVO.getEvaluationLevel()) && !CollectionUtils.isEmpty(ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.EVALUATION_LEVEL_1.getModel(), UdcEnum.EVALUATION_LEVEL_1.getCode())) && ajStatusMap.containsKey(saveVO.getEvaluationLevel())) {
            remark = (String)remark + "\u8bc4\u8bba\u7ea7\u522b\uff1a" + ajStatusMap.get(saveVO.getEvaluationLevel());
        }
        if (!StringUtils.isBlank((CharSequence)saveVO.getEvaluationContent())) {
            remark = (String)remark + " \u8bc4\u8bba\u5185\u5bb9\uff1a" + saveVO.getEvaluationContent();
        }
        OrderLogSaveParam orderLogSaveParam = new OrderLogSaveParam(saveVO.getOrderId(), saveVO.getOrderType(), EVALUATION, LocalDateTime.now(), user.getUsername(), user.getId());
        orderLogSaveParam.setRemark((String)remark);
        this.orderLogService.orderLogSave(orderLogSaveParam);
        return id;
    }

    @Override
    public OrderEvaluationVO query(OrderEvaluationParam param) {
        OrderEvaluationVO orderEvaluationVO = this.orderEvaluationRepoProc.query(param);
        if (null == orderEvaluationVO) {
            return null;
        }
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(orderEvaluationVO.getOrderId());
        pictureOrderParam.setOrderList(idList);
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_3.getValueCode());
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
        }
        orderEvaluationVO.setPictureOrderVOS(data);
        this.udcTranslate(orderEvaluationVO);
        return orderEvaluationVO;
    }

    @Override
    public PagingVO<OrderEvaluationVO> pageQuery(OrderEvaluationPageParam param) {
        PagingVO<OrderEvaluationVO> pagingVO = null;
        if (param.getOrderType().equals(UdcEnum.EVALUATION_ORDER_TYPE_1.getValueCode())) {
            pagingVO = this.orderEvaluationRepoProc.repairPageQuery(param);
        } else if (param.getOrderType().equals(UdcEnum.EVALUATION_ORDER_TYPE_2.getValueCode())) {
            pagingVO = this.orderEvaluationRepoProc.complaintPageQuery(param);
        }
        if (null != pagingVO) {
            pagingVO.getRecords().forEach(this::udcTranslate);
        }
        return pagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orderEvaluationDelete(List<Long> ids) {
        log.info("\u5de5\u5355\u8bc4\u8bba\u5220\u9664\u5165\u53c2", ids);
        if (ids == null || ids.isEmpty()) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.orderEvaluationRepoProc.deleteOrderEvaluation(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orderEvaluationSolve(OrderEvaluationParam saveVO) {
        Map<String, String> ajStatusMap;
        if (null == saveVO.getId()) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        this.orderEvaluationRepoProc.solve(saveVO);
        SysUserDTO user = this.userService.getUserDetail();
        Object remark = "";
        if (!StringUtils.isBlank((CharSequence)saveVO.getReturnLevel()) && !CollectionUtils.isEmpty(ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.RETURN_LEVEL_1.getModel(), UdcEnum.RETURN_LEVEL_1.getCode())) && ajStatusMap.containsKey(saveVO.getReturnLevel())) {
            remark = (String)remark + "\u56de\u8bbf\u6ee1\u610f\u5ea6\uff1a" + ajStatusMap.get(saveVO.getReturnLevel());
        }
        if (!StringUtils.isBlank((CharSequence)saveVO.getReturnReply())) {
            remark = (String)remark + " \u5904\u7406\u56de\u590d:" + saveVO.getReturnReply();
        }
        if (!StringUtils.isBlank((CharSequence)saveVO.getReturnAdvice())) {
            remark = (String)remark + " \u6539\u5584\u610f\u89c1:" + saveVO.getReturnAdvice();
        }
        OrderLogSaveParam orderLogSaveParam = new OrderLogSaveParam(saveVO.getOrderId(), saveVO.getOrderType(), RETURN_APPLY, LocalDateTime.now(), user.getUsername(), user.getId());
        orderLogSaveParam.setRemark((String)remark);
        this.orderLogService.orderLogSave(orderLogSaveParam);
    }

    @Override
    public List<OrderEvaluationVO> queryList(OrderEvaluationParam orderEvaluationParam) {
        List<OrderEvaluationVO> orderEvaluationVOS = this.orderEvaluationRepoProc.queryList(orderEvaluationParam);
        orderEvaluationVOS.forEach(this::udcTranslate);
        return orderEvaluationVOS;
    }

    @Override
    public void batchSave(List<OrderEvaluationDO> orderEvaluationDOS) {
        this.orderEvaluationRepo.saveAll(orderEvaluationDOS);
    }

    private void check(OrderEvaluationParam saveVO) {
        log.info("\u5de5\u5355\u8bc4\u8bba\u63d0\u4ea4\u5165\u53c2", (Object)JSON.toJSONString((Object)saveVO));
        if (saveVO.getOrderType() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u5de5\u5355\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getOrderId() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u5de5\u5355id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getEvaluationLevel() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u8bc4\u8bba\u7ea7\u522b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    public void udcTranslate(OrderEvaluationVO orderEvaluationVO) {
        Map<String, String> ajStatusMap3;
        Map<String, String> ajStatusMap2;
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.EVALUATION_LEVEL_1.getModel(), UdcEnum.EVALUATION_LEVEL_1.getCode());
        if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(orderEvaluationVO.getEvaluationLevel())) {
            orderEvaluationVO.setEvaluationLevelName(ajStatusMap.get(orderEvaluationVO.getEvaluationLevel()));
        }
        if (!CollectionUtils.isEmpty(ajStatusMap2 = this.systemService.sysUdcGetCodeMap(UdcEnum.EVALUATION_ORDER_TYPE_1.getModel(), UdcEnum.EVALUATION_ORDER_TYPE_1.getCode())) && ajStatusMap2.containsKey(orderEvaluationVO.getOrderType())) {
            orderEvaluationVO.setOrderTypeName(ajStatusMap2.get(orderEvaluationVO.getOrderType()));
        }
        if (!CollectionUtils.isEmpty(ajStatusMap3 = this.systemService.sysUdcGetCodeMap(UdcEnum.RETURN_LEVEL_1.getModel(), UdcEnum.RETURN_LEVEL_1.getCode())) && ajStatusMap3.containsKey(orderEvaluationVO.getReturnLevel())) {
            orderEvaluationVO.setReturnLevelName(ajStatusMap3.get(orderEvaluationVO.getReturnLevel()));
        }
    }
}

