package com.elitesland.yst.production.aftersale.config.support;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.authorization.api.provider.cas.CasUserResolver;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

/**
 * 车主认证登录.
 * <p>
 * 小程序登录时，获取车主ID，如果不存在，则自动注册
 *
 * @author Kaiser（wang shao）
 * @date 2/15/2023
 */
@Component
@Log4j2
public class CasUserResolverCarOwner implements CasUserResolver {

    private final CarOwnerInfoService carOwnerInfoService;

    public CasUserResolverCarOwner(CarOwnerInfoService carOwnerInfoService) {
        this.carOwnerInfoService = carOwnerInfoService;
    }

    @Override
    public Long resolve(AuthUserDTO userInfoDTO) {
        log.info("车主认证【{}, {}】", userInfoDTO.getId(), userInfoDTO.getMobile());

        ApiResult<Long> result = null;
        try {
            result = carOwnerInfoService.registerCarOwnerOnNotExists(userInfoDTO.getMobile(), userInfoDTO.getId(), userInfoDTO.getUsername());
        } catch (Exception e) {
            log.error("车主认证异常：{}", e);
            throw new BusinessException("认证失败，" + e.getMessage());
        }

        if (result != null && result.getData() != null) {
            return result.getData();
        }

        throw new BusinessException("车主认证失败，" + (result == null ? "系统异常" : result.getMsg()));
    }
}
