package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoMngParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehiclePhonePageParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;


/**
 * @author elvis.hong
 * @title PcCarOwnerInfoMngController
 * @Date  2023/2/16
 */
@RestController
@RequestMapping(value = "/pc/ownerInfoMng", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Slf4j
@RequiredArgsConstructor
@Api(value = "中台管理端车主信息管理", tags = {"中台管理端车主信息管理"})
public class PcCarOwnerInfoMngController {

    @Autowired
    private CarOwnerInfoService carOwnerInfoService;

    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;

    private final ExportExcelService<CarOwnerInfoMngParam, CarOwnerInfoMngRespVO, Serializable> exportExcelService;

    @PostMapping("/ownerInfoMngQuery")
    @ApiOperation("车主信息管理分页查询")
    public ApiResult<PagingVO<CarOwnerInfoMngRespVO>> ownerInfoMngQuery(@RequestBody CarOwnerInfoMngParam param) {
        PagingVO<CarOwnerInfoMngRespVO> query = carOwnerInfoService.ownerInfoMngQuery(param);
        return ApiResult.ok(query);
    }


    @PostMapping(value = "/ownerInfoByUserPhone/page")
    @ApiOperation(value = "通过手机号分页查询车辆信息")
    public ApiResult<PagingVO<CarOwnerVehicleInfoVO>> ownerInfoByUserPhonePage(@RequestBody CarOwnerVehiclePhonePageParam param) {
        PagingVO<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVOPagingVO = carOwnerVehicleService.queryPageByPhone(param);
        return ApiResult.ok(carOwnerVehicleInfoVOPagingVO);
    }

    @GetMapping(value = "/ownerInfoMngDetail/{carOwnerId}")
    @ApiOperation(value = "车主信息管理明细查询")
    public ApiResult<CarOwnerInfoMngRespVO> ownerInfoMngDetail(@PathVariable("carOwnerId") Long carOwnerId) {
        return ApiResult.ok(carOwnerInfoService.ownerInfoMngDetail(carOwnerId));
    }

    @PostMapping("/ownerInfoMngEnable")
    @ApiOperation("车主信息管理启用")
    public ApiResult ownerInfoMngEnable(@RequestBody List<Long> casUserIds) {
        carOwnerInfoService.ownerInfoMngUpdateStatus(casUserIds, true, 1);
        return ApiResult.ok();
    }

    @PostMapping("/ownerInfoMngDisable")
    @ApiOperation("车主信息管理禁用")
    public ApiResult ownerInfoMngDisable(@RequestBody List<Long> carOwnerIds) {
        carOwnerInfoService.ownerInfoMngUpdateStatus(carOwnerIds, false, 0);
        return ApiResult.ok();
    }

    @PostMapping(value = "/ownerInfoMngExport", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    @ApiOperation(value = "车主信息管理导出数据")
    public ApiResult<?> ownerInfoMngExport(HttpServletResponse response, @RequestBody CarOwnerInfoMngParam queryVO) {
        ExcelUtils.buildExportColumn(queryVO, CarOwnerInfoMngRespVO.class);
        try {
            exportExcelService.export(queryVO, response, carOwnerInfoService::ownerInfoMngQuery).get();
            return null;
        } catch (Exception e) {
            log.error("导出失败：{}", e);
            return ApiResult.fail("导出失败：" + e.getMessage());
        }
    }

    @PostMapping("/getUserFlmVehicleBindQty")
    @ApiOperation("获取用户绑定的非立马车辆的数量")
    public ApiResult<Integer> getUserFlmVehicleBindQty() {
        return ApiResult.ok(carOwnerVehicleService.getUserFlmVehicleBindQty());
    }

}
