package com.elitesland.yst.production.aftersale.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserAccountDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.config.AuthorizationServiceConfiguration;
import com.elitesland.yst.production.aftersale.convert.ComplaintOrderConvert;
import com.elitesland.yst.production.aftersale.convert.PictureOrderConvert;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.ComplaintOrderDO;
import com.elitesland.yst.production.aftersale.model.entity.OrderEvaluationDO;
import com.elitesland.yst.production.aftersale.model.entity.orderlog.OrderLogDO;
import com.elitesland.yst.production.aftersale.model.entity.picture.PictureOrderDO;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderCancelParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogSaveParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.model.vo.CarVO;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintSetVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderLogVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.provider.support.OrgStoreRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysMsgRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysUserPermissionRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarService;
import com.elitesland.yst.production.aftersale.service.ComplaintOrderService;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import com.elitesland.yst.production.aftersale.service.OrderLogService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintOrderRepo;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintOrderRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintSetRepo;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintSetRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.aftersale.util.ConstantsAfterSale;
import com.elitesland.yst.production.aftersale.util.NumSendEnum;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.elitesland.yst.production.order.rpc.LmVehicleNoRpcService;
import com.elitesland.yst.production.order.rpc.param.LmAfterSaleTimeParam;
import com.elitesland.yst.production.order.rpc.param.resp.LmVehicleNoTimeDTO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.dto.CrmCustDTO;
import com.elitesland.yst.production.sale.service.CrmCustAccountRpcService;
import com.elitesland.yst.production.sale.service.CrmCustRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.google.common.collect.Maps;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author RYH
 * @date 2023/2/14
 */
@Service
@Log4j2
public class ComplaintOrderServiceImpl implements ComplaintOrderService {

    @Autowired
    private ComplaintOrderRepo complaintOrderRepo;

    @Autowired
    private ComplaintOrderRepoProc complaintOrderRepoProc;

    @Autowired
    private CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;

    @Autowired
    private PictureOrderRepo pictureOrderRepo;

    @Autowired
    private PictureOrderService pictureOrderService;

    @Autowired
    private SystemService systemService;

    @Autowired
    private CarService carService;

    @Autowired
    private OrderEvaluationService orderEvaluationService;

    @Autowired
    private OrderLogService orderLogService;

    @Autowired
    private UserService userService;

    @Autowired
    private ComplaintSetRepoProc complaintSetRepoProc;

    @Autowired
    private ComplaintSetRepo complaintSetRepo;

    @Autowired
    private SysMsgRpcProvider sysMsgRpcProvider;

    @Autowired
    private SysUserPermissionRpcProvider sysUserPermissionRpcProvider;

    @Autowired
    private AuthorizationServiceConfiguration authorizationServiceConfiguration;

    @Autowired
    private OrgStoreRpcProvider orgStoreRpcProvider;

    // 发货车架号表RPC
    @Autowired
    private LmVehicleNoRpcService vehicleNoRpcService;

    // 车辆三包信息
    @Autowired
    private CarMaintainCardRepo carMaintainCardRepo;

    // 经销商账户RPC
    @Autowired
    private CrmCustAccountRpcService crmCustAccountRpcService;
    @Autowired
    private CrmCustRpcService crmCustRpcService;

    @Value("${file.upload.url}")
    private String pictureURL;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static final String COMPLETE = "工单完成";
    private static final String CANCEL = "工单取消";
    private static final String COMMIT = "工单提交";
    private static final String DELETE = "工单删除";
    private static final String DISPATCH = "派单";
    private static final String RETURN_APPLY = "工单回访";
    private static final String REPAIR = "REPAIR";
    private static final String COMPLAINT = "COMPLAINT";
    private static final String EVALUATION = "工单评论";
    private static final String EVALUATION_CONTENT = "系统默认好评";
    private static final String EVALUATION_CONTENT_LOG = "评论级别：满意 评论内容：系统默认好评";
    private static final String SYSTEM_USER = "系统管理员";
    private static final Integer LIMIT = 1000;
    private static final String SYSTEM_ROLE_CODE = "ROLE_admin";


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam saveVO) {
        log.info("客诉工单保存入参", JSON.toJSONString(saveVO));
        //必填字段校验
        this.check(saveVO);
        SysUserDTO user = userService.getUserDetail();
        //如果是门店  取门店所属经销商
        if (!StringUtils.isEmpty(user.getUsername()) && user.getUsername().length() == ConstantsAfterSale.LM_STORE_COUNT) {
            List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS = orgStoreRpcProvider.queryByStoreCodes(List.of(user.getUsername()));
            if (!CollectionUtils.isEmpty(orgStoreDetailRpcDTOS)) {
                OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreDetailRpcDTOS.get(0);
                saveVO.setCustName(orgStoreDetailRpcDTO.getCustName());
            }
            //如果是客户登录  直接取值姓名
        } else if (!StringUtils.isEmpty(user.getUsername()) && user.getUsername().length() > ConstantsAfterSale.LM_STORE_COUNT) {
            if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(saveVO.getOrderType())) {
                // XXX 如果是下级子账号取上一级经销商信息
                CustAccountVO custAccount = this.crmCustAccountRpcService.getCustAccountByUserId(user.getId());
                if (custAccount != null && custAccount.getSubAcFlag()) {
                    // 获取到父级经销商
                    String pcustCode = custAccount.getCustCode();
                    ApiResult<CrmCustDTO> pcustInfoRpc = this.crmCustRpcService.getCustInfo(pcustCode);
                    if (pcustInfoRpc.isSuccess() && pcustInfoRpc.getData() != null) {
                        CrmCustDTO data = pcustInfoRpc.getData();
                        saveVO.setCustName(data.getCustName());
                    }
                } else {
                    saveVO.setCustName(user.getPrettyName());
                }

            }
        }
        /*else{
            //预留其他登录信息
        }*/

        //2.有id修改，没有id新增(修改时图片工单需要全删全插)
        if (saveVO.getId() != null && saveVO.getId() != 0) {
            pictureOrderRepo.deleteByOrderId(saveVO.getId());
        } else {
            //发号器发号
            String orderNo = systemService.sysNumberRuleGenerateCode(NumSendEnum.LMK.getCode(), new ArrayList<>());
            saveVO.setOrderNo(orderNo);
            log.info("客诉工单发号：{}", orderNo);

            //设置车主信息
            saveVO.setCarOwnerId(user.getId());

            //小程序改为前端传车主名字
//            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(saveVO.getOrderType())) {
//                saveVO.setOrderPerson(user.getUsername());
//            } else

            if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(saveVO.getOrderType())) {
                saveVO.setOrderPerson(user.getPrettyName());
            }

            saveVO.setOrderTel(user.getMobile());

            //设置初始状态为待处理
            saveVO.setOrderStatus(UdcEnum.COMPLAINT_ORDER_KSS001.getValueCode());
            //设置初始时效状态为正常
            saveVO.setTimeoutStatus(UdcEnum.TIMEOUT_STATUS_1.getValueCode());
        }


        ComplaintOrderDO complaintOrderDO = ComplaintOrderConvert.INSTANCE.saveVoTODO(saveVO);
        Long id = complaintOrderRepo.save(complaintOrderDO).getId();

        //图片集合调用图片工单service进行保存
        List<com.elitesland.yst.production.aftersale.model.param.PictureOrderParam> pictureOrderParamList = saveVO.getPictureOrderParamList();
        if (!CollectionUtils.isEmpty(pictureOrderParamList)) {
            List<PictureOrderDO> collect = pictureOrderParamList.stream().map(t -> {
                PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO(t);
                pictureOrderDO.setOrderId(id);
                pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode());
                return pictureOrderDO;
            }).collect(Collectors.toList());
            pictureOrderRepo.saveAll(collect);
        }

        //日志添加
        if (null == saveVO.getId()) {
            OrderLogSaveParam param = new OrderLogSaveParam(id, UdcEnum.ORDER_TYPE_2.getValueCode(), COMMIT, LocalDateTime.now(), user.getUsername(), user.getId());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(saveVO.getOrderType())) {
                param.setRemark("车主" + user.getUsername() + "提交了客诉工单");
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(saveVO.getOrderType())) {
                param.setRemark("经销商(门店)" + user.getLastName() + "提交了客诉工单");
            }
            orderLogService.orderLogSave(param);

            saveVO.setId(id);
            sendCreateMsg(saveVO);
        }

        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void complaintOrderBatchCancel(List<Long> ids) {
        log.info("客诉工单批量取消入参", ids);
        if (ids == null || ids.isEmpty()) {
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查");
        }

        complaintOrderRepoProc.batchCancel(ids);
        //日志添加
        SysUserDTO user = userService.getUserDetail();
        ids.forEach(item -> {
            OrderLogSaveParam param = new OrderLogSaveParam(item, UdcEnum.ORDER_TYPE_2.getValueCode(), CANCEL, LocalDateTime.now(), user.getUsername(), user.getId());
            orderLogService.orderLogSave(param);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void complaintOrderCancel(ComplaintOrderCancelParam param) {
        log.info("客诉工单取消入参", param);
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查");
        }
        ComplaintOrderDO oldOrder = complaintOrderRepo.findById(param.getId()).orElse(null);
        if (null == oldOrder ||
                (null != oldOrder.getOrderStatus() && !UdcEnum.COMPLAINT_ORDER_KSS001.getValueCode().equals(oldOrder.getOrderStatus()))
        ) {
            throw new BusinessException(ApiCode.FAIL, "只有待受理状态才能取消");
        }
        complaintOrderRepoProc.cancel(param);

        //日志添加
        SysUserDTO user = userService.getUserDetail();
        String remark = "取消原因：";
        if (null != param.getCancelReasonC()) {
            remark = remark + systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_C_1.getModel(), UdcEnum.CANCEL_REASON_C_1.getCode()).get(param.getCancelReasonC());
        } else if (null != param.getCancelReasonB()) {
            remark = remark + systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_B_1.getModel(), UdcEnum.CANCEL_REASON_B_1.getCode()).get(param.getCancelReasonB());
        }

        if (null != param.getCancelDetail()) {
            remark = remark + " 详细信息：" + param.getCancelDetail();
        }
        OrderLogSaveParam orderLogSaveParam = new OrderLogSaveParam(param.getId(), UdcEnum.ORDER_TYPE_2.getValueCode(), CANCEL, LocalDateTime.now(), user.getUsername(), user.getId());
        orderLogSaveParam.setRemark(remark);
        orderLogService.orderLogSave(orderLogSaveParam);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void complaintOrderDelete(List<Long> ids) {
        log.info("客诉工单删除入参", ids);
        if (ids == null || ids.isEmpty()) {
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查");
        }

        complaintOrderRepoProc.deleteComplaint(ids);
        //日志添加
        SysUserDTO user = userService.getUserDetail();
        ids.forEach(item -> {
            OrderLogSaveParam param = new OrderLogSaveParam(item, UdcEnum.ORDER_TYPE_2.getValueCode(), DELETE, LocalDateTime.now(), user.getUsername(), user.getId());
            orderLogService.orderLogSave(param);
        });
    }

    @Override
    public PagingVO<ComplaintOrderVO> query(ComplaintOrderPageParam param) {
        Long userId = userService.getUserId();
        if ("PC".equals(param.getSource())) {
            param.setCarOwnerId(null);
            if (!userService.getUserDetail().getRoleCodes().contains(SYSTEM_ROLE_CODE)) {
                param.setHandlePersonId(userId);
            }
        } else {
            param.setCarOwnerId(userId);
        }

        PagingVO<ComplaintOrderVO> complaintOrderVOS = null;
        //查询客诉工单信息
        if (UdcEnum.COMPLAINT_ORDER_KSS005.getValueCode().equals(param.getOrderStatus())) {
            param.setOrderStatus(UdcEnum.COMPLAINT_ORDER_KSS003.getValueCode());
            complaintOrderVOS = complaintOrderRepoProc.unEvaluationQuery(param);
        } else {
            complaintOrderVOS = complaintOrderRepoProc.query(param);
        }

        if(CollectionUtils.isEmpty(complaintOrderVOS.getRecords())){
            return complaintOrderVOS;
        }

        //填充图片
        this.pictureQuery(complaintOrderVOS.getRecords());

        //填充评论
        this.evaluationQuery(complaintOrderVOS.getRecords());

        //填充问题类别
        this.setQuery(complaintOrderVOS.getRecords());

        //UCD手动翻译
        this.udcTranslate(complaintOrderVOS.getRecords());
        return complaintOrderVOS;
    }

    @Override
    public ComplaintOrderVO queryInfo(ComplaintOrderPageParam param) {
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查！");
        }
        //查询客诉工单详细信息
        ComplaintOrderVO complaintOrderVO = complaintOrderRepoProc.queryInfo(param);
        //todo 根据车架号反查
        if (!StringUtils.isEmpty(complaintOrderVO.getVehicleNo())) {
            CarOwnerVehicleInfoVO byVerNo = carOwnerVehicleRepoProc.getByVerNo(complaintOrderVO.getVehicleNo());
            if (byVerNo != null) {
                complaintOrderVO.setVehicleColor(byVerNo.getVehicleColor());
                complaintOrderVO.setItemCode(byVerNo.getItemCode());
                complaintOrderVO.setVehicleType(byVerNo.getVehicleType());
                complaintOrderVO.setActivatTime(byVerNo.getActivatTime());
                complaintOrderVO.setManufactureDate(byVerNo.getManufactureDate());
            } else {
                CarParam carParam = new CarParam();
                carParam.setVehicleNo(complaintOrderVO.getVehicleNo());
                ApiResult<CarVO> query = null;
                try {
                    query = carService.query(carParam);
                } catch (Exception e) {
                    log.info("根据车架号查询异常", e);
                }
                if (query != null && query.getCode() == ApiCode.SUCCESS.getCode() && query.getData() != null) {
                    CarVO carVo = query.getData();
                    complaintOrderVO.setVehicleColor(carVo.getVehicleColor());
                    // 生产日期、出库时间赋值、车型、绑定时间
                    complaintOrderVO.setManufactureDate(carVo.getManufactureDate());
                    complaintOrderVO.setDocTime(carVo.getDocTime());
                    complaintOrderVO.setVehicleType(carVo.getVehicleType());
                    complaintOrderVO.setBindingTime(carVo.getBindingTime());
                    complaintOrderVO.setItemCode(carVo.getMtnrv());
                }
            }

            String veNo = complaintOrderVO.getVehicleNo();
            // 出库时间为空，进行生产日期、出库时间赋值
            if (complaintOrderVO.getDocTime() == null) {
                LmVehicleNoTimeDTO vehicleNo = this.vehicleNoRpcService.getDocTimeByVehicle(veNo);
                if (vehicleNo != null) {
                    complaintOrderVO.setManufactureDate(vehicleNo.getOfflineTime());
                    complaintOrderVO.setDocTime(vehicleNo.getDocTime());
                }
            }

            // 绑定激活时间
            if (complaintOrderVO.getBindActiveTime() == null) {
                CarMaintainCardDO carMaintainCardDO = carMaintainCardRepo.findByVehicleNoAndDeleteFlag(veNo, 0);
                if (carMaintainCardDO != null) {
                    complaintOrderVO.setBindActiveTime(carMaintainCardDO.getCreateTime());
                }
            }
        }

        //获取客诉图片
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        List<Long> idList = new ArrayList<>();
        idList.add(param.getId());
        pictureOrderParam.setOrderList(idList);
//        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode());
        List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
        }

        if (!CollectionUtils.isEmpty(data)) {
            complaintOrderVO.setPictureOrderVOS(data.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
            complaintOrderVO.setCompletePictureVOS(data.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_4.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
        }

        //获取评论信息
        OrderEvaluationParam orderEvaluationParam = new OrderEvaluationParam();
        orderEvaluationParam.setOrderId(param.getId());
        orderEvaluationParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode());
        OrderEvaluationVO orderEvaluationVO = orderEvaluationService.query(orderEvaluationParam);
        complaintOrderVO.setOrderEvaluationVO(orderEvaluationVO);

        //获取日志
        OrderLogPageParam orderLogPageParam = new OrderLogPageParam();
        orderLogPageParam.setOrderId(param.getId());
        orderLogPageParam.setOrderType(UdcEnum.ORDER_TYPE_2.getValueCode());
        List<OrderLogVO> logs = orderLogService.query(orderLogPageParam);
        complaintOrderVO.setOrderLogs(logs);

//        List<OrderLogVO> replyLogs = logs.stream()
//                .filter(log -> (RETURN_APPLY.equals(log.getOperationContent()) || COMPLETE.equals(log.getOperationContent())) && StringUtils.isNotBlank(log.getOperationContent()))
//                .collect(Collectors.toList());
        List<OrderLogVO> replyLogs = new ArrayList<>();

        //优先获取评论里的处理回复
        if (null != orderEvaluationVO && StringUtils.isNotEmpty(orderEvaluationVO.getReturnReply())) {
            OrderLogVO orderLogVO = new OrderLogVO();
            orderLogVO.setOperationTime(orderEvaluationVO.getModifyTime());
            orderLogVO.setRemark(orderEvaluationVO.getReturnReply());
            replyLogs.add(orderLogVO);
        }

        //获取处理回复
        if (StringUtils.isNotEmpty(complaintOrderVO.getHandleReply())) {
            OrderLogVO orderLogVO = new OrderLogVO();
            orderLogVO.setOperationTime(complaintOrderVO.getCompleteTime());
            orderLogVO.setRemark(complaintOrderVO.getHandleReply());
            replyLogs.add(orderLogVO);
        }

        complaintOrderVO.setReplies(replyLogs);

        if (!replyLogs.isEmpty()) {
            complaintOrderVO.setLatestReply(replyLogs.get(0).getRemark());
        }

        //udc翻译
        List<ComplaintOrderVO> list = new ArrayList<>();
        list.add(complaintOrderVO);

        //问题类型填充
        this.setQuery(list);

        this.udcTranslate(list);

        return complaintOrderVO;
    }

    @Override
    public PagingVO<ComplaintOrderVO> export(ComplaintOrderExlParam complaintOrderExlParam) {
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setOrderType(complaintOrderExlParam.getOrderType());
        complaintOrderPageParam.setIdList(complaintOrderExlParam.getIdList());
        complaintOrderPageParam.setOrderNo(complaintOrderExlParam.getOrderNo());
        complaintOrderPageParam.setOrderStatus(complaintOrderExlParam.getOrderStatus());
        complaintOrderPageParam.setOrderTel(complaintOrderExlParam.getOrderTel());
        complaintOrderPageParam.setOrderPerson(complaintOrderExlParam.getOrderPerson());
        complaintOrderPageParam.setIssueType(complaintOrderExlParam.getIssueType());
        complaintOrderPageParam.setStartTime(complaintOrderExlParam.getStartTime());
        complaintOrderPageParam.setEndTime(complaintOrderExlParam.getEndTime());
        complaintOrderPageParam.setCurrent(complaintOrderExlParam.getCurrent());
        complaintOrderPageParam.setSize(complaintOrderExlParam.getSize());
        complaintOrderPageParam.setOrders(complaintOrderExlParam.getOrders());
        complaintOrderPageParam.setVehicleType(complaintOrderExlParam.getVehicleType());
        complaintOrderPageParam.setBindingTimeStart(complaintOrderExlParam.getBindingTimeStart());
        complaintOrderPageParam.setBindingTimeEnd(complaintOrderExlParam.getBindingTimeEnd());
        complaintOrderPageParam.setVehicleNo(complaintOrderExlParam.getVehicleNo());
        complaintOrderPageParam.setActivatTimeStart(complaintOrderExlParam.getActivatTimeStart());
        complaintOrderPageParam.setActivatTimeEnd(complaintOrderExlParam.getActivatTimeEnd());
        complaintOrderPageParam.setCustName(complaintOrderExlParam.getCustName());
        PagingVO<ComplaintOrderVO> complaintOrderVOS = complaintOrderRepoProc.exportQuery(complaintOrderPageParam);

        //问题类型翻译
        this.setQuery(complaintOrderVOS.getRecords());

        complaintOrderVOS.getRecords().forEach(x -> {
            if (StringUtils.isNotEmpty(x.getEvaluationLevel())) {
                x.setEvaluationStatus("已评价");
            } else {
                x.setEvaluationStatus("待评价");
            }

            x.setFeedbackPerson(x.getOrderPerson());

            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(x.getOrderType())) {
                x.setSource("车主");
            }

            if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(x.getOrderType())) {
                x.setSource("经销商");
            }
        });
        //填充生产时间，车辆编码，出库时间
        this.docTimeQuery(complaintOrderVOS, complaintOrderPageParam);
        //UCD手动翻译
        this.udcTranslate(complaintOrderVOS.getRecords());
        //评价UCD手动翻译
        this.evaluationUdcTranslate(complaintOrderVOS.getRecords());
        return complaintOrderVOS;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void complaintOrderDispatch(ComplaintOrderParam saveVO) {
        if (null == saveVO.getId()) {
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查！");
        }

        ComplaintOrderDO oldOrder = complaintOrderRepo.findById(saveVO.getId()).orElse(null);
        if (null == oldOrder ||
                (null != oldOrder.getOrderStatus() &&
                        !(UdcEnum.COMPLAINT_ORDER_KSS001.getValueCode().equals(oldOrder.getOrderStatus())
                                || UdcEnum.COMPLAINT_ORDER_KSS002.getValueCode().equals(oldOrder.getOrderStatus())
                        ))) {
            throw new BusinessException(ApiCode.FAIL, "只有待受理和受理中状态才能派单");
        }

        //获取当前用户信息
        SysUserDTO user = userService.getUserDetail();
        saveVO.setDispatchPersonId(user.getId());

        //保存派单信息
        complaintOrderRepoProc.complaintOrderDispatch(saveVO);

        //记录日志
        OrderLogSaveParam param = new OrderLogSaveParam(saveVO.getId(), UdcEnum.ORDER_TYPE_2.getValueCode(), DISPATCH, LocalDateTime.now(), user.getUsername(), user.getId());
        param.setRemark("指派：" + saveVO.getHandlePersonName() + ",处理,联系电话:" + saveVO.getHandlePersonTel());
        orderLogService.orderLogSave(param);

        oldOrder.setHandlePersonId(saveVO.getHandlePersonId());
        sendDispatchMsg(oldOrder);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void complaintOrderComplete(ComplaintOrderParam saveVO) {
        if (null == saveVO.getId()) {
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查！");
        }

        ComplaintOrderDO oldOrder = complaintOrderRepo.findById(saveVO.getId()).orElse(null);
        if (null == oldOrder ||
                (null != oldOrder.getOrderStatus() && !UdcEnum.COMPLAINT_ORDER_KSS002.getValueCode().equals(oldOrder.getOrderStatus()))
        ) {
            throw new BusinessException(ApiCode.FAIL, "只有受理状态下才能完成");
        }


        //获取当前用户信息
        SysUserDTO user = userService.getUserDetail();

        //保存完成信息
        complaintOrderRepoProc.complaintOrderComplete(saveVO);

        //保存完成图片
        List<com.elitesland.yst.production.aftersale.model.param.PictureOrderParam> completePictures = saveVO.getCompletePictureVOS();
        if (!CollectionUtils.isEmpty(completePictures)) {
            List<PictureOrderDO> collect = completePictures.stream().map(t -> {
                PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO(t);
                pictureOrderDO.setOrderId(saveVO.getId());
                pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_4.getValueCode());
                return pictureOrderDO;
            }).collect(Collectors.toList());
            pictureOrderRepo.saveAll(collect);
        }

        //记录日志
        OrderLogSaveParam param = new OrderLogSaveParam(saveVO.getId(), UdcEnum.ORDER_TYPE_2.getValueCode(), COMPLETE, LocalDateTime.now(), user.getUsername(), user.getId());
        param.setRemark("处理回复：" + saveVO.getHandleReply());
        orderLogService.orderLogSave(param);

        sendCompleteMsg(oldOrder);
    }

    /**
     * 问题类型、问题描述、问题图片为必填项，为空时提示对应字段不能为空
     *
     * @param saveVO
     */
    private void check(com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam saveVO) {
        log.info("客诉工单提交入参", JSON.toJSONString(saveVO));
        if (saveVO.getIssueType() == null) {
            throw new BusinessException(ApiCode.FAIL, "问题类型为空，请检查！");
        }
        if (saveVO.getIssueDescription() == null) {
            throw new BusinessException(ApiCode.FAIL, "问题描述为空，请检查！");
        }
        if (saveVO.getOrderType() == null) {
            throw new BusinessException(ApiCode.FAIL, "客诉类型为空，请检查！");
        }
    }

    /**
     * 评论UDC翻译
     *
     * @param complaintOrderVO
     */
    public void evaluationUdcTranslate(List<ComplaintOrderVO> complaintOrderVO) {
        Map<String, String> ajStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.EVALUATION_LEVEL_1.getModel(), UdcEnum.EVALUATION_LEVEL_1.getCode());
        Map<String, String> ajStatusMap2 = systemService.sysUdcGetCodeMap(UdcEnum.RETURN_LEVEL_1.getModel(), UdcEnum.RETURN_LEVEL_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(t.getEvaluationLevel())) {
                t.setEvaluationLevelName(ajStatusMap.get(t.getEvaluationLevel()));
            }

            if (!CollectionUtils.isEmpty(ajStatusMap2) && ajStatusMap2.containsKey(t.getEvaluationLevel())) {
                t.setReturnLevelName(ajStatusMap2.get(t.getReturnLevel()));
            }
        });

    }

    /**
     * UDC翻译
     *
     * @param complaintOrderVO
     */
    public void udcTranslate(List<ComplaintOrderVO> complaintOrderVO) {
        Map<String, String> ajStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.COMPLAINT_ORDER_KSS001.getModel(), UdcEnum.COMPLAINT_ORDER_KSS001.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(t.getOrderStatus())) {
                t.setOrderStatusName(ajStatusMap.get(t.getOrderStatus()));
            }
        });

        Map<String, String> ajStatusMap2 = systemService.sysUdcGetCodeMap(UdcEnum.TIMEOUT_STATUS_1.getModel(), UdcEnum.TIMEOUT_STATUS_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap2) && ajStatusMap2.containsKey(t.getTimeoutStatus())) {
                t.setTimeoutStatusName(ajStatusMap2.get(t.getTimeoutStatus()));
            }
        });

        Map<String, String> ajStatusMap3 = systemService.sysUdcGetCodeMap(UdcEnum.COMPLAINT_TYPE_1.getModel(), UdcEnum.COMPLAINT_TYPE_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap3) && ajStatusMap3.containsKey(t.getOrderType())) {
                t.setOrderTypeName(ajStatusMap3.get(t.getOrderType()));
            }
        });

        Map<String, String> ajStatusMap4 = systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_C_1.getModel(), UdcEnum.CANCEL_REASON_C_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap4) && ajStatusMap4.containsKey(t.getCancelReasonC())) {
                t.setCancelReasonCName(ajStatusMap4.get(t.getCancelReasonC()));
            }
        });

        Map<String, String> ajStatusMap5 = systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_B_1.getModel(), UdcEnum.CANCEL_REASON_B_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap5) && ajStatusMap5.containsKey(t.getCancelReasonB())) {
                t.setCancelReasonBName(ajStatusMap5.get(t.getCancelReasonB()));
            }
        });
    }

    /**
     * 生产时间，车辆编码，出库时间
     *
     * @param complaintOrderVOS
     * @param param
     */
    public PagingVO<ComplaintOrderVO> docTimeQuery(PagingVO<ComplaintOrderVO> complaintOrderVOS, ComplaintOrderPageParam param) {
        List<String> vehicles = complaintOrderVOS.stream()
                .map(ComplaintOrderVO::getVehicleNo)
                .filter(StringUtils::isNotBlank)
                .collect(Collectors.toList());

        if (vehicles.isEmpty()) {
            return complaintOrderVOS;
        }

        Map<String, LmVehicleNoTimeDTO> vehicleInfoMap = new HashMap<>();
        LmAfterSaleTimeParam lmAfterSaleTimeParam = new LmAfterSaleTimeParam();
        lmAfterSaleTimeParam.setVehicles(vehicles);

        ApiResult<List<LmVehicleNoTimeDTO>> docTimeByListVehicles = vehicleNoRpcService.getDocTimeByListVehicles(lmAfterSaleTimeParam);
        if (docTimeByListVehicles != null) {
            List<LmVehicleNoTimeDTO> dtos = docTimeByListVehicles.getData();
            if (dtos != null) {
                for (LmVehicleNoTimeDTO dto : dtos) {
                    vehicleInfoMap.put(dto.getVehicleNo(), dto);
                }
            }
        }

        complaintOrderVOS.getRecords().forEach(x -> {
            String vehicleNo = x.getVehicleNo();
            LmVehicleNoTimeDTO vehicleNoInfo = vehicleInfoMap.get(vehicleNo);
            if (vehicleNoInfo != null) {
                x.setDocTime(vehicleNoInfo.getDocTime());
                x.setManufactureDate(vehicleNoInfo.getOfflineTime());
                x.setItemCode(vehicleNoInfo.getItemCode());
            }
        });

        return complaintOrderVOS;
    }

    public void setQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        if (complaintOrderVOS.isEmpty()) {
            return;
        }
        String sql = "SELECT * FROM complaint_set";
        List<ComplaintSetVO> complaintSetVOS = jdbcTemplate.query(sql, new BeanPropertyRowMapper<>(ComplaintSetVO.class));
        //对应问题类型赋值
        complaintOrderVOS.forEach(t -> {
            complaintSetVOS.forEach(set -> {
                if (t.getIssueType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                    if (String.valueOf(set.getId()).equals(t.getIssueType()) && set.getComplaintType().equals(t.getOrderType())) {
                        List<ComplaintSetVO> complaintOrders = getAllItems(complaintSetVOS, set.getId());
                        t.setIssueTypeName(getAllClassifyName(complaintOrders));
                    }
                }
                if (t.getConfirmType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                    if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("2")) {
                        List<ComplaintSetVO> complaintOrders = getAllItems(complaintSetVOS, set.getId());
                        t.setConfirmTypeName(getAllClassifyName(complaintOrders));
                    } else if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("1")) {
                        t.setConfirmTypeName(set.getClassifyName());
                    }
                }
            });
        });
    }

    //得到所有的父标签
    public List<ComplaintSetVO> getAllItems(List<ComplaintSetVO> complaintSetVOS, Long id) {
        List<ComplaintSetVO> complaintOrders = new ArrayList<>();
        while (id != 0) {
            Long finalId = id;
            Optional<ComplaintSetVO> op = complaintSetVOS.stream().filter(x -> x.getId().equals(finalId)).findFirst();
            if(op.isEmpty()){
                throw new BusinessException("");
            }
            complaintOrders.add(op.get());
            id = op.get().getPid();
        }
        return complaintOrders;
    }

    //拼接成"售后服务->sad->sad213->2321->2313"
    public String getAllClassifyName(List<ComplaintSetVO> complaintOrders) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = complaintOrders.size() - 1; i >= 0; i--) {
            if (i != 0) {
                stringBuilder.append(complaintOrders.get(i).getClassifyName()).append("->");
            } else {
                stringBuilder.append(complaintOrders.get(i).getClassifyName());
            }
        }
        return stringBuilder.toString();
    }


    public void pictureQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        List<Long> collect = complaintOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0).map(ComplaintOrderVO::getId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(collect);
//        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode());
        List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
        }
        //对应图片信息赋值
        complaintOrderVOS.stream().forEach(t -> {
            List<PictureOrderVO> respVOList = data.stream().filter(pic -> pic.getOrderId().equals(t.getId())).collect(Collectors.toList());
            t.setPictureOrderVOS(respVOList.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
            t.setCompletePictureVOS(respVOList.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_4.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
        });
    }

    public void evaluationQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        List<Long> collect = complaintOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0).map(ComplaintOrderVO::getId).collect(Collectors.toList());
        OrderEvaluationParam orderEvaluationParam = new OrderEvaluationParam();
        orderEvaluationParam.setOrderIdList(collect);
        orderEvaluationParam.setOrderType(UdcEnum.EVALUATION_ORDER_TYPE_2.getValueCode());
        List<OrderEvaluationVO> data = orderEvaluationService.queryList(orderEvaluationParam);
        //对应图片信息赋值
        complaintOrderVOS.forEach(t -> {
            List<OrderEvaluationVO> evaluationVOList = data.stream().filter(item -> item.getOrderId().equals(t.getId())).collect(Collectors.toList());
            if (!evaluationVOList.isEmpty()) {
                t.setOrderEvaluationVO(evaluationVOList.get(0));
            }
        });
    }

    private void sendCreateMsg(ComplaintOrderParam param) {
        try {
            TemplateEmployeeSendParamDTO dto = new TemplateEmployeeSendParamDTO();
            dto.setTemplateCode("WXC0001");
            HashMap<String, String> objectObjectHashMap = new HashMap<>();
            objectObjectHashMap.put("orderNo", param.getOrderNo());
            objectObjectHashMap.put("orderId", param.getId().toString());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(param.getOrderType())) {
                objectObjectHashMap.put("msgType", "cm_complaint_order_list");
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(param.getOrderType())) {
                objectObjectHashMap.put("msgType", "bm_complaint_order_list");
            }
            dto.setMesJoinParamMap(objectObjectHashMap);

            Map<String, String> interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", param.getOrderNo());


            Set<Long> set = sysUserPermissionRpcProvider.getUserIdByRoleCode("KSSENDUSER");
            List<Long> userIdList = new ArrayList<>(set);
            List<MsgRecipientUserDTO> recipientUserList = new ArrayList<>();
            userIdList.forEach(x -> {
                MsgRecipientUserDTO recipient = MsgRecipientUserDTO.builder()
                        .userId(x)
                        .build();
                recipientUserList.add(recipient);
            });


            sysMsgRpcProvider.sendEmployeeInteriorMsg(dto, interiorMap, recipientUserList);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void sendDispatchMsg(ComplaintOrderDO complaintOrderDO) {
        try {
            //员工提醒
            TemplateEmployeeSendParamDTO dto = new TemplateEmployeeSendParamDTO();
            dto.setTemplateCode("WXC0003");
            HashMap<String, String> objectObjectHashMap = new HashMap<>();
            objectObjectHashMap.put("orderNo", complaintOrderDO.getOrderNo());
            objectObjectHashMap.put("orderId", complaintOrderDO.getId().toString());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(complaintOrderDO.getOrderType())) {
                objectObjectHashMap.put("msgType", "cm_complaint_order_list");
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(complaintOrderDO.getOrderType())) {
                objectObjectHashMap.put("msgType", "bm_complaint_order_list");
            }
            dto.setMesJoinParamMap(objectObjectHashMap);

            List<MsgRecipientUserDTO> recipientUserList = new ArrayList<>();
            MsgRecipientUserDTO recipient = MsgRecipientUserDTO.builder()
                    .userId(complaintOrderDO.getHandlePersonId())
                    .build();
            recipientUserList.add(recipient);


            Map<String, String> interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", complaintOrderDO.getOrderNo());

            sysMsgRpcProvider.sendEmployeeInteriorMsg(dto, interiorMap, recipientUserList);


            //用户提醒
            TemplateAssignSendParamDTO custDto = new TemplateAssignSendParamDTO();
            custDto.setTemplateCode("WXB0003");
            String receiveUser = "";
            HashMap<String, String> custObjectObjectHashMap = new HashMap<>();
            custObjectObjectHashMap.put("orderNo", complaintOrderDO.getOrderNo());
            custObjectObjectHashMap.put("orderId", complaintOrderDO.getId().toString());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(complaintOrderDO.getOrderType())) {
                custObjectObjectHashMap.put("msgType", "c_complaint_order_detail");
                UserTransferHelper userTransferHelper = UserTransferHelper.getInstance(authorizationServiceConfiguration.getAuthServer());
                var result = userTransferHelper.getUserByMobile(complaintOrderDO.getOrderTel());
                if (null != result) {
                    receiveUser = result.getData().getUsername();
                }
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(complaintOrderDO.getOrderType())) {
                custObjectObjectHashMap.put("msgType", "b_complaint_order_list");
                receiveUser = complaintOrderDO.getCreator();
            }
            custDto.setMesJoinParamMap(custObjectObjectHashMap);


            Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<>();
            map3.put(MsgSendTypeEnum.SYS_INTERIOR,
                    TemplateAssignRecipientUserAccountDTO.builder().account(receiveUser).build());
            List<TemplateAssignRecipientUserDTO> custRecipientUserList = new ArrayList<>();
            TemplateAssignRecipientUserDTO custRecipient = TemplateAssignRecipientUserDTO.builder()
                    .recipientUserAccountDtoMap(map3)
                    .userName(complaintOrderDO.getOrderPerson())
                    .build();
            custRecipientUserList.add(custRecipient);

            Map<String, String> custInteriorMap = Maps.newHashMap();
            custInteriorMap.put("orderNo", complaintOrderDO.getOrderNo());
            sysMsgRpcProvider.sendCustomInteriorMsg(custDto, custInteriorMap, custRecipientUserList);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void sendCompleteMsg(ComplaintOrderDO complaintOrderDO) {
        try {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            HashMap<String, String> objectObjectHashMap = new HashMap<>();
            objectObjectHashMap.put("orderNo", complaintOrderDO.getOrderNo());
            objectObjectHashMap.put("orderId", complaintOrderDO.getId().toString());
            String receiveUser = "";
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(complaintOrderDO.getOrderType())) {
                objectObjectHashMap.put("msgType", "c_complaint_order_detail");
                dto.setTemplateCode("WXC0007");
                UserTransferHelper userTransferHelper = UserTransferHelper.getInstance(authorizationServiceConfiguration.getAuthServer());
                var result = userTransferHelper.getUserByMobile(complaintOrderDO.getOrderTel());
                if (null != result) {
                    receiveUser = result.getData().getUsername();
                }
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(complaintOrderDO.getOrderType())) {
                objectObjectHashMap.put("msgType", "b_complaint_order_list");
                dto.setTemplateCode("WXB0002");
                receiveUser = complaintOrderDO.getCreator();
            }
            dto.setMesJoinParamMap(objectObjectHashMap);

            Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<>();
            map3.put(MsgSendTypeEnum.SYS_INTERIOR,
                    TemplateAssignRecipientUserAccountDTO.builder().account(receiveUser).build());
            List<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<>();
            TemplateAssignRecipientUserDTO custRecipient = TemplateAssignRecipientUserDTO.builder()
                    .recipientUserAccountDtoMap(map3)
                    .userName(complaintOrderDO.getOrderPerson())
                    .build();
            recipientUserList.add(custRecipient);


            Map<String, String> interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", complaintOrderDO.getOrderNo());

            sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
    }


    /**
     * 客诉工单状态信息更新
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void complaintOrderJob() {
        log.info("开始更新客诉工单状态");
        ComplaintSetPageParam complaintSetPageParam = new ComplaintSetPageParam();
        complaintSetPageParam.setComplaintType("3");
        complaintSetPageParam.setClassifyCode(COMPLAINT);
        List<ComplaintSetVO> complaintSetVOS = complaintSetRepoProc.complaintSetQuery(complaintSetPageParam);

        if (CollectionUtils.isEmpty(complaintSetVOS)) {
            throw new BusinessException(ApiCode.FAIL, "获取客诉工单默认评价时间配置为空");
        }

        int current = 1;
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setCurrent(current);
        complaintOrderPageParam.setSize(LIMIT);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        List<OrderItem> itemList = new ArrayList<>();
        itemList.add(orderItem);
        complaintOrderPageParam.setOrders(itemList);

        ComplaintSetVO complaintSetVO = complaintSetVOS.get(0);
        LocalDateTime time = LocalDateTime.now().minusHours(Long.parseLong(complaintSetVO.getMaxHandle()));
        PagingVO<ComplaintOrderVO> list = complaintOrderRepoProc.findPageComplaintOrder(complaintOrderPageParam, time);

        List<OrderEvaluationDO> evaluationDOS = new ArrayList<>(1000);
        List<OrderLogDO> orderLogDOS = new ArrayList<>(1000);
        while (!CollectionUtils.isEmpty(list.getRecords())) {
            list.getRecords().forEach(item -> {
                OrderEvaluationDO orderEvaluationDO = new OrderEvaluationDO();
                orderEvaluationDO.setOrderId(item.getId());
                orderEvaluationDO.setEvaluationLevel(UdcEnum.EVALUATION_LEVEL_1.getValueCode());
                orderEvaluationDO.setEvaluationContent(EVALUATION_CONTENT);
                orderEvaluationDO.setOrderType(UdcEnum.ORDER_TYPE_2.getValueCode());
                orderEvaluationDO.setModifyUserId(1L);
                orderEvaluationDO.setCreateUserId(1L);
                orderEvaluationDO.setCreator(SYSTEM_USER);
                orderEvaluationDO.setUpdater(SYSTEM_USER);
                evaluationDOS.add(orderEvaluationDO);

                OrderLogDO orderLogDO = new OrderLogDO();
                orderLogDO.setOrderId(item.getId());
                orderLogDO.setOrderType(UdcEnum.ORDER_TYPE_2.getValueCode());
                orderLogDO.setOperationContent(EVALUATION);
                orderLogDO.setRemark(EVALUATION_CONTENT_LOG);
                orderLogDO.setModifyUserId(1L);
                orderLogDO.setCreateUserId(1L);
                orderLogDO.setCreator(SYSTEM_USER);
                orderLogDO.setUpdater(SYSTEM_USER);
                orderLogDO.setOperationTime(LocalDateTime.now());
                orderLogDO.setOperationUser(SYSTEM_USER);
                orderLogDO.setOperationUserId(1L);
                orderLogDOS.add(orderLogDO);
            });

            orderEvaluationService.batchSave(evaluationDOS);
            orderLogService.batchSave(orderLogDOS);
            evaluationDOS.clear();
            orderLogDOS.clear();
            current++;
            complaintOrderPageParam.setCurrent(current);
            list = complaintOrderRepoProc.findPageComplaintOrder(complaintOrderPageParam, time);
        }
    }

    /**
     * 维修工单状态信息更新
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void repairOrderJob() {
        log.info("开始更新维修工单状态");
        ComplaintSetPageParam complaintSetPageParam = new ComplaintSetPageParam();
        complaintSetPageParam.setComplaintType("3");
        complaintSetPageParam.setClassifyCode(REPAIR);
        List<ComplaintSetVO> complaintSetVOS = complaintSetRepoProc.complaintSetQuery(complaintSetPageParam);

        if (CollectionUtils.isEmpty(complaintSetVOS)) {
            throw new BusinessException(ApiCode.FAIL, "获取维修工单默认评价时间配置为空");
        }

        int current = 1;
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setCurrent(current);
        complaintOrderPageParam.setSize(LIMIT);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        List<OrderItem> itemList = new ArrayList<>();
        itemList.add(orderItem);
        complaintOrderPageParam.setOrders(itemList);


        ComplaintSetVO complaintSetVO = complaintSetVOS.get(0);
        LocalDateTime time = LocalDateTime.now().minusHours(Long.parseLong(complaintSetVO.getMaxHandle()));
        PagingVO<RepairOrderVO> list = complaintOrderRepoProc.findPageRepairOrder(complaintOrderPageParam, time);

        List<OrderEvaluationDO> evaluationDOS = new ArrayList<>(1000);
        List<OrderLogDO> orderLogDOS = new ArrayList<>(1000);
        while (!CollectionUtils.isEmpty(list.getRecords())) {
            list.getRecords().forEach(item -> {
                OrderEvaluationDO orderEvaluationDO = new OrderEvaluationDO();
                orderEvaluationDO.setOrderId(item.getId());
                orderEvaluationDO.setEvaluationLevel(UdcEnum.EVALUATION_LEVEL_1.getValueCode());
                orderEvaluationDO.setEvaluationContent(EVALUATION_CONTENT);
                orderEvaluationDO.setOrderType(UdcEnum.ORDER_TYPE_1.getValueCode());
                orderEvaluationDO.setModifyUserId(1L);
                orderEvaluationDO.setCreateUserId(1L);
                orderEvaluationDO.setCreator(SYSTEM_USER);
                orderEvaluationDO.setUpdater(SYSTEM_USER);
                evaluationDOS.add(orderEvaluationDO);

                OrderLogDO orderLogDO = new OrderLogDO();
                orderLogDO.setOrderId(item.getId());
                orderLogDO.setOrderType(UdcEnum.ORDER_TYPE_1.getValueCode());
                orderLogDO.setOperationContent(EVALUATION);
                orderLogDO.setRemark(EVALUATION_CONTENT_LOG);
                orderLogDO.setModifyUserId(1L);
                orderLogDO.setCreateUserId(1L);
                orderLogDO.setCreator(SYSTEM_USER);
                orderLogDO.setUpdater(SYSTEM_USER);
                orderLogDO.setOperationTime(LocalDateTime.now());
                orderLogDO.setOperationUser(SYSTEM_USER);
                orderLogDO.setOperationUserId(1L);
                orderLogDOS.add(orderLogDO);
            });

            orderEvaluationService.batchSave(evaluationDOS);
            orderLogService.batchSave(orderLogDOS);
            evaluationDOS.clear();
            orderLogDOS.clear();
            current++;
            complaintOrderPageParam.setCurrent(current);
            list = complaintOrderRepoProc.findPageRepairOrder(complaintOrderPageParam, time);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void respTimeOutJob() {
        log.info("开始工单响应超时状态任务");

        ComplaintSetPageParam bParam = new ComplaintSetPageParam();
        bParam.setComplaintType(UdcEnum.COMPLAINT_TYPE_2.getValueCode());
        List<ComplaintSetVO> complaintBSetCVOS = complaintSetRepoProc.complaintSetQuery(bParam);
        Map<String, String> bMap = complaintBSetCVOS.stream()
                .filter(complaintSetVO -> StringUtils.isNotEmpty(complaintSetVO.getMaxResp()))
                .collect(Collectors.toMap(ComplaintSetVO::getClassifyCode, ComplaintSetVO::getMaxResp));

        if (CollectionUtils.isEmpty(complaintBSetCVOS)) {
            throw new BusinessException(ApiCode.FAIL, "获取工单超时时间配置为空");
        }

        int current = 1;
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setCurrent(current);
        complaintOrderPageParam.setSize(LIMIT);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        List<OrderItem> itemList = new ArrayList<>();
        itemList.add(orderItem);
        complaintOrderPageParam.setOrders(itemList);

        LocalDateTime now = LocalDateTime.now();
        PagingVO<ComplaintOrderVO> complaintOrderVOS = complaintOrderRepoProc.findPageTimeout(complaintOrderPageParam, "rsp");

        List<Long> idList = new ArrayList<>();
        while (!CollectionUtils.isEmpty(complaintOrderVOS.getRecords())) {
            complaintOrderVOS.getRecords().forEach(item -> {
                if (bMap.containsKey(item.getIssueType()) && item.getCreateTime().plusHours(Long.parseLong(bMap.get(item.getIssueType()))).compareTo(now) < 0) {
                    idList.add(item.getId());
                }
            });


            current++;
            complaintOrderPageParam.setCurrent(current);
            complaintOrderVOS = complaintOrderRepoProc.findPageTimeout(complaintOrderPageParam, "rsp");
        }

        if (!idList.isEmpty()) {
            complaintOrderRepoProc.rspTimeOut(idList);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void handleTimeOutJob() {
        log.info("开始工单处理超时状态任务");

        ComplaintSetPageParam bParam = new ComplaintSetPageParam();
        bParam.setComplaintType(UdcEnum.COMPLAINT_TYPE_2.getValueCode());
        List<ComplaintSetVO> complaintBSetCVOS = complaintSetRepoProc.complaintSetQuery(bParam);
        Map<String, String> bMap = complaintBSetCVOS.stream()
                .filter(complaintSetVO -> StringUtils.isNotEmpty(complaintSetVO.getMaxHandle())).collect(Collectors.toMap(ComplaintSetVO::getClassifyCode, ComplaintSetVO::getMaxHandle));

        if (CollectionUtils.isEmpty(bMap)) {
            throw new BusinessException(ApiCode.FAIL, "获取工单超时时间配置为空");
        }

        int current = 1;
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setCurrent(current);
        complaintOrderPageParam.setSize(LIMIT);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        List<OrderItem> itemList = new ArrayList<>();
        itemList.add(orderItem);
        complaintOrderPageParam.setOrders(itemList);

        LocalDateTime now = LocalDateTime.now();
        PagingVO<ComplaintOrderVO> complaintOrderVOS = complaintOrderRepoProc.findPageTimeout(complaintOrderPageParam, "handle");

        List<Long> idList = new ArrayList<>();
        while (!CollectionUtils.isEmpty(complaintOrderVOS.getRecords())) {
            complaintOrderVOS.getRecords().forEach(item -> {
                if (bMap.containsKey(item.getIssueType()) && item.getDispatchTime().plusHours(Long.parseLong(bMap.get(item.getIssueType()))).compareTo(now) < 0) {
                    idList.add(item.getId());
                }
            });

            current++;
            complaintOrderPageParam.setCurrent(current);
            complaintOrderVOS = complaintOrderRepoProc.findPageTimeout(complaintOrderPageParam, "handle");
        }

        if (!idList.isEmpty()) {
            complaintOrderRepoProc.handleTimeOut(idList);
        }
    }
}
