package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


@Entity
@Table(name = "item_backups_t")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "item_backups_t", comment = "售后商品临时备份表")
@Where(clause = "delete_flag = 0")
@Data
@Accessors(chain = true)
@ApiModel(value = "item_backups_t", description = "售后商品临时备份表")
public class ItemBackupsDO extends BaseModel {

    @ApiModelProperty("商品SKU规格")
    @Column(name = "itm_attr", columnDefinition = "varchar(255) comment '商品SKU规格'")
    private String itmAttr;

    @ApiModelProperty("物料类型ITEM_TYPE5")
    @Column(name = "item_type5", columnDefinition = "varchar(255) comment '物料类型ITEM_TYPE5'")
    private String itemType5;
    @ApiModelProperty("spu名称")
    @Column(name = "spu_name", columnDefinition = "varchar(255) comment 'spu名称'")
    private String spuName;

    @ApiModelProperty("商品SKU名称")
    @Column(name = "item_name", columnDefinition = "varchar(255) comment '商品SKU名称'")
    private String itemName;
    @ApiModelProperty("颜色")
    @Column(name = "color", columnDefinition = "varchar(255) comment '颜色'")
    private String color;

    @ApiModelProperty("商品编码")
    @Column(name = "item_code", columnDefinition = "varchar(100) comment '商品编码'")
    private String itemCode;


}
