package com.elitesland.yst.production.aftersale.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleInfoVO
 * @Date2023/2/9 14:37
 */
@Data
public class CarOwnerVehicleInfoVO implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("车架号")
    private String vehicleNo;

    @ApiModelProperty("车主姓名")
    private String userName;

    @ApiModelProperty("车主手机号")
    private String userPhone;

    @ApiModelProperty("车辆名称")
    private String vehicleName;

    @ApiModelProperty("车型")
    private String vehicleType;

    @ApiModelProperty("车辆规格")
    private String vehicleSpecs;

    @ApiModelProperty("车辆颜色")
    private String vehicleColor;

    @ApiModelProperty("生产日期")
    private LocalDateTime manufactureDate;

    @ApiModelProperty("车辆信息")
    private String vehicleInfo;

    @ApiModelProperty("车辆来源")
    @SysCode(sys = "yst-after-sale", mod = "VEHICLE_SOURCE")
    private Integer vehicleSource;
    private String vehicleSourceName;

    @ApiModelProperty("车辆车型")
    private String vehicleModel;

    @ApiModelProperty("绑定时间")
    private LocalDateTime bindingTime;

    @ApiModelProperty("电池编号")
    private String batteryNum;

    @ApiModelProperty("销售门店编码")
    private String salesOutletsCode;

    @ApiModelProperty("销售门店名称")
    private String salesOutletsName;

    @ApiModelProperty("销售门店ID")
    private Long salesOutletsId;

    @ApiModelProperty("购买日期")
    private LocalDateTime purchaseTime;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("车主身份证号")
    private String userIdCard;

    @ApiModelProperty("车主性别")
    @SysCode(sys = "yst-after-sale", mod = "SEX")
    private String userSex;
    private String userSexName;

    @ApiModelProperty("车主地区")
    private String userArea;

    @ApiModelProperty("车主生日")
    private LocalDate userBirthday;

    @ApiModelProperty("购买金额")
    private BigDecimal vehicleBuyPrice;

    @ApiModelProperty(value = "车辆图片")
    private String vehicleFileCode;

    @ApiModelProperty("三包卡号")
    private String maintainCardNo;

    @ApiModelProperty("车辆三包信息")
    private CarMaintainCardVO carMaintainCardVO;

    @ApiModelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("所属经销商")
    private String custName;

    @ApiModelProperty("所属区域")
    private String salesOutletsRegionName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("激活时间")
    private LocalDateTime activatTime;
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("业务员名称")
    private String salesmanName;

}
