package com.elitesland.yst.production.aftersale.service.impl;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserAccountDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.config.AuthorizationServiceConfiguration;
import com.elitesland.yst.production.aftersale.constant.Constant;
import com.elitesland.yst.production.aftersale.convert.OrderLogConvert;
import com.elitesland.yst.production.aftersale.convert.PictureOrderConvert;
import com.elitesland.yst.production.aftersale.convert.RepairOrderConvert;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.RepairOrderDO;
import com.elitesland.yst.production.aftersale.model.entity.RepairPartsServiceDO;
import com.elitesland.yst.production.aftersale.model.entity.orderlog.OrderLogDO;
import com.elitesland.yst.production.aftersale.model.entity.picture.PictureOrderDO;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogSaveParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderParam;
import com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceExlParam;
import com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarAndVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderLogVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.RepairPartsServiceVO;
import com.elitesland.yst.production.aftersale.model.vo.StoreVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.out.support.OrgStoreService;
import com.elitesland.yst.production.aftersale.out.support.lm.OrgStoreLmService;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.provider.sale.VinOrderRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysMsgRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import com.elitesland.yst.production.aftersale.service.RepairPartsService;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.OrderLogRepo;
import com.elitesland.yst.production.aftersale.service.repo.OrderLogRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.aftersale.service.repo.RepairOrderRepo;
import com.elitesland.yst.production.aftersale.service.repo.RepairOrderRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.RepairPartsServiceRepo;
import com.elitesland.yst.production.aftersale.service.repo.RepairPartsServiceRepoProc;
import com.elitesland.yst.production.aftersale.util.NumSendEnum;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.service.CrmCustAccountRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.yst.production.support.provider.store.dto.OrgStoreRpcDTO;
import com.google.common.collect.Maps;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
@Log4j2
@RequiredArgsConstructor
public class RepaiOrderServiceImpl implements RepairOrderService {

    private final RepairOrderRepoProc repairOrderRepoProc;

    private final RepairPartsServiceRepo repairPartsServiceRepo;

    private final RepairPartsService repairPartsService;

    private final CarOwnerVehicleService carOwnerVehicleService;

    private final CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;

    private final OrderEvaluationService orderEvaluationService;

    private final RepairPartsServiceRepoProc repairPartsServiceRepoProc;

    private final RepairOrderRepo repairOrderRepo;

    private final PictureOrderRepo pictureOrderRepo;

    private final UserService userService;


    private final SystemService systemService;

    private final PictureOrderService pictureOrderService;

    private final OrderLogRepo orderLogRepo;

    private final OrderLogRepoProc orderLogRepoProc;

    private final CarOwnerInfoRepo carOwnerInfoRepo;

    private final OrgStoreService orgStoreService;

    private final SysUdcProxyService sysUdcProxyService;

    private Constant constant;

    private final CrmSaleService crmSaleService;
    private final OrgStoreLmService orgStoreLmService;

    private final MaintainCardService maintainCardService;

    private final CrmCustAccountRpcService crmCustAccountRpcService;

    private final SysMsgRpcProvider sysMsgRpcProvider;

    private final AuthorizationServiceConfiguration authorizationServiceConfiguration;

    private final OrgStoreRpcService orgStoreRpcService;

    private final VinOrderRpcProvider vinOrderRpcProvider;

    @Value("${file.upload.url}")
    private String pictureURL;

    //工单日志操作内容
    private static final String COMPLETE = "完成";
    private static final String PLAC_EORDER = "下单";
    ;
    private static final String DISPATCH = "开始维修";
    private static final String CANCEL_EORDER = "取消";

    @Override
    @SysCodeProc
    public PagingVO<RepairOrderVO> query(RepairOrderExlParam queryDTO) {
        //查询维修工单信息
        PagingVO<RepairOrderVO> repairOrderVOS = repairOrderRepoProc.query(queryDTO);
        //根据车架号查询车主车辆信息表
        this.vehicleQuery(repairOrderVOS.getRecords());
        //门店查询
        this.storeQuery(repairOrderVOS.getRecords());
        //图片信息查询
        this.pictoreQuery(repairOrderVOS.getRecords());
        //udc手动翻译
        this.udcTranslate(repairOrderVOS.getRecords());
        return repairOrderVOS;
    }

    /**
     * 经销商pc端专用分页查询
     *
     * @param queryDTO
     * @return
     */
    @Override
    public PagingVO<RepairOrderVO> pcQuery(RepairOrderExlParam queryDTO) {
        //1.查询当前登录人所属门店，入参门店集合与所属门店集合去重，集合空直接返回，集合不为空查询数据
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.repairStoreQuery();
        List<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());

        queryDTO.setRepairStoreIdS(collect);
        if (CollectionUtils.isEmpty(queryDTO.getRepairStoreIdS())) {
            return PagingVO.<RepairOrderVO>builder()
                    .total(0)
                    .records(new ArrayList<>())
                    .build();
        }
        //2.数据查询
        return query(queryDTO);
    }

    /**
     * 经销商pc端专用分页查询
     *
     * @param queryDTO
     * @return
     */
    @Override
    public PagingVO<RepairOrderVO> bcPcQuery(RepairOrderExlParam queryDTO) {
        //1.查询当前登录人所属门店，入参门店集合与所属门店集合去重，集合空直接返回，集合不为空查询数据
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.bcRepairStoreQuery();
        List<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());

        queryDTO.setRepairStoreIdS(collect);
        if (CollectionUtils.isEmpty(queryDTO.getRepairStoreIdS())) {
            return PagingVO.<RepairOrderVO>builder()
                    .total(0)
                    .records(new ArrayList<>())
                    .build();
        }
        //2.数据查询
        return query(queryDTO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(RepairOrderParam saveVO, String source) {

        log.info("维修工单保存入参:" + JSON.toJSONString(saveVO));
        String orderNo = null;
        Long aLong = null;

        //1.必填字段校验
        this.check(saveVO);
        //查询门店信息
        this.queryStore(saveVO);
        //查询车主信息
        this.queryCarOwnerInfo(saveVO);

        //2.有id修改，没有id新增(修改时图片工单需要全删全插)
        if (saveVO.getId() != null && saveVO.getId() != 0) {
            pictureOrderRepo.deleteByOrderId(saveVO.getId());
        } else {
            //保存车辆信息之前查询此车辆是否绑定过
            aLong = this.checkBindVehicle(saveVO, source);
            //发号器发号
            orderNo = systemService.sysNumberRuleGenerateCode(NumSendEnum.LMW.getCode(), new ArrayList<>());
            log.info("维修工单发号：" + JSON.toJSONString(orderNo));
        }

        //3.工单保存
        saveVO.setOrderNo(orderNo == null ? saveVO.getOrderNo() : orderNo);
        saveVO.setPersonalVehicelId(aLong == null ? saveVO.getPersonalVehicelId() : aLong);
        saveVO.setOrderStatus(UdcEnum.REPAIR_ORDER_JSS001.getValueCode());
        saveVO.setRepairMode("1");
        RepairOrderDO repairOrderDO = RepairOrderConvert.INSTANCE.saveVoTODO(saveVO);
        Long id = repairOrderRepo.save(repairOrderDO).getId();

        //4.图片集合调用图片工单service进行保存
        List<PictureOrderParam> pictureOrderParamList = saveVO.getPictureOrderParamList();
        if (!CollectionUtils.isEmpty(pictureOrderParamList)) {
            List<PictureOrderDO> collect = pictureOrderParamList.stream().map(t -> {
                PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO(t);
                pictureOrderDO.setOrderId(id);
                pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_1.getValueCode());
                return pictureOrderDO;
            }).collect(Collectors.toList());
            pictureOrderRepo.saveAll(collect);
        }

        //5.保存记录工单日志/修改不记录
        this.saveOrderLog(saveVO, id, source, PLAC_EORDER);

        if (null == saveVO.getId() || 0 == saveVO.getId()) {
            saveVO.setId(id);
            sendCreateMsg(saveVO);
        }

        return id;
    }

    /**
     * 操作日志记录规则：
     * 1 小程序下单时，操作账号：小程序车主登录手机号，备注信息：车主（{xxxx}）自主下单。
     * 2 经销商代客下单时，操作账号：经销商登录账号，备注信息：经销商&门店（{xx经销商}）代客({xx会员})下单。
     * 注释:"{}"此格式的为占位符，需要填充对应的变量。
     *
     * @param saveVO
     * @param id
     * @param source
     */
    private void saveOrderLog(RepairOrderParam saveVO, Long id, String source, String status) {
        if (saveVO.getId() != null && saveVO.getId() != 0) {
            return;
        }
        SysUserDTO user = userService.getUserDetail();
        String operationUser = null;
        log.info("当前登录用户信息：" + JSON.toJSONString(user));
        String remark = null;
        switch (source) {
            case "PC":
                remark = "经销商（" + user.getPrettyName() + ")代客（" + saveVO.getOrderPerson() + ")" + status;
                operationUser = user.getUsername();
                break;
            case "APP":
                remark = "经销商（" + user.getPrettyName() + ")代客（" + saveVO.getOrderPerson() + ")" + status;
                operationUser = user.getUsername();
                break;
            case "MINIAPP":
                remark = "车主（" + user.getUsername() + ")" + status;
                operationUser = user.getMobile();
                break;
            default:
                throw new BusinessException("数据来源异常");
        }
        this.orderLogAdd(id, UdcEnum.ORDER_TYPE_1.getValueCode(), status, operationUser, saveVO.getCreateUserId(), remark);

    }

    /**
     * 查询车主信息
     *
     * @param saveVO
     */
    private void queryCarOwnerInfo(RepairOrderParam saveVO) {
        //查询车主信息（手机号唯一）
        CarOwnerInfoDO carOwnerInfoDO = carOwnerInfoRepo.findByUserPhone(saveVO.getOrderTel());
        if (Optional.ofNullable(carOwnerInfoDO).isEmpty()) {
            throw new BusinessException("未查询到相关车主信息");
        }
        saveVO.setPersonalId(carOwnerInfoDO.getCarOwnerId());
        saveVO.setCasUserId(carOwnerInfoDO.getCasUserId());
    }

    /**
     * 查询门店信息
     *
     * @param saveVO
     */
    private void queryStore(RepairOrderParam saveVO) {
        if (saveVO.getRepairStoreId() == 0 || saveVO.getRepairStoreId() == null) {
            return;
        }
        //查询门店信息
        OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreService.orgStoreGet(saveVO.getRepairStoreId());
        if (Optional.ofNullable(orgStoreDetailRpcDTO).isEmpty()) {
            throw new BusinessException("未查询到相关门店信息");
        }
        saveVO.setRepairStoreName(saveVO.getRepairStoreName() == null ? orgStoreDetailRpcDTO.getStoreName() : saveVO.getRepairStoreName());
        saveVO.setRepairStoreCode(saveVO.getRepairStoreCode() == null ? orgStoreDetailRpcDTO.getStoreCode() : saveVO.getRepairStoreCode());
        saveVO.setSalesman(orgStoreDetailRpcDTO.getStoreManager());
        //todo 现在没有业务员id，暂时为null
        saveVO.setSalesmanId(null);
    }

    @Override
    public ApiResult<Long> repairOrderCancel(com.elitesland.yst.production.aftersale.model.param.RepairOrderParam saveVO) {
        if (!StringUtils.isEmpty(saveVO.getOrderStatus())
                && !UdcEnum.REPAIR_ORDER_JSS001.getValueCode().equals(saveVO.getOrderStatus())
                && !UdcEnum.REPAIR_ORDER_JSS002.getValueCode().equals(saveVO.getOrderStatus())) {
            throw new BusinessException("维修状态异常");
        }
        if (saveVO.getId() == null || saveVO.getId() == 0) {
            throw new BusinessException("工单id不能为空");
        }
        //1.默认工单状态为”已取消“
        repairOrderRepoProc.cancel(saveVO);

        //2.保存工单日志
        String content = "取消原因：";
        if (null != saveVO.getCancelReasonC()) {
            content = content + systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_C_1.getModel(), UdcEnum.CANCEL_REASON_C_1.getCode()).get(saveVO.getCancelReasonC());
        } else if (null != saveVO.getCancelReasonB()) {
            content = content + systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_B_1.getModel(), UdcEnum.CANCEL_REASON_B_1.getCode()).get(saveVO.getCancelReasonB());
        }

        if (null != saveVO.getCancelRemark()) {
            content = content + " 详细信息：" + saveVO.getCancelRemark();
        }
        //3.保存工单日志
        this.saveOrderLog(saveVO, saveVO.getId(), "PC", CANCEL_EORDER);

        sendMsg(saveVO, "WXC0005");

        return ApiResult.ok(saveVO.getId());
    }

    @Override
    @SysCodeProc
    public RepairOrderVO detail(RepairOrderExlParam param) {
        //查询维修工单信息
        List<RepairOrderVO> repairOrderVOS = repairOrderRepoProc.detail(param);
        if (CollectionUtils.isEmpty(repairOrderVOS)) {
            throw new BusinessException("数据不存在，请检查入参");
        }
        //根据车架号查询车辆
        this.vehicleQuery(repairOrderVOS);
        //门店查询
        this.storeQuery(repairOrderVOS);
        //图片信息查询
        this.pictoreQuery(repairOrderVOS);
        //配件查询
        this.partsQuery(repairOrderVOS);
        //工单评价查询
        this.orderEcaluationQuery(repairOrderVOS);
        //工单日志查询
        this.orderLogQuery(repairOrderVOS);
        //udc手动翻译
        this.udcTranslate(repairOrderVOS);
        return repairOrderVOS.get(0);
    }

    @Override
    public ApiResult repairOrderDelete(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new BusinessException("维修工单id不能为空");
        }
        repairOrderRepoProc.deleteList(idList);
        return ApiResult.ok();
    }

    /**
     * pc端导出
     *
     * @param param
     */
    @Override
    public PagingVO<RepairOrderVO> export(RepairOrderExlParam param) {
        PagingVO<RepairOrderVO> page = this.query(param);

        if (CollectionUtils.isEmpty(page.getRecords())) {
            return page;
        }

        List<Long> idList = page.getRecords().stream().map(RepairOrderVO::getId).collect(Collectors.toList());
        RepairPartsServiceExlParam repairPartsServiceExlParam = new RepairPartsServiceExlParam();
        repairPartsServiceExlParam.setRepairIdList(idList);
        List<RepairPartsServiceVO> repairPartsServiceVOS = repairPartsServiceRepoProc.query(repairPartsServiceExlParam);
        fillVehicleVoType(page.getRecords());
        List<RepairOrderVO> repairOrderVOS = new ArrayList<>();

        Map<String, String> ajStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.PARTS_SERVICE_TYPE_1.getModel(), UdcEnum.PARTS_SERVICE_TYPE_1.getCode());
        page.getRecords().forEach(item -> {
            List<RepairPartsServiceVO> patVo = repairPartsServiceVOS.stream().filter(x -> x.getRepairId().equals(item.getId())).collect(Collectors.toList());
            if (!patVo.isEmpty()) {
                patVo.forEach(s -> {
                    RepairOrderVO repairOrderVO = new RepairOrderVO();
                    BeanUtils.copyProperties(item, repairOrderVO);
                    repairOrderVO.setRepairPartName(s.getPartsName());
                    if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(s.getServiceType())) {
                        repairOrderVO.setRepairPartType(ajStatusMap.get(s.getServiceType()));
                    }

                    repairOrderVO.setPartsPrice(s.getPartsPrice());
                    repairOrderVO.setServicePrice(s.getServicePrice());
                    repairOrderVOS.add(repairOrderVO);
                });
            } else {
                repairOrderVOS.add(item);
            }
        });

        PagingVO<RepairOrderVO> repairPage = new PagingVO<>();
        repairPage.setRecords(repairOrderVOS);
        repairPage.setTotal(repairOrderVOS.size());
        return repairPage;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long confirm(RepairOrderParam saveVO) {
        //1.先检查单据状态---只有单据状态为维修中可以点击确认完成
        if (!StringUtils.isEmpty(saveVO.getOrderStatus())
                && !UdcEnum.REPAIR_ORDER_JSS002.getValueCode().equals(saveVO.getOrderStatus())) {
            throw new BusinessException("订单维修状态异常");
        }

        //2.保存维修工单信息，修改维修单据状态为已完成
        this.startCheck(saveVO);
        repairOrderRepoProc.updateStatus(saveVO.getId(), UdcEnum.REPAIR_ORDER_JSS003.getValueCode(), saveVO.getRepairRemark());


        //3.1查询当前订单是否有配件记录，有即删除; 3.2保存配件服务信息
        List<RepairPartsServiceDO> repairPartsServiceDOS = repairPartsServiceRepo.findByRepairId(saveVO.getId());
        if (!CollectionUtils.isEmpty(repairPartsServiceDOS)) {
            repairPartsServiceRepo.deleteByRepairId(saveVO.getId());
        }
        List<RepairPartsServiceParam> partsServiceSaveVO = saveVO.getPartsServiceSaveVO();
        if (!CollectionUtils.isEmpty(partsServiceSaveVO)) {
            partsServiceSaveVO.stream().forEach(t -> {
                t.setId(null);
                t.setRepairId(saveVO.getId());
            });
            repairPartsService.saveList(partsServiceSaveVO);
        }

        //4.保存工单日志
        this.saveOrderLog(saveVO, saveVO.getId(), "PC", COMPLETE);

        sendMsg(saveVO, "WXC0006");

        return saveVO.getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long start(RepairOrderParam saveVO) {
        //1.先检查单据状态---只有单据状态为维修中可以点击确认完成
        if (!StringUtils.isEmpty(saveVO.getOrderStatus())
                && !UdcEnum.REPAIR_ORDER_JSS001.getValueCode().equals(saveVO.getOrderStatus())) {
            throw new BusinessException("只有待维修单据可以点击开始");
        }
        //2.检查必填字段，修改维修单据状态为维修中,保存维修工单信息，
        this.startCheck(saveVO);
        repairOrderRepoProc.updateStatus(saveVO.getId(), UdcEnum.REPAIR_ORDER_JSS002.getValueCode(), saveVO.getRepairRemark());
        //3.保存配件服务信息
        List<RepairPartsServiceParam> partsServiceSaveVO = saveVO.getPartsServiceSaveVO();
        if (!CollectionUtils.isEmpty(partsServiceSaveVO)) {
            partsServiceSaveVO.stream().forEach(t -> {
                t.setId(null);
                t.setRepairId(saveVO.getId());
            });
            repairPartsService.saveList(partsServiceSaveVO);
        }

        //4.保存工单日志
        this.saveOrderLog(saveVO, saveVO.getId(), "PC", DISPATCH);

        sendMsg(saveVO, "WXC0004");

        return saveVO.getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long supply(RepairOrderParam saveVO) {
        log.info("维修工单信息补充入参：" + JSON.toJSONString(saveVO));
        //1.先检查单据状态---只有单据状态为维修中可以点击确认完成
        if (!StringUtils.isEmpty(saveVO.getOrderStatus())
                && !UdcEnum.REPAIR_ORDER_JSS002.getValueCode().equals(saveVO.getOrderStatus())) {
            throw new BusinessException("只有维修中单据可以信息补充");
        }
        //2.保存维修工单信息,不修改维修单据状态
        this.startCheck(saveVO);
        repairOrderRepoProc.updateSupplyStatus(saveVO.getId(), saveVO.getRepairRemark());

        //3.1查询当前订单是否有配件记录，有即删除;  保存配件服务信息
        List<RepairPartsServiceDO> repairPartsServiceDOS = repairPartsServiceRepo.findByRepairId(saveVO.getId());
        if (!CollectionUtils.isEmpty(repairPartsServiceDOS)) {
            repairPartsServiceRepo.deleteByRepairId(saveVO.getId());
        }
        List<RepairPartsServiceParam> partsServiceSaveVO = saveVO.getPartsServiceSaveVO();
        if (!CollectionUtils.isEmpty(partsServiceSaveVO)) {
            partsServiceSaveVO.stream().forEach(t -> {
                t.setId(null);
                t.setRepairId(saveVO.getId());
            });
            repairPartsService.saveList(partsServiceSaveVO);
        }
        return saveVO.getId();
    }

    /**
     * 根据当前登录人查询经销商所属的门店信息
     */
    @Override
    public List<OrgStoreRpcDTO> repairStoreQuery() {
        SysUserDTO user = userService.getUserDetail();
        log.info("当前登录用户信息：" + JSON.toJSONString(user));
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = new ArrayList<>();

        // 1.根据当前登陆人查询经销商所属公司信息
        CrmCustSimpleVO custSimple = crmSaleService.getCustSimple(user.getId());
        if (Optional.ofNullable(custSimple).isEmpty()) {
            orgStoreRpcDTOS.add(this.filterStore(user.getUsername()));
            return orgStoreRpcDTOS;
        }
        if (StringUtils.isEmpty(custSimple.getCorOu())) {
            throw new BusinessException("未查询到当前登录人对应公司，请手动添加对应公司");
        }
        // 2.根据经销商所属公司信息查询门店信息
        log.info("经销商所属公司信息：" + JSON.toJSONString(custSimple));
        orgStoreRpcDTOS = orgStoreLmService.orgStoreGet(custSimple.getCorOu());
        if (CollectionUtils.isEmpty(orgStoreRpcDTOS)) {
            return orgStoreRpcDTOS;
        }

        log.info("经销商所属门店信息：" + JSON.toJSONString(orgStoreRpcDTOS));
        return orgStoreRpcDTOS;
    }

    /**
     * 根据当前登录人查询经销商所属的门店信息
     */
    @Override
    public List<OrgStoreRpcDTO> bcRepairStoreQuery() {
        SysUserDTO user = userService.getUserDetail();
        log.info("当前登录用户信息：" + JSON.toJSONString(user));
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = new ArrayList<>();

        //1.根据当前登陆人查询经销商所属公司信息
        CrmCustSimpleVO custSimple = crmSaleService.bcGetCustSimple(user.getUsername());
        if (Optional.ofNullable(custSimple).isEmpty()) {
            orgStoreRpcDTOS.add(this.filterStore(user.getUsername()));
            return orgStoreRpcDTOS;
        }
        if (StringUtils.isEmpty(custSimple.getCorOu())) {
            throw new BusinessException("未查询到当前登录人对应公司");
        }
        //2.根据经销商所属公司信息查询门店信息
        log.info("经销商所属公司信息：" + JSON.toJSONString(custSimple));
        orgStoreRpcDTOS = orgStoreLmService.orgStoreGet(custSimple.getCorOu());
        if (CollectionUtils.isEmpty(orgStoreRpcDTOS)) {
            return orgStoreRpcDTOS;
        }

        log.info("经销商所属门店信息：" + JSON.toJSONString(orgStoreRpcDTOS));
        return orgStoreRpcDTOS;
    }

    /**
     * 根据门店编码查询门店
     */
    public OrgStoreRpcDTO filterStore(String userName) {
        OrgStoreDetailRpcDTO byCode = orgStoreService.getByCode(userName);
        if (!Optional.ofNullable(byCode).isEmpty()) {
            OrgStoreRpcDTO orgStoreRpcDTO = new OrgStoreRpcDTO();
            BeanCopyUtil.beanCopy(byCode, orgStoreRpcDTO);
            return orgStoreRpcDTO;
        } else {
            throw new BusinessException("未查询到当前登录账号门店信息");
        }

    }

    /**
     * 维修车辆、目标门店、联系电话、问题描述、问题图片为必填项，为空时提示对应字段不能为空
     *
     * @param saveVO
     */
    public void check(RepairOrderParam saveVO) {
        log.info("维修工单提交入参", JSON.toJSONString(saveVO));

        if (saveVO.getOrderTel() == null) {
            throw new BusinessException("联系电话为空，请检查！");
        }
        if (saveVO.getQuestionRemark() == null) {
            throw new BusinessException("问题描述为空，请检查！");
        }
        if (saveVO.getCreator() == null) {
            throw new BusinessException("创建人为空，请检查！");
        }
        if (saveVO.getCreateUserId() == null || saveVO.getCreateUserId() == 0) {
            throw new BusinessException("创建人id为空，请检查！");
        }
        if (saveVO.getVehicleSource() == null) {
            throw new BusinessException("车辆来源信息不能为空，请检查！");
        }
        if (saveVO.getRepairStoreId() == null || saveVO.getRepairStoreId() == 0) {
            throw new BusinessException("门店id为空，请检查！");
        }
    }

    /**
     * 开始维修入参检查
     *
     * @param saveVO
     */
    public void startCheck(RepairOrderParam saveVO) {
        log.info("维修工单开始维修入参", JSON.toJSONString(saveVO));

        if (saveVO.getId() == null || saveVO.getId() == 0) {
            throw new BusinessException("工单id不能为空");
        }
        if (!CollectionUtils.isEmpty(saveVO.getPartsServiceSaveVO())) {
            saveVO.getPartsServiceSaveVO().forEach(t -> {
                if (StringUtils.isEmpty(t.getServiceType())) {
                    throw new BusinessException("服务类型不能为空");
                }
            });
        }
        if (StringUtils.isEmpty(saveVO.getCreator())) {
            throw new BusinessException("创建人不能为空");
        }
        if (saveVO.getCreateUserId() == null || saveVO.getCreateUserId() == 0) {
            throw new BusinessException("创建人Id不能为空");
        }
    }

    public void vehicleQuery(List<RepairOrderVO> repairOrderVOS) {
        //车辆来源为立马车辆查询
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getPersonalVehicelId() != null && t.getPersonalVehicelId() != 0).map(RepairOrderVO::getPersonalVehicelId).collect(Collectors.toList());

        BindSoldVehicleParam bindSoldVehicleParam = new BindSoldVehicleParam();
        bindSoldVehicleParam.setIdList(collect);
        List<BindSoldVehicleVO> records = carOwnerVehicleRepoProc.bindSoldVehicleQuery(bindSoldVehicleParam).getRecords();


        //对应车辆信息赋值
        repairOrderVOS.stream().forEach(t -> {
            Optional<BindSoldVehicleVO> first = records.stream().filter(vehicle -> (vehicle.getId() != null) && (vehicle.getId().equals(t.getPersonalVehicelId()))).findFirst();
            if (first.isPresent()) {
                t.setBindSoldVehicleVO(first.get());
            }

        });
    }

    public void fillVehicleVoType(List<RepairOrderVO> repairOrderVOS) {
        //车辆来源为立马车辆查询
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getPersonalVehicelId() != null && t.getPersonalVehicelId() != 0).map(RepairOrderVO::getPersonalVehicelId).collect(Collectors.toList());

        BindSoldVehicleParam bindSoldVehicleParam = new BindSoldVehicleParam();
        bindSoldVehicleParam.setIdList(collect);
        List<BindSoldVehicleVO> records = carOwnerVehicleRepoProc.bindSoldVehicleQuery(bindSoldVehicleParam).getRecords();


        //对应车辆信息赋值
        repairOrderVOS.stream().forEach(t -> {
            Optional<BindSoldVehicleVO> first = records.stream().filter(vehicle -> (vehicle.getId() != null) && (vehicle.getId().equals(t.getPersonalVehicelId()))).findFirst();
            if (first.isPresent()) {
                t.setVehicleType(first.get().getVehicleType());
            }

        });
    }

    public void storeQuery(List<RepairOrderVO> repairOrderVOS) {

        //对应门店信息赋值
        repairOrderVOS.stream().forEach(t -> {
            StoreVO storeVO = new StoreVO();
            storeVO.setStoreCode(t.getRepairStoreCode());
            storeVO.setStoreName(t.getRepairStoreName());
            storeVO.setId(t.getRepairStoreId());
            t.setStoreVO(storeVO);
        });
    }

    /**
     * 工单日志
     *
     * @param repairOrderVOS
     */
    public void orderLogQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0).map(RepairOrderVO::getId).collect(Collectors.toList());
        OrderLogPageParam orderLogPageParam = new OrderLogPageParam();
        orderLogPageParam.setOrderIdList(collect);
        orderLogPageParam.setOrderType(UdcEnum.ORDER_TYPE_1.getValueCode());
        List<OrderLogVO> orderLogVOS = orderLogRepoProc.query(orderLogPageParam);
        //工单日志信息赋值
        repairOrderVOS.stream().forEach(t -> {
            List<OrderLogVO> orderLogVOList = orderLogVOS.stream().filter(pic -> pic.getOrderId().equals(t.getId())).collect(Collectors.toList());
            t.setOrderLogVOS(orderLogVOList);
        });
    }

    public void pictoreQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0).map(RepairOrderVO::getId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(collect);
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_1.getValueCode());
        List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();

        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
        }
        if (!CollectionUtils.isEmpty(data)) {
            //对应图片信息赋值
            repairOrderVOS.stream().forEach(t -> {
                List<PictureOrderVO> respVOList = data.stream().filter(pic -> pic.getOrderId().equals(t.getId())).collect(Collectors.toList());
                t.setPictureOrderVOS(respVOList);
            });
        }
    }

    /**
     * 配件查询
     *
     * @param repairOrderVOS
     */
    @SysCodeProc
    public void partsQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0).map(RepairOrderVO::getId).collect(Collectors.toList());
        RepairPartsServiceExlParam pictureOrderQueryVO = new RepairPartsServiceExlParam();
        pictureOrderQueryVO.setRepairIdList(collect);
        List<RepairPartsServiceVO> query = repairPartsServiceRepoProc.query(pictureOrderQueryVO);
        //udc翻译
        sysUdcProxyService.translate(query);
        //对应配件信息赋值
        repairOrderVOS.stream().forEach(t -> {
            List<RepairPartsServiceVO> respVOList = query.stream().filter(pic -> pic.getRepairId().equals(t.getId())).collect(Collectors.toList());
            t.setRepairPartsServiceVOS(respVOList);
        });
    }

    /**
     * 查询评价工单
     *
     * @param repairOrderVOS
     */
    public void orderEcaluationQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0).map(RepairOrderVO::getId).collect(Collectors.toList());
        OrderEvaluationParam orderEvaluationParam = new OrderEvaluationParam();
        orderEvaluationParam.setOrderIdList(collect);
        orderEvaluationParam.setOrderType("1");
        List<OrderEvaluationVO> records = orderEvaluationService.queryList(orderEvaluationParam);

        //查询评价图片
        this.evaluationPic(records);
        //对应评价工单赋值
        repairOrderVOS.stream().forEach(t -> {
            Optional<OrderEvaluationVO> first = records.stream().filter(order -> order.getOrderId().equals(t.getId())).findFirst();
            if (first.isPresent()) {
                t.setOrderEvaluationVO(first.get());
            }
        });
    }

    public void evaluationPic(List<OrderEvaluationVO> records) {
        List<Long> idList = records.stream().filter(t -> t.getOrderId() != null && t.getOrderId() != 0).map(OrderEvaluationVO::getOrderId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(idList);
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_3.getValueCode());
        List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();

        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
        }

        if (!CollectionUtils.isEmpty(data)) {
            //对应图片信息赋值
            records.stream().forEach(t -> {
                List<PictureOrderVO> respVOList = data.stream().filter(pic -> pic.getOrderId().equals(t.getOrderId())).collect(Collectors.toList());
                t.setPictureOrderVOS(respVOList);
            });
        }
    }

    /**
     * UDC翻译
     *
     * @param repairOrderVOS
     */
    public void udcTranslate(List<RepairOrderVO> repairOrderVOS) {
        Map<String, String> ajStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.REPAIR_ORDER_JSS001.getModel(), UdcEnum.REPAIR_ORDER_JSS001.getCode());
        repairOrderVOS.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(t.getOrderStatus())) {
                t.setOrderStatusName(ajStatusMap.get(t.getOrderStatus()));
            }
            if (t.getRepairMode() != null && "1".equals(t.getRepairMode())) {
                t.setRepairModeName("到店维修");
            }
        });
    }

    /**
     * 添加工单日志
     *
     * @param id               工单id
     * @param orderType        工单类型
     * @param operationContent 操作内容
     * @param operationUser    发起者账号
     * @param operationUserId  发起者账号id
     * @param remark           备注
     */
    public void orderLogAdd(Long id, String orderType, String operationContent, String operationUser, Long operationUserId, String remark) {
        OrderLogSaveParam orderLogSaveParam = new OrderLogSaveParam(id, orderType, operationContent, LocalDateTime.now(), operationUser, operationUserId);
        orderLogSaveParam.setRemark(remark);
        OrderLogDO orderLogDO = OrderLogConvert.INSTANCE.saveVoTODO(orderLogSaveParam);
        orderLogRepo.save(orderLogDO);
    }


    /**
     * 查询此车辆是否已经被其他车主绑定，否则无法维修
     *
     * @param saveVO
     */
    @Transactional(rollbackFor = Exception.class)
    public Long checkBindVehicle(RepairOrderParam saveVO, String source) {

        Long data = null;
        log.info("车辆绑定校验：" + JSON.toJSONString(saveVO));

        if (null == saveVO.getPersonalVehicelId()) {
            throw new BusinessException("PersonalVehicelId 不能为空");
        }

        // 立马车辆绑定校验
        if (saveVO.getVehicleSource().equals(1)) {

            //绑车
            CarAndVehicleVO byVehicleNo = carOwnerVehicleRepoProc.findByVehicleNo(saveVO.getVehicleNo(), saveVO.getOrderTel());
            log.info("车架号数据查询返回：" + JSON.toJSONString(byVehicleNo));
            if (null == byVehicleNo) {
                throw new BusinessException("该用户没有绑定该车辆，请先进行车辆绑定");
            }
            return byVehicleNo.getId();

//            //数据空说明车辆没有绑定过,需要重新绑定和激活三包信息
//            if (CollectionUtils.isEmpty(byVehicleNo)) {
//                // 0712 需求新增 如果是小程序 新建维修工单自动激活三包
//                if ("MINIAPP".equals(source)) {
//                    this.vehicleActivate(saveVO);
//                }
//                data = this.saveVehicle(saveVO);
//
//            } else {
//
//                //查询到需要判断是否是当前登录用户所绑定的车辆，如果是，继续流程，否，直接错误提示
//                if (!CollectionUtils.isEmpty(byVehicleNo) && saveVO.getCasUserId().equals(byVehicleNo.get(0).getCasUserId())) {
//                    data = byVehicleNo.get(0).getId();
//                } else {
//                    throw new BusinessException("该车辆已绑定，无法再次绑定！");
//                }
//            }
        }
        if (saveVO.getVehicleSource().equals(0)) {
            data = saveVO.getPersonalVehicelId();
            //绑过的非立马车辆不再绑定
//            if (saveVO.getPersonalVehicelId() == null || saveVO.getPersonalVehicelId() == 0) {
//                data = this.saveVehicle(saveVO);
//            } else {
//                data = saveVO.getPersonalVehicelId();
//            }
        }

        return data;
    }

    /**
     * 保存车主车辆信息
     *
     * @param saveVO
     * @return
     */
    public Long saveVehicle(RepairOrderParam saveVO,String sourcePlatform) {
        CarOwnerVehicleParam carOwnerVehicleParam = new CarOwnerVehicleParam();
        carOwnerVehicleParam.setVehicleNo(saveVO.getVehicleNo());
        carOwnerVehicleParam.setBindingTime(LocalDateTime.now().toString());
        carOwnerVehicleParam.setVehicleSource(saveVO.getVehicleSource());
        carOwnerVehicleParam.setVehicleType(saveVO.getVehicleType());
        carOwnerVehicleParam.setUserName(saveVO.getOrderPerson());
        carOwnerVehicleParam.setUserPhone(saveVO.getOrderTel());
        carOwnerVehicleParam.setBrandName(saveVO.getBrandName());
        carOwnerVehicleParam.setPurchaseTime(saveVO.getPurchaseTime());
        carOwnerVehicleParam.setMaintainCardNo(saveVO.getMaintainCardNo());
        carOwnerVehicleParam.setActivityNum(saveVO.getActivityNum());
        carOwnerVehicleParam.setVehicleSpecs(saveVO.getVehicleSpecs());
        carOwnerVehicleParam.setVehicleColor(saveVO.getVehicleColor());
        carOwnerVehicleParam.setSalesOutletsId(saveVO.getRepairStoreId());
        log.info("保存接口调用绑定车辆入参：", JSON.toJSONString(carOwnerVehicleParam));
        Long data = carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam,sourcePlatform).getData();
        return data;
    }

    /**
     * 激活三包信息
     *
     * @param saveVO
     * @return
     */
    public void vehicleActivate(RepairOrderParam saveVO) {

        log.info("vehicleActivate激活三包信息：" + saveVO);
        CarMaintainCardParam carMaintainCardParam = new CarMaintainCardParam();
        carMaintainCardParam.setVehicleNo(saveVO.getVehicleNo());
        carMaintainCardParam.setCarOwnerId(saveVO.getPersonalId());
        carMaintainCardParam.setPurchaseTime(saveVO.getPurchaseTime() == null ? null : (saveVO.getPurchaseTime()));
        carMaintainCardParam.setProductionDate(saveVO.getManufactureDate() == null ? null : saveVO.getManufactureDate().toLocalDate());
        maintainCardService.activate(carMaintainCardParam);

    }

    private void sendMsg(RepairOrderParam saveVO, String templateCode) {
        try {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            dto.setTemplateCode(templateCode);
            HashMap<String, String> objectObjectHashMap = new HashMap<>();
            objectObjectHashMap.put("msgType", "c_repair_order_detail");
            objectObjectHashMap.put("orderNo", saveVO.getOrderNo());
            objectObjectHashMap.put("orderId", saveVO.getId().toString());
            dto.setMesJoinParamMap(objectObjectHashMap);

            String receiveUser = "";
            UserTransferHelper userTransferHelper = UserTransferHelper.getInstance(authorizationServiceConfiguration.getAuthServer());
            var result = userTransferHelper.getUserByMobile(saveVO.getOrderTel());
            if (null != result) {
                receiveUser = result.getData().getUsername();
            }
            Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<>();
            map3.put(MsgSendTypeEnum.SYS_INTERIOR,
                    TemplateAssignRecipientUserAccountDTO.builder().account(receiveUser).build());
            List<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<>();
            TemplateAssignRecipientUserDTO custRecipient = TemplateAssignRecipientUserDTO.builder()
                    .recipientUserAccountDtoMap(map3)
                    .userName(saveVO.getOrderPerson())
                    .build();
            recipientUserList.add(custRecipient);


            Map<String, String> interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", saveVO.getOrderNo());

            sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void sendCreateMsg(RepairOrderParam saveVO) {
        try {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            dto.setTemplateCode("WXB0004");
            HashMap<String, String> objectObjectHashMap = new HashMap<>();
            objectObjectHashMap.put("msgType", "b_repair_order_list");
            objectObjectHashMap.put("orderNo", saveVO.getOrderNo());
            objectObjectHashMap.put("orderId", saveVO.getId().toString());
            dto.setMesJoinParamMap(objectObjectHashMap);

            List<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<>();

            Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map = new HashMap<>();
            map.put(MsgSendTypeEnum.SYS_INTERIOR,
                    TemplateAssignRecipientUserAccountDTO.builder().account(saveVO.getRepairStoreCode()).build());
            TemplateAssignRecipientUserDTO recipient = TemplateAssignRecipientUserDTO.builder()
                    .recipientUserAccountDtoMap(map)
                    .userName(saveVO.getRepairStoreName())
                    .build();
            recipientUserList.add(recipient);


            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreRpcService.getByCode(saveVO.getRepairStoreCode());
            if (null != orgStoreDetailRpcDTO) {
                List<String> codes = new ArrayList<>();
                codes.add(orgStoreDetailRpcDTO.getOuCode());
                List<CustAccountVO> custAccountVOS = crmCustAccountRpcService.getCustAccountBycustCode(codes);
                if (!custAccountVOS.isEmpty()) {
                    CustAccountVO custAccountVO = custAccountVOS.get(0);
                    // 接收人
                    Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<>();
                    map3.put(MsgSendTypeEnum.SYS_INTERIOR,
                            TemplateAssignRecipientUserAccountDTO.builder().account(custAccountVO.getMobile()).build());
                    TemplateAssignRecipientUserDTO recipient3 = TemplateAssignRecipientUserDTO.builder()
                            .recipientUserAccountDtoMap(map3)
                            .userName(custAccountVO.getUserName())
                            .build();
                    recipientUserList.add(recipient3);
                }
            }

            Map<String, String> interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", saveVO.getOrderNo());

            sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void receiveTimeOut() {
        log.info("开始维修工单接单超时定时任务");

        int current = 1;
        RepairOrderExlParam param = new RepairOrderExlParam();
        param.setCurrent(current);
        param.setSize(1000);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        List<OrderItem> itemList = new ArrayList<>();
        itemList.add(orderItem);
        param.setOrders(itemList);
        LocalDateTime time = LocalDateTime.now().minusHours(12);
        param.setCreateTimeTo(time);
        param.setOrderStatus(UdcEnum.REPAIR_ORDER_JSS001.getValueCode());

        PagingVO<RepairOrderVO> repairOrderVOS = repairOrderRepoProc.query(param);
        Map<String, String> codeMap = new HashMap<>();

        while (!CollectionUtils.isEmpty(repairOrderVOS.getRecords())) {
            repairOrderVOS.getRecords().forEach(x -> {
                try {
                    if (!codeMap.containsKey(x.getRepairStoreCode())) {
                        codeMap.put(x.getRepairStoreCode(), x.getRepairStoreName());
                        OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreRpcService.getByCode(x.getRepairStoreCode());
                        if (null != orgStoreDetailRpcDTO) {
                            List<String> codes = new ArrayList<>();
                            codes.add(orgStoreDetailRpcDTO.getOuCode());
                            List<CustAccountVO> custAccountVOS = crmCustAccountRpcService.getCustAccountBycustCode(codes);
                            if (!custAccountVOS.isEmpty()) {
                                CustAccountVO custAccountVO = custAccountVOS.get(0);
                                if (!codeMap.containsKey(custAccountVO.getMobile())) {
                                    codeMap.put(custAccountVO.getMobile(), custAccountVO.getUserName());
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    log.error(e.getMessage());
                }
            });

            current++;
            param.setCurrent(current);
            repairOrderVOS = repairOrderRepoProc.query(param);
        }

        if (!CollectionUtils.isEmpty(codeMap)) {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            dto.setTemplateCode("WXB0001");
            HashMap<String, String> objectObjectHashMap = new HashMap<>();
            objectObjectHashMap.put("msgType", "b_repair_order_list");
            dto.setMesJoinParamMap(objectObjectHashMap);

            List<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<>();

            codeMap.keySet().forEach(x -> {
                Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map = new HashMap<>();
                map.put(MsgSendTypeEnum.SYS_INTERIOR,
                        TemplateAssignRecipientUserAccountDTO.builder().account(x).build());
                TemplateAssignRecipientUserDTO recipient = TemplateAssignRecipientUserDTO.builder()
                        .recipientUserAccountDtoMap(map)
                        .userName(codeMap.get(x))
                        .build();
                recipientUserList.add(recipient);
            });


            Map<String, String> interiorMap = Maps.newHashMap();
            sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        }

        log.info("维修工单接单超时定时任务结束");
    }

}
