package com.elitesland.yst.production.aftersale.model.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "battery_vehicle")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "battery_vehicle", comment = "车型标配电池配置表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "battery_vehicle", description = "车型标配电池配置表")
public class BatteryVehicleDO extends BaseModel {

    @Comment("商品类型")
    @Column(length = 32)
    private String type;

    @Comment("SPU名称")
    @Column(length = 100)
    private String spuName;

    @Comment("SPU编码")
    @Column(length = 100)
    private String spuCode;

    @Comment("整车标配")
    @Column(length = 100)
    private String itemGroup2;

    @Comment("电池数量")
    @Column()
    private Integer batteryNum;

    @Comment("展示序号")
    @Column()
    private Integer sortNo;

    @Comment("备注")
    @Column(length = 200)
    private String remark;

    @Comment("状态")
    @Column() // 0 禁用 1启用
    private Integer status;
}
