package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author YourName
 * @since YourVersion
 * @description InsureInfo表对应的Java实体类，用于封装数据库中的保险信息记录
 */
@Data
@Entity
@Table(name = "insure_info")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "insure_info", comment = "保险详情表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = "insure_info", description = "保险详情表")
public class InsureInfoDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 6696939650444719770L;

    @Id
    @Comment("记录唯一ID")
    @Column
    @GenericGenerator(
            name = "el-id",
            strategy = "com.elitescloud.cloudt.core.provider.IdGenerator"
    )
    @GeneratedValue(
            strategy = GenerationType.AUTO,
            generator = "el-id"
    )
    private Long id;

    @Comment("车架号")
    private String vinNo;

    @Comment("车型名称")
    private String modelName;

    @Comment("车辆价格")
    private String carPrice;

    @Comment("车辆购买时间")
    private String buyTime;

    @Comment("出厂时间（以字符串形式存储）")
    private String outFactoryTime;

    @Comment("投保类型")
    private String planId;

    @Comment("投保名称")
    private String planName;

    @Comment("经销商标识（可选）")
    private String dealerId;

    @Comment("门店标识（可选）")
    private String storeId;

    @Comment("省代码")
    private String province;

    @Comment("省名称")
    private String provinceName;

    @Comment("市代码")
    private String city;

    @Comment("市名称")
    private String cityName;

    @Comment("区代码")
    private String district;

    @Comment("区名称")
    private String districtName;

    @Comment("车主姓名")
    private String ownerName;

    @Comment("车主身份证号")
    private String ownerIdNo;

    @Comment("车主电话")
    private String ownerTel;

    @Comment("身份证影像base64编码")
    private String ownIdBase64;

    @Comment("车主签名影像base64编码")
    private String sqGzBase64;

    @Comment("保单流水号")
    private String orderNo;

    @Comment("投保时间（以字符串形式存储）")
    private String insureTime;

    @Comment("是否取消保险（0: 否, 1: 是）")
    private Integer isCancel;

    @Comment("是否删除（0: 否, 1: 是）")
    private Integer deleteFlag;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss.SSSS")
    @Comment("创建时间（以字符串形式存储）")
    private LocalDateTime createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss.SSSS")
    @Comment("更新时间（以字符串形式存储）")
    private LocalDateTime updateTime;
}