package com.elitesland.yst.production.aftersale.service;

import com.elitesland.yst.production.aftersale.model.param.BusinessComplaintSetParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintSetVO;

import java.util.List;

/**
 * @author elvis.hong
 * @title ComplaintSetService
 * @Date  2023/3/1
 */
public interface ComplaintSetService {

    /**
     * 客诉设置 - 查询
     * @param complaintSetPageParam
     * @return
     */
    List<ComplaintSetVO> complaintSetQuery(ComplaintSetPageParam complaintSetPageParam);

    /**
     * 客诉设置 - 保存/修改
     * @param complaintSetParam
     * @return
     */
    Long complaintSetSave(ComplaintSetParam complaintSetParam);

    /**
     * 客诉设置 - 批量删除
     * @param ids
     */
    void complaintSetDelete(List<Long> ids);

    /**
     * 客诉设置 - C端开启客诉
     * @param enableFlag
     */
    void complaintSetEnabledToC(String enableFlag);

    /**
     * 客诉设置 - C端客诉启用状态
     * @param complaintType
     * @return
     */
    String complaintSetFlagByC(String complaintType);

    /**
     * 基础设置 - 保存/修改
     * @param complaintSetParamList
     * @return
     */
    Long basicSetSave(List<ComplaintSetParam> complaintSetParamList);


    /**
     * B端客诉设置 - 一级分类查询
     * @return
     */
    List<ComplaintSetVO> businessComplaintSetQueryBase();

    /**
     * B端客诉设置 - 二级分类查询
     * @param id
     * @return
     */
    List<ComplaintSetVO> businessComplaintSetQuerySub(Long id);

    /**
     * B端客诉设置 - 新增
     * @param businessComplaintSetParam
     * @return
     */
    Long businessComplaintSetCreate(BusinessComplaintSetParam businessComplaintSetParam);

    /**
     * B端客诉设置 - 更新
     * @param businessComplaintSetParam
     * @return
     */
    Long businessComplaintSetUpdate(BusinessComplaintSetParam businessComplaintSetParam);



    /**
     * B端客诉设置 - 批量删除
     * @param ids
     */
    void businessComplaintSetDelete(List<Long> ids);

    /**
     * B端客诉设置(下拉框) - 查询
     * @return
     */
    List<ComplaintSetVO> query();
}
