package com.elitesland.yst.production.aftersale.common;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.core.base.SeqNumProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.yst.production.fin.common
 * @date 2023/2/27 19:12
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SysNumberGenerator {

    private static final String YST_FIN = "yst-after-sale";

    @Autowired
    private SeqNumProvider sysNumberRuleService;

    /**
     * 发号器调用
     *
     * @param ruleCode 发号器规则
     * @return 结果
     */
    public String generate(@NotNull String ruleCode) {
        return generateCode(ruleCode, null);
    }

    /**
     * 发号器调用
     *
     * @param ruleCode     发号器规则
     * @param runtimeValue runtime value
     * @return 结果
     */
    public String generate(@NotNull String ruleCode, @NotNull String runtimeValue) {
        return generateCode(ruleCode, Collections.singletonList(runtimeValue));
    }

    /**
     * 发号器调用
     *
     * @param ruleCode      发号器规则
     * @param runtimeValues runtime values
     * @return 结果
     */
    public String generate(@NotNull String ruleCode, @NotNull List<String> runtimeValues) {
        return generateCode(ruleCode, runtimeValues);
    }

    /**
     * 实际 调用发号器
     *
     * @param ruleCode      发号器规则
     * @param runtimeValues runtimeValues
     * @return 结果
     */
    private String generateCode(String ruleCode, List<String> runtimeValues) {

        log.debug("[SysNumberGeneratorWrapper] - 调用发号器，发号器规则：" + ruleCode + "; runtimeValues：" + runtimeValues);

        var code = sysNumberRuleService.generateCode(YST_FIN, ruleCode, runtimeValues);

        if (StringUtils.isBlank(code)) {
            log.error("[SysNumberGeneratorWrapper] - 调用发号器异常，规则：" + ruleCode);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "发号器生成编号为空，规则：" + ruleCode + "，请检查发号器规则配置是否正确");
        }

        return code;
    }
}
