package com.elitesland.yst.production.aftersale.controller.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.vo.CarVO;
import com.elitesland.yst.production.aftersale.service.CarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author elvis.hong
 * @date 2023/3/23
 */
@RestController
@RequestMapping(value = "/app/car", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "经销商App端车辆", tags = {"经销商App端车辆"})
public class AppCarController {


    @Autowired
    private CarService carService;


    @PostMapping("/carQuery")
    @ApiOperation("根据车架号查询车辆基本信息")
    public ApiResult<CarVO> carQuery(@RequestBody CarParam param) {
        ApiResult<CarVO> query = carService.query(param);
        return query;
    }


    @PostMapping("/carList")
    @ApiOperation("车辆列表")
    public ApiResult<List<CarVO>> carList() {
        List<CarVO> carVOS = carService.carList();
        return ApiResult.ok(carVOS);
    }


}
