package com.elitesland.yst.production.aftersale.controller.app;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.RegisterMemberParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author elvis.hong
 * @date 2023/3/23
 */
@RestController
@RequestMapping(value = "/app/ownerInfo", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Slf4j
@RequiredArgsConstructor
@Api(value = "经销商App端车主信息", tags = {"经销商App端车主信息"})
public class AppCarOwnerInfoController {

    @Autowired
    private CarOwnerInfoService carOwnerInfoService;


    @GetMapping(value = "/ownerInfoByUserPhone/{userPhone}")
    @ApiOperation(value = "通过手机号查询车主信息")
    public ApiResult<CarOwnerInfoMngRespVO> ownerInfoByUserPhone(@PathVariable("userPhone") String userPhone) {
        CarOwnerInfoMngRespVO carOwnerInfoMngRespVO = carOwnerInfoService.ownerInfoByUserPhone(userPhone);
        return ApiResult.ok(carOwnerInfoMngRespVO);
    }

    @PostMapping(value = "/registerMember")
    @ApiOperation(value = "注册会员")
    public ApiResult<Long> registerMember(@RequestBody RegisterMemberParam registerMemberParam) {
        Long res = carOwnerInfoService.registerMember(registerMemberParam);
        return ApiResult.ok(res);
    }
    @PostMapping(value = "/getKaptcha/{phone}")
    @ApiOperation(value = "获取验证码")
    public ApiResult getKaptcha(@PathVariable String phone) {
        try {
             carOwnerInfoService.getKaptcha(phone);
             return ApiResult.ok();
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

}
