package com.elitesland.yst.production.aftersale.controller.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderExlParam;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;

@RestController
@RequestMapping(value = "/app/repairOrder", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "经销商App端维修工单", tags = {"经销商App端维修工单"})
@RequiredArgsConstructor
@Log4j2
public class AppRepairOrderController {

    private final RepairOrderService repairOrderService;
    private final ExportExcelService<RepairOrderExlParam, RepairOrderVO, Serializable> exportExcelService;

    @PostMapping("/repairOrderQuery")
    @ApiOperation("维修工单分页查询")
    public ApiResult<PagingVO<RepairOrderVO>> repairOrderQuery(@RequestBody RepairOrderExlParam param) {
        PagingVO<RepairOrderVO> query = repairOrderService.pcQuery(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/repairOrderDetail")
    @ApiOperation("维修工单详情查询")
    public ApiResult<RepairOrderVO> repairOrderDetail(@RequestBody RepairOrderExlParam param) {
        RepairOrderVO query = repairOrderService.detail(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/repairOrderDelete")
    @ApiOperation("维修工单批量删除")
    public ApiResult repairOrderCancel(@RequestBody List<Long> idList) {
        repairOrderService.repairOrderDelete(idList);
        return ApiResult.ok();
    }

    @PostMapping("/repairOrderSave")
    @ApiOperation("维修工单提交保存/修改")
    public ApiResult<Long> repairOrderSave(@RequestBody com.elitesland.yst.production.aftersale.model.param.RepairOrderParam saveVO) {
        Long ret = repairOrderService.save(saveVO, "APP");
        return ApiResult.ok(ret);
    }

    @PostMapping("/repairOrderConfirm")
    @ApiOperation("维修工单确认完成")
    public ApiResult<Long> repairOrderConfirm(@RequestBody com.elitesland.yst.production.aftersale.model.param.RepairOrderParam saveVO) {
        Long confirm = repairOrderService.confirm(saveVO);
        return ApiResult.ok(confirm);
    }

    @PostMapping("/repairOrderStart")
    @ApiOperation("维修工单开始维修")
    public ApiResult<Long> repairOrderStart(@RequestBody com.elitesland.yst.production.aftersale.model.param.RepairOrderParam saveVO) {
        Long confirm = repairOrderService.start(saveVO);
        return ApiResult.ok(confirm);
    }

    @PostMapping("/repairOrderSupply")
    @ApiOperation("维修工单信息补充")
    public ApiResult<Long> repairOrderSupply(@RequestBody com.elitesland.yst.production.aftersale.model.param.RepairOrderParam saveVO) {
        Long confirm = repairOrderService.supply(saveVO);
        return ApiResult.ok(confirm);
    }

    @PostMapping("/repairOrderCancel")
    @ApiOperation("维修工单取消")
    public ApiResult<Long> repairOrderCancel(@RequestBody com.elitesland.yst.production.aftersale.model.param.RepairOrderParam saveVO) {
        ApiResult<Long> longApiResult = repairOrderService.repairOrderCancel(saveVO);
        return longApiResult;
    }

    @PostMapping("/repairOrderExport")
    @ApiOperation("维修工单导出")
    public ApiResult repairOrderExport(HttpServletResponse response, @RequestBody RepairOrderExlParam param) {
        ExcelUtils.buildExportColumn(param, RepairOrderVO.class);
        try {
            exportExcelService.export(param, response, repairOrderService::export).get();
            return ApiResult.ok();
        } catch (Exception e) {
            log.info("导出失败：{}", e);
            return ApiResult.fail("导出失败：", e.getMessage());
        }
    }


}
