package com.elitesland.yst.production.aftersale.controller.front;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author RYH
 * @date 2023/2/21
 */
@RestController
@RequestMapping(value = "/front/orderEvaluation", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "经销商pc端工单评价", tags = {"经销商pc端工单评价"})
public class FrontOrderEvaluationController {


    @Autowired
    private OrderEvaluationService orderEvaluationService;

    @PostMapping("/orderEvaluationSave")
    @ApiOperation("工单评价提交保存")
    public ApiResult<Long> complaintOrderSave(@RequestBody OrderEvaluationParam saveVO) {
        Long ret = orderEvaluationService.save(saveVO);
        return ApiResult.ok(ret);
    }

    @PostMapping("/orderEvaluationQuery")
    @ApiOperation("工单评价查询")
    public ApiResult<OrderEvaluationVO> repairOrderQuery(@RequestBody OrderEvaluationParam param) {
        OrderEvaluationVO ret = orderEvaluationService.query(param);
        return ApiResult.ok(ret);
    }
}
