package com.elitesland.yst.production.aftersale.controller.miniapp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoParam;
import com.elitesland.yst.production.aftersale.model.param.RegisterMemberParam;
import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Danny.Wang
 * @title CarOwnerInfoController
 * @Date2023/2/8 13:24
 */
@RestController
@RequestMapping(value = "/miniApp/userInfo", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "车主信息", tags = {"车主信息"})
public class CarOwnerInfoController {

    @Autowired
    private CarOwnerInfoService carOwnerInfoService;

    @PostMapping(value = "/save")
    @ApiOperation(value = "车主信息保存更新")
    public ApiResult<Object> save(@RequestBody CarOwnerInfoParam carOwnerInfoParam) {
        return carOwnerInfoService.save(carOwnerInfoParam);
    }

    @GetMapping(value = "/query")
    @ApiOperation(value = "车主信息查询")
    public ApiResult<Object> query() {
        return carOwnerInfoService.query();
    }

    @GetMapping(value = "/pageInfoQuery")
    @ApiOperation(value = "个人中心主页信息查询")
    public ApiResult<Object> pageInfoQuery() {
        return carOwnerInfoService.pageInfoQuery();
    }

    @PostMapping(value = "/cancelMember")
    @ApiOperation(value = "注销会员")
    public ApiResult<Long> cancelMember(@RequestBody RegisterMemberParam registerMemberParam) {
        return ApiResult.ok(carOwnerInfoService.cancelMember(registerMemberParam));
    }

}
