package com.elitesland.yst.production.aftersale.controller.miniapp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderCancelParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.service.ComplaintOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * @author RYH
 * @date 2023/2/14
 */
@RestController
@RequestMapping(value = "/miniApp/complaintOrder", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "客诉工单", tags = {"客诉工单"})
public class ComplaintOrderController {

    @Autowired
    private ComplaintOrderService complaintOrderService;

    @PostMapping("/complaintOrderSave")
    @ApiOperation("客诉工单提交保存/修改")
    public ApiResult<Long> complaintOrderSave(@RequestBody com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam saveVO) {
        Long ret = complaintOrderService.save(saveVO);
        return ApiResult.ok(ret);
    }

    @PostMapping("/complaintOrderBatchCancel")
    @ApiOperation("客诉工单批量取消")
    public ApiResult<Long> complaintOrderBatchCancel(@RequestBody List<Long> ids) {
        complaintOrderService.complaintOrderBatchCancel(ids);
        return ApiResult.ok();
    }

    @PostMapping("/complaintOrderCancel")
    @ApiOperation("客诉工单取消")
    public ApiResult<Long> complaintOrderCancel(@RequestBody ComplaintOrderCancelParam param) {
        complaintOrderService.complaintOrderCancel(param);
        return ApiResult.ok();
    }

    @PostMapping("/complaintOrderListQuery")
    @ApiOperation("客诉工单列表查询")
    public ApiResult<PagingVO<ComplaintOrderVO>> complaintOrderListQuery(@RequestBody ComplaintOrderPageParam param) {
        PagingVO<ComplaintOrderVO> query = complaintOrderService.query(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/complaintOrderInfoQuery")
    @ApiOperation("客诉工单详细信息查询")
    public ApiResult<ComplaintOrderVO> complaintOrderInfoQuery(@RequestBody ComplaintOrderPageParam param) {
        ComplaintOrderVO query = complaintOrderService.queryInfo(param);
        return ApiResult.ok(query);
    }


}
