package com.elitesland.yst.production.aftersale.controller.miniapp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderExlParam;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/miniApp/repairOrder", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "小程序端维修工单", tags = {"小程序端维修工单"})
public class RepairOrderController {

    @Autowired
    private RepairOrderService repairOrderService;


    @PostMapping("/repairOrderQuery")
    @ApiOperation("维修工单分页查询")
    public ApiResult<PagingVO<RepairOrderVO>> repairOrderQuery(@RequestBody RepairOrderExlParam param) {
        PagingVO<RepairOrderVO> query = repairOrderService.query(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/repairOrderDetail")
    @ApiOperation("维修工单详情查询")
    public ApiResult<RepairOrderVO> repairOrderDetail(@RequestBody RepairOrderExlParam param) {
        RepairOrderVO query = repairOrderService.detail(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/repairOrderSave")
    @ApiOperation("维修工单提交保存/修改")
    public ApiResult<Long> repairOrderSave(@RequestBody com.elitesland.yst.production.aftersale.model.param.RepairOrderParam saveVO) {
        Long ret = repairOrderService.save(saveVO, "MINIAPP");
        return ApiResult.ok(ret);
    }

    @PostMapping("/repairOrderCancel")
    @ApiOperation("维修工单取消")
    public ApiResult<Long> repairOrderCancel(@RequestBody com.elitesland.yst.production.aftersale.model.param.RepairOrderParam saveVO) {
        ApiResult<Long> longApiResult = repairOrderService.repairOrderCancel(saveVO);
        return longApiResult;
    }


}
