package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.service.ComplaintOrderService;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import lombok.val;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/23
 */
@RestController
@RequestMapping(value = "/pc/complaintOrder", produces = MediaType.APPLICATION_JSON_VALUE)
@RequiredArgsConstructor
@Validated
@Log4j2
@Api(value = "中台管理端客诉工单", tags = {"中台管理端客诉工单"})
public class PcComplaintOrderController {

    private final ComplaintOrderService complaintOrderService;
    private final ExportExcelService<ComplaintOrderExlParam, ComplaintOrderVO, Serializable> exportExcelService;

    @PostMapping("/complaintOrderSave")
    @ApiOperation("客诉工单提交保存/修改")
    public ApiResult<Long> complaintOrderSave(@RequestBody com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam saveVO) {
        Long ret = complaintOrderService.save(saveVO);
        return ApiResult.ok(ret);
    }


    @PostMapping("/complaintOrderListQuery")
    @ApiOperation("客诉工单列表查询")
    public ApiResult<PagingVO<ComplaintOrderVO>> complaintOrderListQuery(@RequestBody ComplaintOrderPageParam param) {
        param.setSource("PC");
        PagingVO<ComplaintOrderVO> query = complaintOrderService.query(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/complaintOrderInfoQuery")
    @ApiOperation("客诉工单详细信息查询")
    public ApiResult<ComplaintOrderVO> complaintOrderInfoQuery(@RequestBody ComplaintOrderPageParam param) {
        ComplaintOrderVO query = complaintOrderService.queryInfo(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/complaintOrderExport")
    @ApiOperation("客诉工单导出")
    public ApiResult complaintOrderExport(HttpServletResponse response, @RequestBody ComplaintOrderExlParam param) {
        ExcelUtils.buildExportColumn(param, ComplaintOrderVO.class);
        try {
            exportExcelService.export(param, response, complaintOrderService::export).get();
            return ApiResult.ok();
        } catch (Exception e) {
            log.info("客诉工单导出失败：{}", e);
            return ApiResult.fail("导出失败：", e.getMessage());
        }
    }

    @PostMapping("/complaintOrderDelete")
    @ApiOperation("客诉工单删除")
    public ApiResult complaintOrderDelete(@RequestBody List<Long> ids) {
        complaintOrderService.complaintOrderDelete(ids);
        return ApiResult.ok();
    }

    @PostMapping("/complaintOrderDispatch")
    @ApiOperation("客诉工单派单")
    public ApiResult complaintOrderDispatch(@RequestBody com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam saveVO) {
        complaintOrderService.complaintOrderDispatch(saveVO);
        return ApiResult.ok();
    }

    @PostMapping("/complaintOrderComplete")
    @ApiOperation("客诉工单解决")
    public ApiResult complaintOrderComplete(@RequestBody com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam saveVO) {
        complaintOrderService.complaintOrderComplete(saveVO);
        return ApiResult.ok();
    }

    @PostMapping("/orderJob")
    @ApiOperation("客诉工单定时任务测试")
    public ApiResult orderJob() {
        complaintOrderService.complaintOrderJob();
        complaintOrderService.repairOrderJob();
        complaintOrderService.respTimeOutJob();
        complaintOrderService.handleTimeOutJob();
        return ApiResult.ok();
    }


}
