package com.elitesland.yst.production.aftersale.controller.pc;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.BusinessComplaintSetParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintSetVO;
import com.elitesland.yst.production.aftersale.service.ComplaintSetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author elvis.hong
 * @title PcComplaintSetController
 * @Date  2023/3/1
 */
@RestController
@RequestMapping(value = "/pc/complaintSet", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Slf4j
@RequiredArgsConstructor
@Api(value = "中台管理端售后设置", tags = {"中台管理端售后设置"})
public class PcComplaintSetController {

    @Autowired
    private ComplaintSetService complaintSetService;

    @PostMapping("/complaintSetQuery")
    @ApiOperation("C端客诉设置查询")
    public ApiResult<List<ComplaintSetVO>> complaintSetQuery(@RequestBody ComplaintSetPageParam complaintSetPageParam) {
        return ApiResult.ok(complaintSetService.complaintSetQuery(complaintSetPageParam));
    }

    @GetMapping("/businessComplaintSetQueryBase")
    @ApiOperation("B端客诉设置一级分类查询")
    public ApiResult<List<ComplaintSetVO>> businessComplaintSetQueryBase() {
        return ApiResult.ok(complaintSetService.businessComplaintSetQueryBase());
    }

    @PostMapping("/businessComplaintSetQuery/{id}")
    @ApiOperation("B端客诉设置二级分类查询")
    public ApiResult<List<ComplaintSetVO>> businessComplaintSetQuerySub(@PathVariable("id") Long id) {
        return ApiResult.ok(complaintSetService.businessComplaintSetQuerySub(id));
    }
    @PostMapping("/businessComplaintSetCreate")
    @ApiOperation("B端客诉设置新增")
    public ApiResult<Long> businessComplaintSetCreate(@RequestBody @Validated BusinessComplaintSetParam businessComplaintSetParam) {
        return ApiResult.ok(complaintSetService.businessComplaintSetCreate(businessComplaintSetParam));
    }

    @PostMapping("/businessComplaintSetUpdate")
    @ApiOperation("B端客诉设置更新")
    public ApiResult<Long> businessComplaintSetUpdate(@RequestBody @Validated BusinessComplaintSetParam businessComplaintSetParam) {
        return ApiResult.ok(complaintSetService.businessComplaintSetUpdate(businessComplaintSetParam));
    }

    @PostMapping("/businessComplaintSetDelete")
    @ApiOperation("B端客诉设置批量删除")
    public ApiResult businessComplaintSetDelete(@RequestBody List<Long> ids) {
        complaintSetService.businessComplaintSetDelete(ids);
        return ApiResult.ok();
    }

    @PostMapping(value = "/complaintSetSave")
    @ApiOperation(value = "客诉设置新增/编辑")
    public ApiResult<Long> complaintSetSave(@RequestBody @Validated ComplaintSetParam complaintSetParam) {
        return ApiResult.ok(complaintSetService.complaintSetSave(complaintSetParam));
    }

    @PostMapping("/complaintSetDelete")
    @ApiOperation("客诉设置批量删除")
    public ApiResult complaintSetDelete(@RequestBody List<Long> ids) {
        complaintSetService.complaintSetDelete(ids);
        return ApiResult.ok();
    }

    @PostMapping("/complaintSetEnabledToC")
    @ApiOperation("客诉设置C端客诉启用/禁用")
    public ApiResult complaintSetEnabledToC(@RequestBody ComplaintSetParam complaintSetParam) {
        complaintSetService.complaintSetEnabledToC(complaintSetParam.getEnableFlag());
        return ApiResult.ok();
    }


    @GetMapping("/complaintSetFlagByC")
    @ApiOperation("客诉设置C端客诉启用状态")
    public ApiResult<String> complaintSetFlagByC() {
        return ApiResult.ok(complaintSetService.complaintSetFlagByC("3"));
    }

    @PostMapping(value = "/basicSetSave")
    @ApiOperation(value = "基础设置保存")
    public ApiResult<Long> basicSetSave(@RequestBody @Validated List<ComplaintSetParam> complaintSetParamList) {
        return ApiResult.ok(complaintSetService.basicSetSave(complaintSetParamList));
    }


    @GetMapping("/query")
    @ApiOperation("B端客诉分类查询(下拉框)")
    public ApiResult<List<ComplaintSetVO>> query() {
        return ApiResult.ok(complaintSetService.query());
    }
}
