package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecClsRespVO;
import com.elitesland.yst.production.aftersale.model.vo.query.PhoneRecClsQueryVO;
import com.elitesland.yst.production.aftersale.model.vo.save.PhoneRecClsSaveVO;
import com.elitesland.yst.production.aftersale.service.PhoneRecClsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author zhengyue
 * @description: 400电话记录分类
 * @date 2024/4/18 16:56
 */
@RestController
@RequestMapping("/phoneRecCls")
@RequiredArgsConstructor
@Api(value = "400电话记录分类", tags = {"400电话记录分类"})
public class PcPhoneRecClsController {

    @Autowired
    private PhoneRecClsService phoneRecClsService;

    @PostMapping("/create")
    @ApiOperation("分类新增")
    public ApiResult<Long> create(@RequestBody @Valid PhoneRecClsSaveVO saveVO) {
        return ApiResult.ok(phoneRecClsService.create(saveVO));
    }

    @PostMapping("/update")
    @ApiOperation("分类更新")
    public ApiResult<Long> update(@RequestBody @Valid PhoneRecClsSaveVO saveVO) {
        return ApiResult.ok(phoneRecClsService.update(saveVO));
    }

    @PostMapping("/delete")
    @ApiOperation("分类删除")
    public ApiResult<Long> delete(@RequestBody List<Long> ids) {
        return ApiResult.ok(phoneRecClsService.delete(ids));
    }

    @GetMapping("/query")
    @ApiOperation("分类查询")
    public ApiResult<List<PhoneRecClsRespVO>> query() {
        return ApiResult.ok(phoneRecClsService.query());
    }

    @GetMapping("/queryDetail/{id}")
    @ApiOperation("分类明细查询")
    public ApiResult<PhoneRecClsRespVO> queryDetail(@PathVariable Long id) {
        return ApiResult.ok(phoneRecClsService.queryDetail(id));
    }

    @PostMapping("/queryByParam")
    @ApiOperation("参数查询分类")
    public ApiResult<PagingVO<PhoneRecClsRespVO>> queryByParam(@RequestBody PhoneRecClsQueryVO param) {
        return ApiResult.ok(phoneRecClsService.queryByParam(param));
    }

    @GetMapping("/querySub/{id}")
    @ApiOperation("查询下级分类")
    public ApiResult<List<PhoneRecClsRespVO>> querySub(@PathVariable("id") Long id) {
        return ApiResult.ok(phoneRecClsService.querySub(id));
    }

    @GetMapping("/queryBase")
    @ApiOperation("查询所有一级分类")
    public ApiResult<List<PhoneRecClsRespVO>> queryBase() {
        return ApiResult.ok(phoneRecClsService.queryBase());
    }

}
