package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecordDO;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordPageParam;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordParam;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecordVO;
import com.elitesland.yst.production.aftersale.service.PhoneRecordService;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-5-10
 * @desc : 电话记录Controller
 */
@RestController
@RequestMapping("/pc/phoneRecord")
@RequiredArgsConstructor
@Api(value = "中台管理电话记录", tags = {"中台管理电话记录"})
@Log4j2
public class PcPhoneRecordController {

    private final PhoneRecordService phoneRecordService;

    private final ExportExcelService<PhoneRecordPageParam, PhoneRecordVO, Serializable> exportExcelService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-电话记录")
    public ApiResult<PhoneRecordVO> get(@PathVariable Long id) {
        PhoneRecordVO res = phoneRecordService.get(id);
        return ApiResult.ok(res);
    }

    @PostMapping("save")
    @ApiOperation("新增-电话记录")
    public ApiResult<Long> save(@RequestBody PhoneRecordParam phoneRecordParam) {
        PhoneRecordDO res = phoneRecordService.save(phoneRecordParam);
        return ApiResult.ok(res.getId());
    }

    @PostMapping("update")
    @ApiOperation("修改-电话记录")
    public ApiResult<Long> update(@RequestBody PhoneRecordParam phoneRecordParam) {
        PhoneRecordDO res = phoneRecordService.update(phoneRecordParam);
        return ApiResult.ok(res.getId());
    }

    @PostMapping("del")
    @ApiOperation("删除-电话记录")
    public ApiResult del(@RequestBody List<Long> ids) {
        phoneRecordService.del(ids);
        return ApiResult.ok();
    }

    @PostMapping("page")
    @ApiOperation("分页查询-电话记录")
    public ApiResult<PagingVO<PhoneRecordVO>> page(@RequestBody PhoneRecordPageParam phoneRecordPageParam) {
        PagingVO<PhoneRecordVO> res = phoneRecordService.page(phoneRecordPageParam);
        return ApiResult.ok(res);
    }

    @PostMapping("/export")
    @ApiOperation("导出-电话记录")
    public ApiResult export(@RequestBody PhoneRecordPageParam param, HttpServletResponse response) {
        ExcelUtils.buildExportColumn(param, PhoneRecordVO.class);

        try {
            exportExcelService.export(param, response, phoneRecordService::export).get();
            return null;
        } catch (Exception e) {
            log.info("导出失败：{}", e);
            return ApiResult.fail("导出失败：", e.getMessage());
        }
    }


}

