package com.elitesland.yst.production.aftersale.controller.pc;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.util.AsyncExcelUtils;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;

/**
 * @author elvis.hong
 * @title PcVehicleBindInfoController
 * @Date 2023/2/27
 */
@RestController
@RequestMapping(value = "/pc/vehicleBindInfo", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Slf4j
@RequiredArgsConstructor
@Api(value = "中台管理端车辆绑定信息管理", tags = {"中台管理端车辆绑定信息管理"})
public class PcVehicleBindInfoController {

    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;

    private final ExportExcelService<BindSoldVehicleParam, BindSoldVehicleVO, Serializable> exportExcelService;

    @PostMapping("/vehicleBindInfoQuery")
    @ApiOperation("车辆绑定信息管理分页查询")
    public ApiResult<PagingVO<BindSoldVehicleVO>> vehicleBindInfoQuery(@RequestBody BindSoldVehicleParam param) {
        PagingVO<BindSoldVehicleVO> query = carOwnerVehicleService.vehicleBindInfoQuery(param);
        return ApiResult.ok(query);
    }

    @PostMapping("/vehicleBindInfoQuerySaleMan")
    @ApiOperation("车辆绑定信息管理分页查询(业务)")
    public ApiResult<PagingVO<BindSoldVehicleVO>> vehicleBindInfoQuerySaleMan(@RequestBody BindSoldVehicleParam param) {
        PagingVO<BindSoldVehicleVO> query = carOwnerVehicleService.vehicleBindInfoQuerySaleMan(param);
        return ApiResult.ok(query);
    }

    @GetMapping(value = "/vehicleBindInfoDetail/{id}")
    @ApiOperation(value = "车辆绑定信息管理明细查询")
    public ApiResult<CarOwnerVehicleInfoVO> vehicleBindInfoDetail(@PathVariable("id") Long id) {
        return ApiResult.ok(carOwnerVehicleService.bindSoldVehicleDetail(id));
    }

    @PostMapping(value = "/vehicleBindInfoExport", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    @ApiOperation(value = "车辆绑定信息管理导出数据")
    public ApiResult<?> vehicleBindInfoExport(HttpServletResponse response, @RequestBody BindSoldVehicleParam queryVO) {
        //ExcelUtils.buildExportColumn(queryVO, BindSoldVehicleVO.class);
        try {
            //exportExcelService.export(queryVO, response, carOwnerVehicleService::vehicleBindInfoQuery).get();
            AsyncExcelUtils.export(response, "车辆绑定信息列表", AsyncExcelUtils.buildExportColumn(BindSoldVehicleVO.class), carOwnerVehicleService::vehicleBindInfoQuery, queryVO);
            return null;
        } catch (Exception e) {
            log.error("导出失败：{}", e);
            return ApiResult.fail("导出失败：" + e.getMessage());
        }
    }

    @PostMapping(value = "/vehicleBindInfoExportSaleMan", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    @ApiOperation(value = "车辆绑定信息管理导出数据(业务)")
    public ApiResult<?> vehicleBindInfoExportSaleMan(HttpServletResponse response, @RequestBody BindSoldVehicleParam queryVO) {
        //ExcelUtils.buildExportColumn(queryVO, BindSoldVehicleVO.class);
        try {
            //exportExcelService.export(queryVO, response, carOwnerVehicleService::vehicleBindInfoQuerySaleMan).get();
            AsyncExcelUtils.export(response, "车辆绑定信息列表(业务)", AsyncExcelUtils.buildExportColumn(BindSoldVehicleVO.class), carOwnerVehicleService::vehicleBindInfoQuerySaleMan, queryVO);
            return null;
        } catch (Exception e) {
            log.error("导出失败：{}", e);
            return ApiResult.fail("导出失败：" + e.getMessage());
        }
    }



    @PostMapping(value = "/delThreePackage")
    @ApiOperation(value = "解绑车辆并删除三包信息")
    public ApiResult<Object> delThreePackage(@RequestBody Long id) {
        ApiResult<Object> res = carOwnerVehicleService.deleteBindVehicleAndThreePack(id);
        return res;
    }

}

