package com.elitesland.yst.production.aftersale.controller.test;

import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.*;

import com.elitescloud.cloudt.system.service.SysMsgTemplateSendRpcService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 消息模板管理
 * @date : 2023/5/23 12:28
 */
@Api(tags = "消息模板管理-消息发送")
@RestController
@RequestMapping(value = "/test/msg/sysMsgSend", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class MsgTest {

    private final SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService;
    private final ObjectMapper objectMapper = ObjectMapperFactory.instance();

    public MsgTest(SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService) {
        this.sysMsgTemplateSendRpcService = sysMsgTemplateSendRpcService;
    }


    @PostMapping("/sendEmployeeDemo")
    @ApiOperation(value = "消息模板-员工消息发送样例测试，后台组织好了固定参数，参数")
    @ApiOperationSupport(order = 99)
    public ApiResult<String> sendEmployeeDemo(@RequestBody TemplateEmployeeSendParamDTO dto) {

        if (StringUtils.isBlank(dto.getTemplateCode())) {
            dto.setTemplateCode("test1");
        }
        //处理文本占位传参 start
        List<TemplateTxtReplaceDTO> templateTxtReplaceDTOS = new ArrayList<>();
        /**邮件信息***/
        Map emailMap = Maps.newHashMap();
        emailMap.put("name", "测试模板邮件替换name");
        TemplateTxtReplaceDTO emailDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.EMAIL)
                .replaceMap(emailMap)
                .build();
        templateTxtReplaceDTOS.add(emailDTO);
        /**邮件信息***/

        /**站内信息***/
        Map interiorMap = Maps.newHashMap();
        interiorMap.put("name", "测试模板站内替换name");
        TemplateTxtReplaceDTO templateTxtReplaceDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.SYS_INTERIOR)
                .replaceMap(interiorMap)
                .build();
        templateTxtReplaceDTOS.add(templateTxtReplaceDTO);
        /**站内信息***/

        /**短信信息***/
        Map smsMap = Maps.newHashMap();
        smsMap.put("name", "测试模板短信替换name");
        TemplateTxtReplaceDTO smsDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.MOBILE_SMS)
                .replaceMap(interiorMap)
                .build();
        ;

        templateTxtReplaceDTOS.add(smsDTO);
        /**站内信息***/
        dto.setMsgTemplateContentReplaceDTOS(templateTxtReplaceDTOS);
        //处理文本占位传参 end

        //处理title文本占位，和内容参数一致不在重复替换
        dto.setMsgTemplateTitleReplaceDTOS(templateTxtReplaceDTOS);
        //处理title文本占位 end

        //发送人 start
        MsgSendEmployeeUserDTO sendUser = MsgSendEmployeeUserDTO.builder()
                .userCode("adminCode")
                .userName("admin")
                .userId(26183177199419838L)
                .build();
        dto.setSendUser(sendUser);
        //发送人 end

        //接收人 start
        List<MsgRecipientUserDTO> recipientUserList = new ArrayList<>();
        MsgRecipientUserDTO recipient1 = MsgRecipientUserDTO.builder()
                .userId(26515388624798699L)
                .userName("niuchen1234")
                .build();
        recipientUserList.add(recipient1);

        MsgRecipientUserDTO recipient2 = MsgRecipientUserDTO.builder()
                .userId(685451965261485398L)
                .userName("WWW")
                .build();
        recipientUserList.add(recipient2);

        MsgRecipientUserDTO recipient3 = MsgRecipientUserDTO.builder()
                .userId(687286284481272935L)
                .userName("test12132135")
                .build();
        recipientUserList.add(recipient3);

        dto.setRecipientUserList(recipientUserList);
        //发送人 end
        String json = null;
        try {
            json = objectMapper.writeValueAsString(dto);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("JSON序列化异常：", e);
        }
        var api = sysMsgTemplateSendRpcService.msgTemplateEmployeeSend(dto);
        api.setMsg(json);
        return api;
    }


    @PostMapping("/msgTemplateMsgTypeParamSendDemo")
    @ApiOperation(value = "消息模板-自定义人员发送消息样例测试，后台组织好了固定参数，参数")
    @ApiOperationSupport(order = 99)
    public ApiResult<String> msgTemplateMsgTypeParamSendDemo(@RequestBody TemplateAssignSendParamDTO dto) {
        if (StringUtils.isBlank(dto.getTemplateCode())) {
            // 消息模板编码
            dto.setTemplateCode("test1");
        }
        //处理文本占位传参 start
        List<TemplateTxtReplaceDTO> templateTxtReplaceDTOS = new ArrayList<>();
        /**邮件信息***/
        Map emailMap = Maps.newHashMap();
        emailMap.put("name", "测试模板邮件替换name");
        TemplateTxtReplaceDTO emailDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.EMAIL)
                .replaceMap(emailMap)
                .build();
        templateTxtReplaceDTOS.add(emailDTO);
        /**邮件信息***/

        /**站内信息***/
        Map interiorMap = Maps.newHashMap();
        interiorMap.put("name", "测试模板站内替换name");
        TemplateTxtReplaceDTO templateTxtReplaceDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.SYS_INTERIOR)
                .replaceMap(interiorMap)
                .build();
        templateTxtReplaceDTOS.add(templateTxtReplaceDTO);
        /**站内信息***/

        /**短信信息***/
        Map smsMap = Maps.newHashMap();
        smsMap.put("name", "测试模板短信替换name");
        TemplateTxtReplaceDTO smsDTO = TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.MOBILE_SMS)
                .replaceMap(interiorMap)
                .build();
        ;

        templateTxtReplaceDTOS.add(smsDTO);
        /**站内信息***/
        dto.setMsgTemplateContentReplaceDTOS(templateTxtReplaceDTOS);
        //处理文本占位传参 end

        //处理title文本占位，和内容参数一致不在重复替换
        dto.setMsgTemplateTitleReplaceDTOS(templateTxtReplaceDTOS);
        //处理title文本占位 end

        //发送人 start
        MsgSendEmployeeUserDTO sendUser = MsgSendEmployeeUserDTO.builder()
                .userCode("adminCode")
                .userName("admin")
                .userId(26183177199419838L)
                .build();
        dto.setSendUser(sendUser);
        //发送人 end

        //接收人 start
        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map1 = new HashMap<>();
        map1.put(MsgSendTypeEnum.EMAIL,
                TemplateAssignRecipientUserAccountDTO.builder().account("Charlie.chen@elitesland.com").build());
        map1.put(MsgSendTypeEnum.MOBILE_SMS,
                TemplateAssignRecipientUserAccountDTO.builder().account("15136125108").build());
        List<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<>();
        TemplateAssignRecipientUserDTO recipient1 = TemplateAssignRecipientUserDTO.builder()
                .userId(26515388624798699L)
                .userName("niuchen1234")
                .recipientUserAccountDtoMap(map1)
                .build();
        recipientUserList.add(recipient1);


        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map2 = new HashMap<>();
        map2.put(MsgSendTypeEnum.EMAIL,
                TemplateAssignRecipientUserAccountDTO.builder().account("Kaiser.wang@elitesland.com").build());
        map2.put(MsgSendTypeEnum.MOBILE_SMS,
                TemplateAssignRecipientUserAccountDTO.builder().account("13523496731").build());
        TemplateAssignRecipientUserDTO recipient2 = TemplateAssignRecipientUserDTO.builder()
                .userId(685451965261485398L)
                .userName("WWW")
                .recipientUserAccountDtoMap(map2)
                .build();
        recipientUserList.add(recipient2);


        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<>();
        map3.put(MsgSendTypeEnum.EMAIL,
                TemplateAssignRecipientUserAccountDTO.builder().account("chen.niu@elitesland.com").build());
        map3.put(MsgSendTypeEnum.MOBILE_SMS,
                TemplateAssignRecipientUserAccountDTO.builder().account("13607654220").build());
        TemplateAssignRecipientUserDTO recipient3 = TemplateAssignRecipientUserDTO.builder()
                .userId(687286284481272935L)
                .userName("test12132135")
                .recipientUserAccountDtoMap(map3)
                .build();
        recipientUserList.add(recipient3);

        dto.setRecipientUserList(recipientUserList);
        //发送人 end
        String json = null;
        try {
            json = objectMapper.writeValueAsString(dto);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("JSON序列化异常：", e);
        }
        var api = sysMsgTemplateSendRpcService.msgTemplateMsgTypeParamSend(dto);
        api.setMsg(json);
        return api;
    }

}
