package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name = "battery_codes")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "battery_codes", comment = "电池编码表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "battery_codes", description = "电池编码表")
public class BatteryCodesDO extends BaseModel {

    @Comment("商品统一编码")
    @Column(length = 64)
    private String code;

    @Comment("商品类型")
    @Column(length = 32)
    private String type;

    @Comment("厂家商品编码")
    @Column(length = 32)
    private String fgCode;

    @Comment("厂家编码")
    @Column(length = 32)
    private String factoryCode;

    @Comment("厂家名称")
    @Column(length = 32)
    private String factoryName;

    @Comment("产品品类")
    @Column(length = 32)
    private String prodCategory;

    @Comment("产品规格")
    @Column(length = 64)
    private String prodSpecs;

    @Comment("产品型号")
    @Column(length = 64)
    private String prodModel;

    @Comment("产地")
    @Column(length = 64)
    private String producer;

    @Column(name = "factory_out_time", columnDefinition = "datetime default null  comment '厂家出库时间'")
    private LocalDateTime factoryOutTime;

    @Column(name = "in_time", columnDefinition = "datetime default null  comment '入库时间'")
    private LocalDateTime inTime;

    @Column(name = "out_time", columnDefinition = "datetime default null  comment '出库时间'")
    private LocalDateTime outTime;
}
