package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleInfoDO
 * @Date2023/2/8 10:58
 */
@Entity
@Table(name = "car_owner_vehicle_info")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "car_owner_vehicle_info", comment = "车主车辆信息表")
@Where(clause = "delete_flag = 0")
@Data
@Accessors(chain = true)
@ApiModel(value = "car_owner_vehicle_info", description = "车主车辆信息表")
public class CarOwnerVehicleInfoDO extends BaseModel {

    @ApiModelProperty("车主姓名")
    @Column(name = "user_name", columnDefinition = "varchar(20) comment '车主姓名'")
    private String userName;

    @ApiModelProperty("车主手机号")
    @Column(name = "user_phone", columnDefinition = "varchar(20) comment '车主手机号'")
    private String userPhone;
    
    // 新加的四个字段： 车主身份证号、车主性别、车主地区、车主生日
    @ApiModelProperty("车主身份证号")
    @Column(name = "user_idcard", columnDefinition = "varchar(30) comment '车主身份证号'")
    private String userIdCard;
    
    @ApiModelProperty("车主性别")
    @Column(name = "user_sex", columnDefinition = "varchar(1) comment '车主性别'")
    private String userSex;
    
    @ApiModelProperty("车主地区")
    @Column(name = "user_area", columnDefinition = "varchar(400) comment '车主地区'")
    private String userArea;
    
    @ApiModelProperty("车主生日")
    @Column(name = "user_birthday", columnDefinition = "datetime default null comment '车主生日'")
    private LocalDate userBirthday;

    @ApiModelProperty("购买金额")
    @Column(name = "vehicle_buy_price", columnDefinition = "decimal(10,2) comment '购买金额'")
    private BigDecimal vehicleBuyPrice;
    

    @ApiModelProperty("车架号")
    @Column(name = "vehicle_no", columnDefinition = "varchar(50) comment '车架号'")
    private String vehicleNo;

    @ApiModelProperty("车型")
    @Column(name = "vehicle_type", columnDefinition = "varchar(100) comment '车型'")
    private String vehicleType;

    @ApiModelProperty("整车类型")
    @Column(name = "item_type3", columnDefinition = "varchar(100) comment '整车类型'")
    private String itemType3;

    @ApiModelProperty("车辆来源")
    @Column(name = "vehicle_source", columnDefinition = "int(1) comment '车辆来源 1-立马 0-非立马'")
    private Integer vehicleSource;

    @ApiModelProperty("绑定时间")
    @Column(name = "binding_time", columnDefinition = "datetime default null comment '绑定时间'")
    private LocalDateTime bindingTime;

    @ApiModelProperty("电池编号")
    @Column(name = "battery_num", columnDefinition = "varchar(50) comment '电池编号'")
    private String batteryNum;

    @ApiModelProperty("销售门店名称")
    @Column(name = "sales_outlets_name", columnDefinition = "varchar(100) comment '销售门店名称'")
    private String salesOutletsName;

    @ApiModelProperty("销售门店编码")
    @Column(name = "sales_outlets_code", columnDefinition = "varchar(50) comment '销售门店编码'")
    private String salesOutletsCode;

    @ApiModelProperty("销售门店业务区域")
    @Column(name = "sales_outlets_region", columnDefinition = "varchar(50) comment '销售门店业务区域'")
    private String salesOutletsRegion;

    @ApiModelProperty("销售门店业务区域名称")
    @Column(name = "sales_outlets_region_name", columnDefinition = "varchar(50) comment '销售门店业务区域名称'")
    private String salesOutletsRegionName;

    @ApiModelProperty("销售门店区域经理")
    @Column(name = "regional_manager", columnDefinition = "varchar(50) comment '销售门店区域经理'")
    private String regionalManager;

    @ApiModelProperty("销售门店省区经理")
    @Column(name = "provincial_manager", columnDefinition = "varchar(50) comment '销售门店省区经理'")
    private String provincialManager;

    @ApiModelProperty("销售总监")
    @Column(name = "sales_director", columnDefinition = "varchar(50) comment '销售总监'")
    private String salesDirector;

    @ApiModelProperty("购买日期")
    @Column(name = "purchase_time", columnDefinition = "datetime default null comment '购买日期'")
    private LocalDateTime purchaseTime;

    @ApiModelProperty("品牌名称")
    @Column(name = "brand_name", columnDefinition = "varchar(50) comment '品牌名称'")
    private String brandName;

    @ApiModelProperty("三包卡号")
    @Column(name = "maintain_card_no", columnDefinition = "varchar(50) comment '三包卡号'")
    private String maintainCardNo;

    @ApiModelProperty("活动编号")
    @Column(name = "activity_num", columnDefinition = "varchar(50) comment '活动编号'")
    private String activityNum;

    @ApiModelProperty("车辆规格")
    @Column(name = "vehicle_specs", columnDefinition = "varchar(255) comment '车辆规格'")
    private String vehicleSpecs;

    @ApiModelProperty("车辆颜色")
    @Column(name = "vehicle_color", columnDefinition = "varchar(50) comment '车辆颜色'")
    private String vehicleColor;

    @ApiModelProperty("电机号")
    @Column(name = "machine_no", columnDefinition = "varchar(50) comment '电机号'")
    private String machineNo;

    @ApiModelProperty("控制器号")
    @Column(name = "control_no", columnDefinition = "varchar(50) comment '控制器号'")
    private String controlNo;

    @ApiModelProperty("报警器号")
    @Column(name = "alarm_no", columnDefinition = "varchar(50) comment '报警器号'")
    private String alarmNo;

    @ApiModelProperty("商品ID")
    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @ApiModelProperty("商品code")
    @Column(name = "item_code", columnDefinition = "varchar(255) comment '商品code'")
    private String itemCode;


    @ApiModelProperty("生产日期")
    @Column(name = "manufacture_date", columnDefinition = "datetime default null comment '生产日期'")
    private LocalDateTime manufactureDate;

    @ApiModelProperty("销售门店ID")
    @Column(name = "sales_outlets_id", columnDefinition = "bigint(20) comment '销售门店ID'")
    private Long salesOutletsId;

    @ApiModelProperty("库存物料(商品编码)")
    @Column(name = "inv_matter", columnDefinition = "varchar(255) comment '库存物料(商品编码)'")
    private String invMatter;

    @ApiModelProperty("库存物料(商品编码)")
    @Column(name = "mtnrv", columnDefinition = "varchar(255) comment '库存物料(商品编码)'")
    private String mtnrv;

    @ApiModelProperty("整车序列号")
    @Column(name = "vehicle_seq", columnDefinition = "varchar(255) comment '整车序列号'")
    private String vehicleSeq;

    @ApiModelProperty("E智行号")
    @Column(name = "e_no", columnDefinition = "varchar(255) comment 'E智行号'")
    private String eNo;

    @ApiModelProperty("来源系统类型")
    @Column(name = "source_sys_type", columnDefinition = "varchar(50) comment '来源系统类型'")
    private String sourceSysType;

    @ApiModelProperty("生产订单号")
    @Column(name = "produce_order_no", columnDefinition = "varchar(255) comment '生产订单号'")
    private String produceOrderNo;

    @ApiModelProperty("下线日期")
    @Column(name = "offline_date", columnDefinition = "datetime default null comment '下线日期'")
    private LocalDateTime offlineDate;

    @ApiModelProperty("客户编号")
    @Column(name = "cust_code", columnDefinition = "varchar(255) comment '客户编号'")
    private String custCode;

    @ApiModelProperty("客户号")
    @Column(name = "cust_code2", columnDefinition = "varchar(255) comment '客户号'")
    private String custCode2;

    @ApiModelProperty("客户简称")
    @Column(name = "cust_abbr", columnDefinition = "varchar(255) comment '客户简称'")
    private String custAbbr;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_ame", columnDefinition = "varchar(255) comment '客户名称'")
    private String custName;

    @ApiModelProperty("业务员编号")
    @Column(name = "salesman_no", columnDefinition = "varchar(255) comment '业务员编号'")
    private String salesmanNo;

    @ApiModelProperty("业务员名称")
    @Column(name = "salesman_name", columnDefinition = "varchar(255) comment '业务员名称'")
    private String salesmanName;

    @ApiModelProperty("区域经理编号")
    @Column(name = "remanage_no", columnDefinition = "varchar(255) comment '区域经理编号'")
    private String remanageNo;

    @ApiModelProperty("省区经理编号")
    @Column(name = "prmanager_no", columnDefinition = "varchar(255) comment '省区经理编号'")
    private String prmanagerNo;

    @ApiModelProperty("总监编号")
    @Column(name = "chief_no", columnDefinition = "varchar(255) comment '总监编号'")
    private String chiefNo;


    @ApiModelProperty("激活标志")
    @Column(name = "activat_flag", columnDefinition = "tinyint(1) comment '激活标志'")
    private Boolean activatFlag;


    @Column(name = "source_platform", columnDefinition = "varchar(50) comment '来源平台'")
    private String sourcePlatform;



    @ApiModelProperty("激活日期")
    @Column(name = "activat_time", columnDefinition = "datetime default null comment '激活日期'")
    private LocalDateTime activatTime;

}
