package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author RYH
 * @date 2023/2/14
 */
@EqualsAndHashCode(callSuper = true)
@Entity
@Table(name = "order_evaluation",indexes = {@Index(name = "idx_order_id",columnList = "order_id,tenantId",unique = true)})
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "order_evaluation", comment = "工单评价")
@Data
@Accessors(chain = true)
@ApiModel(value = "工单评价", description = "工单评价")
@Where(clause = "delete_flag = 0")
public class OrderEvaluationDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("评价级别(1：满意，2：不满意)")
    @Column(name = "evaluation_level", columnDefinition = "varchar(40)  comment '评价级别(1：满意，2：不满意)'")
    private String evaluationLevel;

    @ApiModelProperty("评语")
    @Column(name = "evaluation_content", columnDefinition = "varchar(255)  comment '评语'")
    private String evaluationContent;

    @ApiModelProperty("工单id")
    @Column(name = "order_id", columnDefinition = "bigint  comment '工单id'")
    private Long orderId;

    @ApiModelProperty("工单类型(1：维修工单，2：客诉工单)")
    @Column(name = "order_type", columnDefinition = "varchar(40)  comment '工单类型(1：维修工单，2：客诉工单)'")
    private String orderType;

    @ApiModelProperty("回访满意度")
    @Column(name = "return_level", columnDefinition = "varchar(40)  comment '回访满意度'")
    private String returnLevel;

    @ApiModelProperty("改善意见")
    @Column(name = "return_advice", columnDefinition = "varchar(255)  comment '改善意见'")
    private String returnAdvice;

    @ApiModelProperty("处理回复")
    @Column(name = "return_reply", columnDefinition = "varchar(255)  comment '处理回复'")
    private String returnReply;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof OrderEvaluationDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
